/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.EventResult;
import dev.architectury.platform.Platform;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import smartin.miapi.Miapi;
import smartin.miapi.blueprint.BlueprintComponent;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.editor.EditorEvents;
import smartin.miapi.editor.HumanoidPoseAnimationRegistryEditor;
import smartin.miapi.editor.JsonEditor;
import smartin.miapi.editor.LiveDataPackEditorManager;
import smartin.miapi.editor.MiapiEditor;
import smartin.miapi.editor.ModuleEditor;
import smartin.miapi.editor.NucleusEditor;
import smartin.miapi.editor.VeilEditor;
import smartin.miapi.editor.material.MaterialEditor;
import smartin.miapi.editor.syntax.CodecValidatorInterface;
import smartin.miapi.editor.syntax.JsonSyntaxHighlighter;
import smartin.miapi.editor.syntax.PropertyMapHighlighter;
import smartin.miapi.material.CodecMaterial;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.key.MiapiBinding;
import smartin.miapi.modules.synergies.SynergyManager;

public class EditorCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder runPose = (LiteralArgumentBuilder)class_2170.method_9247((String)"miapi").then(class_2170.method_9247((String)"editor").then(class_2170.method_9247((String)"hand").executes(EditorCommands::executeHandEditor)));
        LiteralArgumentBuilder fs = (LiteralArgumentBuilder)class_2170.method_9247((String)"miapi").then(class_2170.method_9247((String)"editor").then(class_2170.method_9247((String)"data").executes(EditorCommands::executeOpenEditor)));
        LiteralArgumentBuilder materialEditor = (LiteralArgumentBuilder)class_2170.method_9247((String)"miapi").then(class_2170.method_9247((String)"editor").then(class_2170.method_9247((String)"material").executes(EditorCommands::executeOpenMaterialEditor)));
        LiteralArgumentBuilder poseEditor = (LiteralArgumentBuilder)class_2170.method_9247((String)"miapi").then(class_2170.method_9247((String)"editor").then(class_2170.method_9247((String)"pose").executes(EditorCommands::executeOpenPoseEditor)));
        dispatcher.register(runPose);
        dispatcher.register(fs);
        dispatcher.register(materialEditor);
        dispatcher.register(poseEditor);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClient() {
        JsonEditor.registerGlobalInterface(new JsonSyntaxHighlighter());
        JsonEditor.registerGlobalInterface(new PropertyMapHighlighter());
        CodecValidatorInterface synergyValidator = new CodecValidatorInterface(SynergyManager.SYNERGY_CODEC, "Synergy Validator");
        JsonEditor.registerGlobalInterface(synergyValidator);
        EditorEvents.EDITOR_INTERFACES.register(event -> {
            if (event.filePath.endsWith(".json")) {
                event.interfaces.add(new JsonSyntaxHighlighter());
            }
            return EventResult.pass();
        });
        EditorEvents.EDITOR_INTERFACES.register(event -> {
            if (event.resourceLocation != null && event.resourceLocation.method_12832().startsWith("miapi/modules/")) {
                event.interfaces.add(new PropertyMapHighlighter(event.resourceLocation));
            }
            if (event.resourceLocation != null && event.resourceLocation.method_12832().startsWith("miapi/synergies/")) {
                event.interfaces.add(new CodecValidatorInterface(SynergyManager.SYNERGY_CODEC, "Synergy Validator"));
            }
            if (event.resourceLocation != null && event.resourceLocation.method_12832().startsWith("miapi/modular_converters/")) {
                event.interfaces.add(new CodecValidatorInterface(ModuleInstance.CODEC, "Modular Converter Validator"));
            }
            if (event.resourceLocation != null && event.resourceLocation.method_12832().startsWith("miapi/material/")) {
                event.interfaces.add(new CodecValidatorInterface(CodecMaterial.CODEC, "Material Validator"));
            }
            if (event.resourceLocation != null && event.resourceLocation.method_12832().startsWith("miapi/blueprints/")) {
                event.interfaces.add(new CodecValidatorInterface(BlueprintComponent.CODEC, "Blueprint Validator"));
            }
            if (event.resourceLocation != null && event.resourceLocation.method_12832().startsWith("miapi/key_binding")) {
                event.interfaces.add(new CodecValidatorInterface(MiapiBinding.CODEC, "KeyBind Validator"));
            }
            if (event.resourceLocation == null || event.resourceLocation.method_12832().startsWith("miapi/create_options/")) {
                // empty if block
            }
            if (event.resourceLocation == null || event.resourceLocation.method_12832().startsWith("miapi/material_extension/")) {
                // empty if block
            }
            if (event.resourceLocation == null || event.resourceLocation.method_12832().startsWith("miapi/module_extension/")) {
                // empty if block
            }
            if (event.resourceLocation == null || event.resourceLocation.method_12832().startsWith("miapi/skin/module")) {
                // empty if block
            }
            if (event.resourceLocation == null || event.resourceLocation.method_12832().startsWith("miapi/skin/tab")) {
                // empty if block
            }
            return EventResult.pass();
        });
        if (Platform.isModLoaded((String)"veil")) {
            VeilEditor.setup();
        } else if (Platform.isModLoaded((String)"nucleus_editor")) {
            NucleusEditor.setup();
        } else if (MiapiConfig.getClientConfig().other.allowEditorNoNucleus) {
            // empty if block
        }
    }

    private static int executeHandEditor(CommandContext<class_2168> context) {
        return EditorCommands.canExecute(context, c -> {
            class_1799 itemStack = ((class_2168)context.getSource()).method_44023().method_5998(class_1268.field_5808);
            ModuleInstance moduleInstance = ItemModule.getModules(itemStack);
            if (moduleInstance != null) {
                ModuleEditor moduleEditor = new ModuleEditor(moduleInstance.copy(), m -> m.copy().writeToItem(itemStack));
                MiapiEditor.editors.add(moduleEditor);
                return 1;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Hand Item is not a valid modular item!"));
            return -1;
        });
    }

    private static int executeOpenPoseEditor(CommandContext<class_2168> context) {
        return EditorCommands.canExecute(context, c -> {
            MiapiEditor.editors.add(new HumanoidPoseAnimationRegistryEditor());
            return 1;
        });
    }

    private static int executeOpenEditor(CommandContext<class_2168> context) {
        return EditorCommands.canExecute(context, c -> {
            LiveDataPackEditorManager.openLivePackEditor();
            return 1;
        });
    }

    private static int executeOpenMaterialEditor(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Material editor is not yet finished!"));
        return 1;
    }

    public static int canExecute(CommandContext<class_2168> context, Function<CommandContext<class_2168>, Integer> onExecute) {
        if (((class_2168)context.getSource()).method_43737()) {
            if (Platform.getEnv().equals((Object)EnvType.SERVER)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Command only allowed in SinglePlayer"));
                return -1;
            }
            if (!class_310.method_1551().field_1724.method_5667().equals(((class_2168)context.getSource()).method_44023().method_5667())) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Command only allowed in SinglePlayer"));
                return -1;
            }
            if (!((class_2168)context.getSource()).method_9259(4)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Command only allowed for operators"));
                return -1;
            }
            if (!MiapiConfig.getClientConfig().other.allowEditorNoNucleus && !Platform.isModLoaded((String)"nucleus_editor")) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Requires Nucleus Editor to be installed!"));
                return -1;
            }
            return onExecute.apply(context);
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Only Player can execute this command!"));
        return -1;
    }

    private static /* synthetic */ Integer lambda$executeOpenMaterialEditor$7(CommandContext c) {
        MiapiEditor.editors.add(new MaterialEditor((CodecMaterial)MaterialProperty.MATERIAL_REGISTRY.get(Miapi.id("metal/iron")), m -> {}));
        return 1;
    }
}

