/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor;

import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import smartin.miapi.Miapi;
import smartin.miapi.editor.JsonEditor;
import smartin.miapi.editor.MiapiEditor;

public class FileSystemViewer
implements MiapiEditor {
    private final ImBoolean show = new ImBoolean(true);
    private final List<FileNode> rootNodes = new ArrayList<FileNode>();
    private JsonEditor jsonEditor;
    private final File rootDirectory;
    private final ImString newFolderName = new ImString(64);
    private final ImString newFileName = new ImString(64);
    private final ImBoolean showNewFolderPopup = new ImBoolean(false);
    private final ImBoolean showNewFilePopup = new ImBoolean(false);
    Consumer<File> changed;

    public FileSystemViewer(File rootDirectory, Consumer<File> changed) {
        this.rootDirectory = rootDirectory;
        this.updateFileList();
        this.changed = changed;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    private void updateFileList() {
        this.rootNodes.clear();
        File[] files = this.rootDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                this.rootNodes.add(new FileNode(file, file.getName(), (f, node) -> this.openJsonFile((File)f, node.relativePath)));
            }
        }
        this.rootNodes.sort((a, b) -> {
            if (a.isDirectory && !b.isDirectory) {
                return -1;
            }
            if (!a.isDirectory && b.isDirectory) {
                return 1;
            }
            return a.name.compareTo(b.name);
        });
    }

    private void createNewFolder() {
        File newFolder;
        String folderName = this.newFolderName.get().trim();
        if (!folderName.isEmpty() && !(newFolder = new File(this.rootDirectory, folderName)).exists() && newFolder.mkdir()) {
            this.updateFileList();
            this.showNewFolderPopup.set(false);
            this.newFolderName.clear();
        }
    }

    private void createNewFile() {
        Object fileName = this.newFileName.get().trim();
        if (!((String)fileName).isEmpty()) {
            File newFile;
            if (!((String)fileName).endsWith(".json")) {
                fileName = (String)fileName + ".json";
            }
            if (!(newFile = new File(this.rootDirectory, (String)fileName)).exists()) {
                try {
                    Files.writeString(newFile.toPath(), (CharSequence)"{}", new OpenOption[0]);
                    this.updateFileList();
                    this.showNewFilePopup.set(false);
                    this.newFileName.clear();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void render(class_332 guiGraphics, class_9779 deltaTracker) {
        if (!this.show.get()) {
            MiapiEditor.editors.remove(this);
            return;
        }
        ImGui.setNextWindowSize((float)800.0f, (float)600.0f, (int)4);
        if (ImGui.begin((String)("File System Viewer##" + System.identityHashCode(this)), (ImBoolean)this.show)) {
            ImGui.separator();
            this.renderFileTree();
            ImGui.end();
        }
        if (this.showNewFolderPopup.get()) {
            ImGui.setNextWindowSize((float)300.0f, (float)100.0f, (int)4);
            if (ImGui.begin((String)"Create New Folder", (ImBoolean)this.showNewFolderPopup)) {
                ImGui.inputText((String)"Folder Name", (ImString)this.newFolderName);
                if (ImGui.button((String)"Create")) {
                    this.createNewFolder();
                }
                ImGui.sameLine();
                if (ImGui.button((String)"Cancel")) {
                    this.showNewFolderPopup.set(false);
                    this.newFolderName.clear();
                }
                ImGui.end();
            }
        }
        if (this.showNewFilePopup.get()) {
            ImGui.setNextWindowSize((float)300.0f, (float)100.0f, (int)4);
            if (ImGui.begin((String)"Create New File", (ImBoolean)this.showNewFilePopup)) {
                ImGui.inputText((String)"File Name", (ImString)this.newFileName);
                ImGui.text((String)"Note: .json will be added automatically if not specified");
                if (ImGui.button((String)"Create")) {
                    this.createNewFile();
                }
                ImGui.sameLine();
                if (ImGui.button((String)"Cancel")) {
                    this.showNewFilePopup.set(false);
                    this.newFileName.clear();
                }
                ImGui.end();
            }
        }
        if (this.jsonEditor != null) {
            this.jsonEditor.render(guiGraphics, deltaTracker);
        }
    }

    private void renderFileTree() {
        for (FileNode node : this.rootNodes) {
            node.render();
        }
    }

    private void openJsonFile(File file, String relativePath) {
        FileSystemViewer.openJsonFile(file, relativePath, this.changed);
    }

    public static void openJsonFile(File file, String relativePath, Consumer<File> onChange) {
        try {
            String content = Files.readString(file.toPath());
            String pathWithoutExt = relativePath.replace(".json", "").replace("\\", "/");
            pathWithoutExt = pathWithoutExt.replaceFirst("/", ":");
            class_2960 resourceLocation = Miapi.id(pathWithoutExt);
            JsonEditor jsonEditor = new JsonEditor(content, newContent -> onChange.accept(file), file.toPath(), resourceLocation);
            if (file.getName().endsWith(".java")) {
                jsonEditor.setReadOnly(true);
            }
            MiapiEditor.editors.add(jsonEditor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class FileNode {
        private final File file;
        private final String name;
        private final boolean isDirectory;
        private final BiConsumer<File, FileNode> onFileClick;
        private final List<FileNode> children = new ArrayList<FileNode>();
        private boolean isExpanded = false;
        private String relativePath;

        public FileNode(File file, String relativePath, BiConsumer<File, FileNode> onFileClick) {
            this.file = file;
            this.name = file.getName();
            this.isDirectory = file.isDirectory();
            this.onFileClick = onFileClick;
            this.relativePath = relativePath;
            if (this.isDirectory) {
                this.loadChildren();
            }
        }

        private void loadChildren() {
            File[] files = this.file.listFiles();
            if (files != null) {
                for (File childFile : files) {
                    this.children.add(new FileNode(childFile, this.relativePath + "/" + childFile.getName(), this.onFileClick));
                }
                this.children.sort((a, b) -> {
                    if (a.isDirectory && !b.isDirectory) {
                        return -1;
                    }
                    if (!a.isDirectory && b.isDirectory) {
                        return 1;
                    }
                    return a.name.compareTo(b.name);
                });
            }
        }

        public void render() {
            if (this.isDirectory) {
                if (ImGui.treeNode((String)(this.name + "/"))) {
                    this.isExpanded = true;
                    for (FileNode child : this.children) {
                        child.render();
                    }
                    ImGui.treePop();
                } else {
                    this.isExpanded = false;
                }
            } else if (ImGui.treeNodeEx((String)this.name)) {
                if (ImGui.isItemClicked() && this.name.endsWith(".json")) {
                    this.onFileClick.accept(this.file, this);
                }
                ImGui.treePop();
            }
        }
    }
}

