/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.redpxnda.nucleus.math.InterpolateMode;
import com.redpxnda.nucleus.pose.client.HumanoidPoseAnimation;
import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImInt;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import smartin.miapi.editor.MiapiEditor;
import smartin.miapi.editor.renderers.FrameEditor;

public class HumanoidPoseAnimationEditor
implements MiapiEditor {
    private final HumanoidPoseAnimation animation;
    private final class_2960 id;
    private final Consumer<HumanoidPoseAnimation> onChange;
    private final ImBoolean show = new ImBoolean(true);
    private final List<FrameEditor> frameEditors = new ArrayList<FrameEditor>();

    public HumanoidPoseAnimationEditor(class_2960 id, HumanoidPoseAnimation animation, Consumer<HumanoidPoseAnimation> onChange) {
        this.id = id;
        this.animation = animation;
        this.onChange = onChange;
        this.rebuildEditors();
    }

    @Override
    public void render(class_332 guiGraphics, class_9779 deltaTracker) {
        if (!this.show.get()) {
            MiapiEditor.editors.remove(this);
            return;
        }
        ImGui.begin((String)("Animation Editor: " + this.id.toString() + "##" + System.identityHashCode(this)), (ImBoolean)this.show);
        ImGui.text((String)("ID: " + this.id.toString()));
        ImGui.separator();
        ImGui.text((String)"Frames:");
        for (int i = 0; i < this.frameEditors.size(); ++i) {
            this.frameEditors.get(i).render();
        }
        if (ImGui.button((String)"Add Frame")) {
            HumanoidPoseAnimation.Frame newFrame = new HumanoidPoseAnimation.Frame();
            newFrame.interpolate = ((InterpolateMode.Creator)InterpolateMode.interpolateModes.get("easeInOut")).createFrom((JsonElement)new JsonPrimitive("easeInOut"));
            this.animation.frames.add(newFrame);
            newFrame.endTime = this.animation.frames.isEmpty() ? 1.0f : ((HumanoidPoseAnimation.Frame)this.animation.frames.getLast()).endTime + 1.0f;
            this.rebuildEditors();
            this.triggerChange();
        }
        ImGui.separator();
        ImInt loops = new ImInt(this.animation.loops);
        if (ImGui.inputInt((String)"Loops", (ImInt)loops)) {
            this.animation.loops = loops.get();
            this.triggerChange();
        }
        ImGui.end();
    }

    private void triggerChange() {
        this.animation.length = !this.animation.frames.isEmpty() ? ((HumanoidPoseAnimation.Frame)this.animation.frames.getLast()).endTime : 0.0f;
        this.onChange.accept(this.animation);
    }

    @Override
    public void close() {
        MiapiEditor.editors.remove(this);
    }

    public class_2960 getId() {
        return this.id;
    }

    private void rebuildEditors() {
        this.frameEditors.clear();
        int i = 0;
        while (i < this.animation.frames.size()) {
            HumanoidPoseAnimation.Frame frame = (HumanoidPoseAnimation.Frame)this.animation.frames.get(i);
            int index = i++;
            this.frameEditors.add(new FrameEditor(frame, f -> this.triggerChange(), () -> {
                this.animation.frames.remove(index);
                this.rebuildEditors();
                this.triggerChange();
            }));
        }
    }
}

