/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.redpxnda.nucleus.pose.client.HumanoidPoseAnimation;
import com.redpxnda.nucleus.pose.client.PoseAnimationResourceListener;
import imgui.ImGui;
import imgui.type.ImBoolean;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import smartin.miapi.Miapi;
import smartin.miapi.editor.HumanoidPoseAnimationEditor;
import smartin.miapi.editor.MiapiEditor;

public class HumanoidPoseAnimationRegistryEditor
implements MiapiEditor {
    private static final String BASE_TITLE = "Humanoid Pose Animation Registry";
    private final ImBoolean show = new ImBoolean(true);

    @Override
    public void render(class_332 guiGraphics, class_9779 deltaTracker) {
        if (!this.show.get()) {
            MiapiEditor.editors.remove(this);
            return;
        }
        ImGui.begin((String)("Humanoid Pose Animation Registry##" + System.identityHashCode(this)), (ImBoolean)this.show);
        ImGui.text((String)"Registered Animations:");
        ImGui.separator();
        for (Map.Entry entry : PoseAnimationResourceListener.animations.entrySet()) {
            String key = (String)entry.getKey();
            HumanoidPoseAnimation animation = (HumanoidPoseAnimation)entry.getValue();
            ImGui.pushID((String)key);
            ImGui.text((String)key);
            ImGui.sameLine();
            if (ImGui.button((String)"Edit")) {
                class_2960 id = Miapi.id(key);
                HumanoidPoseAnimationEditor editor = new HumanoidPoseAnimationEditor(id, animation, updated -> PoseAnimationResourceListener.animations.put(key, updated));
                MiapiEditor.editors.add(editor);
            }
            ImGui.sameLine();
            if (ImGui.button((String)"Export")) {
                this.exportAnimation(key, animation);
            }
            ImGui.sameLine();
            if (ImGui.button((String)"Remove")) {
                PoseAnimationResourceListener.animations.remove(key);
                break;
            }
            ImGui.popID();
        }
        ImGui.separator();
        if (ImGui.button((String)"Add New Animation")) {
            this.createExample();
        }
        ImGui.end();
    }

    @Override
    public void close() {
        MiapiEditor.editors.remove(this);
    }

    private void createExample() {
        HumanoidPoseAnimation animation = (HumanoidPoseAnimation)((Pair)HumanoidPoseAnimation.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).getOrThrow()).getFirst();
        String baseName = "new_animation";
        Object name = baseName;
        int counter = 1;
        while (PoseAnimationResourceListener.animations.containsKey(name)) {
            name = baseName + "_" + counter++;
        }
        String finalName = name;
        PoseAnimationResourceListener.animations.put(name, animation);
        class_2960 id = Miapi.id("custom", (String)name);
        HumanoidPoseAnimationEditor editor = new HumanoidPoseAnimationEditor(id, animation, updated -> PoseAnimationResourceListener.animations.put(finalName, updated));
        MiapiEditor.editors.add(editor);
    }

    private void exportAnimation(String key, HumanoidPoseAnimation animation) {
        String data = ((JsonElement)HumanoidPoseAnimation.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)animation).getOrThrow()).toString();
        class_310.method_1551().field_1774.method_1455(data);
        class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)("Exported animation '" + key + "' to clipboard.")));
    }
}

