/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import imgui.ImGui;
import java.util.Optional;
import net.minecraft.class_2960;
import smartin.miapi.editor.util.JsonEditor;
import smartin.miapi.material.CodecMaterial;

public class IconEditor {
    private final CodecMaterial material;
    private final JsonEditor jsonEditor;

    public IconEditor(CodecMaterial material) {
        this.material = material;
        JsonElement initialValue = material.iconJson.orElse((JsonElement)new JsonPrimitive(""));
        this.jsonEditor = new JsonEditor("Icon", initialValue);
    }

    public void render() {
        this.jsonEditor.render();
        try {
            JsonElement element = this.jsonEditor.getValue();
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                String value = element.getAsString();
                if (!value.isEmpty()) {
                    try {
                        class_2960.method_60654((String)value);
                        this.material.iconJson = Optional.of(element);
                    }
                    catch (Exception e) {
                        ImGui.text((String)"Invalid resource location!");
                    }
                } else {
                    this.material.iconJson = Optional.empty();
                }
            } else {
                this.material.iconJson = Optional.of(element);
            }
        }
        catch (Exception e) {
            ImGui.text((String)("Failed to parse icon: " + e.getMessage()));
        }
    }
}

