/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import smartin.miapi.Miapi;
import smartin.miapi.editor.JsonEditor;
import smartin.miapi.editor.MiapiEditor;
import smartin.miapi.material.CodecMaterial;
import smartin.miapi.material.MaterialProperty;

public class MaterialListViewer
implements MiapiEditor {
    private final File materialsDirectory;
    private final ImBoolean show = new ImBoolean(true);
    private final ImString newMaterialName = new ImString(128);

    public MaterialListViewer(File datapackDirectory, Runnable onChange) {
        this.materialsDirectory = datapackDirectory;
        if (!this.materialsDirectory.exists()) {
            this.materialsDirectory.mkdirs();
        }
    }

    @Override
    public void render(class_332 guiGraphics, class_9779 deltaTracker) {
        if (!this.show.get()) {
            MiapiEditor.editors.remove(this);
            return;
        }
        ImGui.setNextWindowSize((float)500.0f, (float)400.0f, (int)4);
        if (ImGui.begin((String)"Materials", (ImBoolean)this.show)) {
            String name;
            ImGui.inputText((String)"New Material ID", (ImString)this.newMaterialName);
            ImGui.sameLine();
            if (ImGui.button((String)"Create") && !(name = this.newMaterialName.get().trim()).isEmpty()) {
                try {
                    class_2960 id = Miapi.id(name);
                    File newFile = new File(this.materialsDirectory, id.method_12836() + "/miapi/materials/" + id.method_12832() + ".json");
                    if (!newFile.exists()) {
                        newFile.getParentFile().mkdirs();
                        newFile.createNewFile();
                        CodecMaterial newMaterial = (CodecMaterial)((Pair)CodecMaterial.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).getOrThrow()).getFirst();
                        newMaterial.setID(id);
                        MaterialListViewer.writeToFile(newMaterial, newFile);
                        JsonEditor jsonEditor = new JsonEditor(Files.readString(newFile.toPath()), newContent -> MaterialListViewer.writeToFile(newMaterial, newFile), newFile.toPath(), Miapi.id(id.method_12836() + ":" + id.method_12832() + "/miapi/materials"));
                        MiapiEditor.editors.add(jsonEditor);
                    }
                }
                catch (Exception e) {
                    ImGui.textColored((int)1, (int)0, (int)0, (int)1, (String)("Failed to create material: " + e.getMessage()));
                }
            }
            ImGui.separator();
            if (this.materialsDirectory.exists()) {
                ArrayList<File> materialFiles = new ArrayList<File>();
                this.scanAllMaterialFiles(this.materialsDirectory, materialFiles);
                materialFiles.sort(Comparator.comparing(File::getAbsolutePath));
                for (File file : materialFiles) {
                    String relativePath = this.materialsDirectory.toPath().relativize(file.toPath()).toString();
                    if (!ImGui.selectable((String)relativePath)) continue;
                    try {
                        CodecMaterial material = MaterialListViewer.readFromFile(this.materialsDirectory, file);
                        if (MaterialProperty.MATERIAL_REGISTRY.get(material.getID()) != null) {
                            material = (CodecMaterial)MaterialProperty.MATERIAL_REGISTRY.get(material.getID());
                        }
                        if (material != null) {
                            String pathWithoutExt = relativePath.replace(".json", "").replace("\\", "/");
                            pathWithoutExt = pathWithoutExt.replaceFirst("/", ":");
                            class_2960 resourceLocation = Miapi.id(pathWithoutExt);
                            CodecMaterial codecMaterial = material;
                            JsonEditor jsonEditor = new JsonEditor(Files.readString(file.toPath()), newContent -> MaterialListViewer.writeToFile(codecMaterial, file), file.toPath(), resourceLocation);
                            MiapiEditor.editors.add(jsonEditor);
                            continue;
                        }
                        ImGui.textColored((int)1, (int)0, (int)0, (int)1, (String)("Failed to load " + relativePath));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        ImGui.textColored((int)1, (int)0, (int)0, (int)1, (String)("Error opening file " + relativePath));
                    }
                }
                if (materialFiles.isEmpty()) {
                    ImGui.text((String)"No materials found.");
                }
            } else {
                ImGui.text((String)"miapi/materials directory not found.");
            }
        }
        ImGui.end();
    }

    private void scanAllMaterialFiles(File dataFolder, List<File> result) {
        File[] namespaces = dataFolder.listFiles(File::isDirectory);
        if (namespaces == null) {
            return;
        }
        for (File namespaceFolder : namespaces) {
            File materialRoot = new File(namespaceFolder, "miapi/materials");
            if (!materialRoot.exists() || !materialRoot.isDirectory()) continue;
            this.scanMaterialFiles(materialRoot, result);
        }
    }

    private void scanMaterialFiles(File dir, List<File> result) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.scanMaterialFiles(file, result);
                continue;
            }
            if (!file.getName().endsWith(".json")) continue;
            result.add(file);
        }
    }

    public static CodecMaterial readFromFile(File dataDir, File file) {
        CodecMaterial codecMaterial;
        FileReader reader = new FileReader(file);
        try {
            JsonElement json = JsonParser.parseReader((Reader)reader);
            DataResult result = CodecMaterial.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            CodecMaterial material = result.result().orElse(null);
            if (material != null) {
                class_2960 id = MaterialListViewer.inferMaterialId(dataDir, file);
                material.setID(id);
            }
            codecMaterial = material;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Miapi.LOGGER.error("Failed to read CodecMaterial from file: {}", (Object)file.getAbsolutePath(), (Object)e);
                return null;
            }
        }
        reader.close();
        return codecMaterial;
    }

    private static class_2960 inferMaterialId(File dataDir, File materialFile) throws IOException {
        String dataPath = dataDir.getCanonicalPath();
        String materialPath = materialFile.getCanonicalPath();
        if (!materialPath.startsWith(dataPath)) {
            throw new IOException("Material file is not under the data directory");
        }
        String relative = materialPath.substring(dataPath.length() + 1);
        String[] parts = relative.split(File.separator.equals("\\") ? "\\\\" : File.separator, 2);
        if (parts.length < 2) {
            throw new IOException("Invalid material file structure: " + relative);
        }
        String namespace = parts[0];
        String insidePath = parts[1];
        String prefix = "miapi" + File.separator + "materials" + File.separator;
        if (!insidePath.startsWith(prefix)) {
            throw new IOException("Material not in miapi/materials: " + insidePath);
        }
        String materialIdPath = insidePath.substring(prefix.length()).replaceAll("\\.json$", "").replace(File.separatorChar, '/');
        return class_2960.method_60655((String)namespace, (String)materialIdPath);
    }

    public static void writeToFile(CodecMaterial material, File file) {
        try (FileWriter writer = new FileWriter(file);){
            DataResult encoded = CodecMaterial.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)material);
            JsonElement json = (JsonElement)encoded.result().orElseThrow(() -> new IOException("Failed to encode CodecMaterial"));
            Miapi.gson.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            Miapi.LOGGER.error("Failed to write CodecMaterial to file: {}", (Object)file.getAbsolutePath(), (Object)e);
        }
    }
}

