/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.renderers;

import com.redpxnda.nucleus.pose.client.HumanoidPoseAnimation;
import imgui.ImGui;
import java.util.EnumMap;
import java.util.function.Consumer;
import smartin.miapi.editor.renderers.PartStateEditor;

public class FrameEditor {
    private final HumanoidPoseAnimation.Frame frame;
    private final Consumer<HumanoidPoseAnimation.Frame> onChange;
    private final Runnable onDelete;
    private final EnumMap<PartType, PartStateEditor> editorCache = new EnumMap(PartType.class);

    public FrameEditor(HumanoidPoseAnimation.Frame frame, Consumer<HumanoidPoseAnimation.Frame> onChange, Runnable onDelete) {
        this.frame = frame;
        this.onChange = onChange;
        this.onDelete = onDelete;
    }

    public void render() {
        if (ImGui.collapsingHeader((String)("Frame##" + System.identityHashCode(this)))) {
            if (ImGui.button((String)("Delete Frame##deleteButton" + System.identityHashCode(this)))) {
                this.onDelete.run();
                return;
            }
            for (PartType type : PartType.values()) {
                HumanoidPoseAnimation.PartState part = this.getPart(type);
                if (part == null) continue;
                this.renderPart(type.name().replaceAll("([A-Z])", " $1").trim(), part, p -> this.setPart(type, (HumanoidPoseAnimation.PartState)p), type);
            }
            if (ImGui.beginCombo((String)("Add Part##partAdder" + System.identityHashCode(this)), (String)"Select...")) {
                for (PartType type : PartType.values()) {
                    if (this.getPart(type) != null || !ImGui.selectable((String)type.name())) continue;
                    this.setPart(type, this.createDefaultPartState());
                    this.triggerChange();
                }
                ImGui.endCombo();
            }
            ImGui.text((String)"End Time:");
            float[] endTime = new float[]{this.frame.endTime};
            if (ImGui.dragFloat((String)("##endTime" + System.identityHashCode(this)), (float[])endTime, (float)0.01f, (float)0.0f, (float)Float.MAX_VALUE)) {
                this.frame.endTime = endTime[0];
                this.triggerChange();
            }
        }
    }

    private HumanoidPoseAnimation.PartState getPart(PartType type) {
        switch (type.ordinal()) {
            case 0: {
                return this.frame.head;
            }
            case 1: {
                return this.frame.body;
            }
            case 2: {
                return this.frame.fpUsedArm;
            }
            case 3: {
                return this.frame.fpUnusedArm;
            }
            case 4: {
                return this.frame.fpRightArm;
            }
            case 5: {
                return this.frame.fpLeftArm;
            }
            case 6: {
                return this.frame.usedArm;
            }
            case 7: {
                return this.frame.unusedArm;
            }
            case 8: {
                return this.frame.rightArm;
            }
            case 9: {
                return this.frame.leftArm;
            }
            case 10: {
                return this.frame.usedItem;
            }
            case 11: {
                return this.frame.unusedItem;
            }
            case 12: {
                return this.frame.rightItem;
            }
            case 13: {
                return this.frame.leftItem;
            }
            case 14: {
                return this.frame.rightLeg;
            }
            case 15: {
                return this.frame.leftLeg;
            }
        }
        return null;
    }

    private void setPart(PartType type, HumanoidPoseAnimation.PartState state) {
        switch (type.ordinal()) {
            case 0: {
                this.frame.head = state;
                break;
            }
            case 1: {
                this.frame.body = state;
                break;
            }
            case 2: {
                this.frame.fpUsedArm = state;
                break;
            }
            case 3: {
                this.frame.fpUnusedArm = state;
                break;
            }
            case 4: {
                this.frame.fpRightArm = state;
                break;
            }
            case 5: {
                this.frame.fpLeftArm = state;
                break;
            }
            case 6: {
                this.frame.usedArm = state;
                break;
            }
            case 7: {
                this.frame.unusedArm = state;
                break;
            }
            case 8: {
                this.frame.rightArm = state;
                break;
            }
            case 9: {
                this.frame.leftArm = state;
                break;
            }
            case 10: {
                this.frame.usedItem = state;
                break;
            }
            case 11: {
                this.frame.unusedItem = state;
                break;
            }
            case 12: {
                this.frame.rightItem = state;
                break;
            }
            case 13: {
                this.frame.leftItem = state;
                break;
            }
            case 14: {
                this.frame.rightLeg = state;
                break;
            }
            case 15: {
                this.frame.leftLeg = state;
            }
        }
    }

    private void renderPart(String label, HumanoidPoseAnimation.PartState partState, Consumer<HumanoidPoseAnimation.PartState> setter, PartType type) {
        if (ImGui.treeNode((String)(label + "##" + System.identityHashCode(this)))) {
            PartStateEditor editor = this.editorCache.get((Object)type);
            if (partState == null) {
                this.editorCache.remove((Object)type);
            } else if (editor == null || editor.getMultiplier() != partState) {
                editor = new PartStateEditor(partState, updated -> {
                    setter.accept((HumanoidPoseAnimation.PartState)updated);
                    this.triggerChange();
                });
                this.editorCache.put(type, editor);
            }
            if (editor != null) {
                editor.render();
            }
            if (ImGui.button((String)("Delete " + label))) {
                setter.accept(null);
                this.editorCache.remove((Object)type);
                this.triggerChange();
                ImGui.treePop();
                return;
            }
            ImGui.treePop();
        }
    }

    private HumanoidPoseAnimation.PartState createDefaultPartState() {
        HumanoidPoseAnimation.PartState state = new HumanoidPoseAnimation.PartState();
        return state;
    }

    private void triggerChange() {
        this.onChange.accept(this.frame);
    }

    public HumanoidPoseAnimation.Frame getFrame() {
        return this.frame;
    }

    private static enum PartType {
        Head,
        Body,
        FpUsedArm,
        FpUnusedArm,
        FpRightArm,
        FpLeftArm,
        UsedArm,
        UnusedArm,
        RightArm,
        LeftArm,
        UsedItem,
        UnusedItem,
        RightItem,
        LeftItem,
        RightLeg,
        LeftLeg;

    }
}

