/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.renderers;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.redpxnda.nucleus.math.InterpolateMode;
import imgui.ImGui;
import imgui.type.ImFloat;
import imgui.type.ImInt;
import imgui.type.ImString;
import java.util.List;
import java.util.function.Consumer;

public class InterpolateModeEditor {
    private final Consumer<InterpolateMode> onChange;
    private InterpolateMode mode;
    private static final List<String> options = List.of("none", "lerp", "cosine", "easeIn", "easeOut", "easeInOut", "custom");
    private final ImInt selectedIndex;
    private final ImString customJson = new ImString(1024);
    private final ImFloat amplifierSlider = new ImFloat(2.0f);

    public InterpolateModeEditor(InterpolateMode initial, Consumer<InterpolateMode> onChange) {
        this.onChange = onChange;
        this.mode = initial;
        String initialKey = this.getModeKey(initial);
        int idx = options.indexOf(initialKey);
        if (idx == -1) {
            idx = options.size() - 1;
        }
        this.selectedIndex = new ImInt(idx);
        if ("custom".equals(initialKey)) {
            try {
                this.customJson.set(initial.toJson().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (initial instanceof InterpolateMode.EaseIn) {
            InterpolateMode.EaseIn ei = (InterpolateMode.EaseIn)initial;
            this.amplifierSlider.set(ei.amplifier());
        } else if (initial instanceof InterpolateMode.EaseOut) {
            InterpolateMode.EaseOut eo = (InterpolateMode.EaseOut)initial;
            this.amplifierSlider.set(eo.amplifier());
        } else if (initial instanceof InterpolateMode.EaseInOut) {
            InterpolateMode.EaseInOut eio = (InterpolateMode.EaseInOut)initial;
            this.amplifierSlider.set(eio.amplifier());
        }
    }

    public void render() {
        String type;
        ImGui.text((String)"Interpolation Mode:");
        if (ImGui.beginCombo((String)"##interpCombo", (String)options.get(this.selectedIndex.get()), (int)0)) {
            for (int i = 0; i < options.size(); ++i) {
                boolean isSelected;
                boolean bl = isSelected = this.selectedIndex.get() == i;
                if (ImGui.selectable((String)options.get(i), (boolean)isSelected)) {
                    this.selectedIndex.set(i);
                    this.updateModeFromSelection();
                }
                if (!isSelected) continue;
                ImGui.setItemDefaultFocus();
            }
            ImGui.endCombo();
        }
        if ((type = options.get(this.selectedIndex.get())).startsWith("ease") && ImGui.dragFloat((String)"Amplifier", (float[])this.amplifierSlider.getData(), (float)0.1f, (float)0.1f)) {
            switch (type) {
                case "easeIn": {
                    this.mode = new InterpolateMode.EaseIn(this.amplifierSlider.get());
                    break;
                }
                case "easeOut": {
                    this.mode = new InterpolateMode.EaseOut(this.amplifierSlider.get());
                    break;
                }
                case "easeInOut": {
                    this.mode = new InterpolateMode.EaseInOut(this.amplifierSlider.get());
                }
            }
            this.onChange.accept(this.mode);
        }
        if ("custom".equals(type)) {
            ImGui.inputTextMultiline((String)"##customInterpJson", (ImString)this.customJson, (int)16);
            if (ImGui.button((String)"Apply Custom Interpolation")) {
                try {
                    InterpolateMode customMode;
                    JsonElement parsed = JsonParser.parseString((String)this.customJson.get().trim());
                    this.mode = customMode = (InterpolateMode)((Pair)InterpolateMode.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)parsed).result().orElseThrow()).getFirst();
                    this.onChange.accept(this.mode);
                }
                catch (Exception e) {
                    ImGui.textColored((int)1, (int)0, (int)0, (int)1, (String)"Invalid JSON");
                }
            }
        }
    }

    public InterpolateMode getMode() {
        return this.mode;
    }

    private void updateModeFromSelection() {
        String selected = options.get(this.selectedIndex.get());
        try {
            switch (selected) {
                case "none": {
                    this.mode = InterpolateMode.NONE;
                    break;
                }
                case "lerp": {
                    this.mode = InterpolateMode.LERP;
                    break;
                }
                case "cosine": {
                    this.mode = InterpolateMode.COS;
                    break;
                }
                case "easeIn": {
                    this.mode = new InterpolateMode.EaseIn(this.amplifierSlider.get());
                    break;
                }
                case "easeOut": {
                    this.mode = new InterpolateMode.EaseOut(this.amplifierSlider.get());
                    break;
                }
                case "easeInOut": {
                    this.mode = new InterpolateMode.EaseInOut(this.amplifierSlider.get());
                    break;
                }
                case "custom": {
                    return;
                }
            }
            this.onChange.accept(this.mode);
        }
        catch (Exception e) {
            ImGui.textColored((int)1, (int)0, (int)0, (int)1, (String)"Failed to apply interpolation mode");
        }
    }

    private String getModeKey(InterpolateMode mode) {
        if (mode == null) {
            return "none";
        }
        try {
            JsonElement json = mode.toJson();
            if (json.isJsonPrimitive()) {
                return json.getAsString();
            }
            if (json.isJsonObject() && json.getAsJsonObject().has("type")) {
                return json.getAsJsonObject().get("type").getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "custom";
    }
}

