/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.renderers;

import com.redpxnda.nucleus.math.InterpolateMode;
import com.redpxnda.nucleus.pose.client.HumanoidPoseAnimation;
import imgui.ImGui;
import imgui.type.ImBoolean;
import java.util.function.Consumer;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import smartin.miapi.editor.renderers.InterpolateModeEditor;
import smartin.miapi.editor.renderers.Vector3fEditor;

public class PartStateEditor {
    private final HumanoidPoseAnimation.PartState multiplier;
    private final Consumer<HumanoidPoseAnimation.PartState> onChange;
    private final Vector3fEditor positionEditor;
    private final Vector3fEditor rotationEditor;
    private final Vector3fEditor scaleEditor;
    private final InterpolateModeEditor interpolateModeEditor;
    private final ImBoolean interpolationEnabled;
    private InterpolateMode lastUsedInterpolation = null;

    public PartStateEditor(HumanoidPoseAnimation.PartState multiplier, Consumer<HumanoidPoseAnimation.PartState> onChange) {
        this.multiplier = multiplier;
        this.onChange = onChange;
        this.positionEditor = new Vector3fEditor("Position", 0.03125f, multiplier.position, v -> this.triggerChange());
        Vector3f degreesVec = new Vector3f((float)Math.toDegrees(multiplier.rotation.x), (float)Math.toDegrees(multiplier.rotation.y), (float)Math.toDegrees(multiplier.rotation.z));
        this.rotationEditor = new Vector3fEditor("Rotation (deg)", 1.0f, degreesVec, degrees -> {
            multiplier.rotation.set((float)Math.toRadians(degrees.x), (float)Math.toRadians(degrees.y), (float)Math.toRadians(degrees.z));
            this.triggerChange();
        });
        this.scaleEditor = new Vector3fEditor("Scale", 0.01f, multiplier.scale, v -> this.triggerChange());
        this.interpolationEnabled = new ImBoolean(multiplier.interpolateMode != null);
        this.lastUsedInterpolation = multiplier.interpolateMode;
        this.interpolateModeEditor = new InterpolateModeEditor(multiplier.interpolateMode, mode -> {
            this.lastUsedInterpolation = mode;
            if (this.interpolationEnabled.get()) {
                multiplier.interpolateMode = mode;
                this.triggerChange();
            }
        });
    }

    public void render() {
        ImGui.text((String)"State");
        this.positionEditor.render();
        this.rotationEditor.render();
        this.scaleEditor.render();
        ImGui.separator();
        if (ImGui.checkbox((String)"Custom Interpolation", (ImBoolean)this.interpolationEnabled)) {
            if (this.interpolationEnabled.get()) {
                InterpolateMode interpolateMode = this.multiplier.interpolateMode = this.lastUsedInterpolation != null ? this.lastUsedInterpolation : null;
                if (this.lastUsedInterpolation == null) {
                    this.multiplier.interpolateMode = this.lastUsedInterpolation = InterpolateMode.LERP;
                }
            } else {
                this.multiplier.interpolateMode = null;
            }
            this.triggerChange();
        }
        if (this.interpolationEnabled.get()) {
            this.interpolateModeEditor.render();
        }
    }

    private void triggerChange() {
        this.onChange.accept(new HumanoidPoseAnimation.PartState(new Vector3f((Vector3fc)this.multiplier.position), new Vector3f((Vector3fc)this.multiplier.rotation), new Vector3f((Vector3fc)this.multiplier.scale), this.multiplier.interpolateMode));
    }

    public HumanoidPoseAnimation.PartState getMultiplier() {
        return this.multiplier;
    }
}

