/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.syntax;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import smartin.miapi.Miapi;
import smartin.miapi.editor.MiapiEditor;
import smartin.miapi.editor.registry.PropertyRegistryViewer;
import smartin.miapi.editor.syntax.EditorInterface;
import smartin.miapi.modules.properties.util.EditorError;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.modules.properties.util.Validator;
import smartin.miapi.registries.RegistryInventory;

public class PropertyMapHighlighter
implements EditorInterface {
    public static final class_2960 id = Miapi.id("miapi:property_map");
    private class_2960 modulePath;

    public PropertyMapHighlighter() {
        this(Miapi.id("runtime_editor_property_checker"));
    }

    public PropertyMapHighlighter(class_2960 modulePath) {
        this.modulePath = modulePath;
    }

    @Override
    public class_2960 getId() {
        return id;
    }

    @Override
    public List<EditorError> validateContent(JsonElement json, String rawContent) {
        ArrayList<EditorError> errors = new ArrayList<EditorError>();
        if (!(json instanceof JsonObject)) {
            errors.add(new EditorError(1, "Expected a JSON object", EditorError.ErrorSeverity.ERROR));
            return errors;
        }
        JsonObject moduleJson = (JsonObject)json;
        return PropertyMapHighlighter.getEditorErrors(rawContent, moduleJson);
    }

    @Override
    public Map<String, Runnable> toolbarButtons() {
        return Map.of("Property Registry", () -> {
            PropertyRegistryViewer viewer = new PropertyRegistryViewer();
            MiapiEditor.editors.add(viewer);
        });
    }

    public static List<EditorError> getEditorErrors(String rawContent, JsonObject moduleJson) {
        ArrayList<EditorError> errors = new ArrayList<EditorError>();
        Map rawProperties = moduleJson.asMap();
        rawProperties.forEach((key, data) -> {
            int line = PropertyMapHighlighter.getLineNumber(rawContent, key);
            class_2960 id = Miapi.id(key);
            ModuleProperty property = RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.get(id);
            if (property == null) {
                errors.add(new EditorError(line, "Invalid property '" + key + "'. This indicates either a broken Module, Outdated API version or missing dependency!", EditorError.ErrorSeverity.ERROR));
                return;
            }
            try {
                boolean valid = property.load(Miapi.id(key), (JsonElement)data, true);
                if (!valid) {
                    errors.add(new EditorError(line, "Property was not loaded '" + key + "' this is usually due to the property deactivating itself when requirements arent met like for compat properties.", EditorError.ErrorSeverity.WARNING));
                } else if (property instanceof Validator) {
                    Validator validator = (Validator)((Object)property);
                    errors.addAll(validator.validate(line, property.decode((JsonElement)data), true));
                }
            }
            catch (Exception e) {
                errors.add(new EditorError(line, "Failed to load property '" + key + "': " + e.getLocalizedMessage(), EditorError.ErrorSeverity.ERROR));
            }
        });
        return errors;
    }

    @Override
    public Map<EditorInterface.TextRange, Integer> getSyntaxHighlighting(String content) {
        return new HashMap<EditorInterface.TextRange, Integer>();
    }

    private static int getLineNumber(String content, String searchText) {
        String[] lines = content.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].contains("\"" + searchText + "\"")) continue;
            return i + 1;
        }
        return 1;
    }
}

