/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.util;

import com.mojang.datafixers.util.Pair;
import imgui.ImGui;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ListEditor<T> {
    private final String title;
    private final Consumer<List<T>> onChange;
    private List<Pair<T, Supplier<T>>> rendering = new ArrayList<Pair<T, Supplier<T>>>();
    private final BiFunction<T, Integer, Supplier<T>> getRenderFunction;
    private final Supplier<T> defaultEntry;

    public ListEditor(String title, List<T> items, Consumer<List<T>> onChange, BiFunction<T, Integer, Supplier<T>> renderEntry, Supplier<T> defaultEntry) {
        this.title = title;
        this.onChange = onChange;
        this.defaultEntry = defaultEntry;
        this.getRenderFunction = renderEntry;
        for (int i = 0; i < items.size(); ++i) {
            T item = items.get(i);
            this.rendering.add(new Pair(item, renderEntry.apply(item, i)));
        }
    }

    public void render() {
        if (ImGui.collapsingHeader((String)this.title, (int)32)) {
            ArrayList<Pair<T, Supplier<T>>> nextRendering = new ArrayList<Pair<T, Supplier<T>>>();
            boolean changed = false;
            for (int i = 0; i < this.rendering.size(); ++i) {
                Pair<T, Supplier<T>> toRender = this.rendering.get(i);
                Object t = ((Supplier)toRender.getSecond()).get();
                if (ImGui.button((String)"Remove")) {
                    changed = true;
                    continue;
                }
                nextRendering.add(new Pair(t, (Object)((Supplier)toRender.getSecond())));
            }
            if (ImGui.button((String)"Add Entry")) {
                T t = this.defaultEntry.get();
                nextRendering.add(new Pair(t, this.getRenderFunction.apply(t, nextRendering.size())));
                changed = true;
            }
            this.rendering = nextRendering;
            if (changed) {
                this.onChange.accept(nextRendering.stream().map(Pair::getFirst).toList());
            }
        }
    }

    public List<T> getList() {
        return this.rendering.stream().map(Pair::getFirst).toList();
    }
}

