/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.entity;

import com.redpxnda.nucleus.facet.FacetKey;
import com.redpxnda.nucleus.facet.FacetRegistry;
import com.redpxnda.nucleus.facet.entity.EntityFacet;
import com.redpxnda.nucleus.facet.network.clientbound.FacetSyncPacket;
import com.redpxnda.nucleus.network.PlayerSendable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import smartin.miapi.Miapi;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.mixin.LivingEntityAccessor;

public class ShieldingArmorFacet
implements EntityFacet<class_2487> {
    private final class_1309 livingEntity;
    private float currentAmount;
    public static final class_2960 facetIdentifier = Miapi.id("shielding_armor");
    public static FacetKey<ShieldingArmorFacet> KEY = FacetRegistry.register((class_2960)facetIdentifier, ShieldingArmorFacet.class);

    public ShieldingArmorFacet(class_1309 entity) {
        this.livingEntity = entity;
    }

    public float takeDamage(float originalDamage) {
        float reduction = Math.min(originalDamage, this.getCurrentAmount());
        this.currentAmount -= reduction;
        return originalDamage - reduction;
    }

    public float getCurrentAmount() {
        return this.currentAmount;
    }

    public void tick() {
        if (this.livingEntity.field_6012 % 5 == 3 && this.ticksSinceLastAttack() > 100) {
            this.currentAmount = Math.min(this.getCurrentAmount() + 0.25f, this.getMaxAmount());
            class_1309 class_13092 = this.livingEntity;
            if (class_13092 instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)class_13092;
                if (serverPlayerEntity.field_13987 != null) {
                    this.sendToClient(serverPlayerEntity);
                }
            }
        }
    }

    public int ticksSinceLastAttack() {
        int lastAttackedTime = ((LivingEntityAccessor)this.livingEntity).getLastAttackedTime();
        if (lastAttackedTime > this.livingEntity.field_6012) {
            return this.livingEntity.field_6012;
        }
        return this.livingEntity.field_6012 - lastAttackedTime;
    }

    public float getMaxAmount() {
        return (float)this.livingEntity.method_45325(AttributeRegistry.SHIELDING_ARMOR);
    }

    public class_2487 toNbt() {
        class_2487 compound = new class_2487();
        compound.method_10548("miapi:shielding_armor_current", this.getCurrentAmount());
        return compound;
    }

    public void sendToClient(class_1297 capHolder, class_3222 player) {
        if (player == null || player.field_13987 == null || player.method_37908() != null) {
            // empty if block
        }
    }

    public void loadNbt(class_2487 nbt) {
        this.currentAmount = nbt.method_10583("miapi:shielding_armor_current");
    }

    public PlayerSendable createPacket(class_1297 target) {
        return new FacetSyncPacket(target, KEY, (EntityFacet)this);
    }
}

