/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.entity;

import com.redpxnda.nucleus.facet.FacetKey;
import com.redpxnda.nucleus.facet.FacetRegistry;
import com.redpxnda.nucleus.facet.entity.EntityFacet;
import com.redpxnda.nucleus.facet.network.clientbound.FacetSyncPacket;
import com.redpxnda.nucleus.network.PlayerSendable;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import smartin.miapi.Miapi;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.mixin.LivingEntityAccessor;
import smartin.miapi.registries.RegistryInventory;

public class StunHealthFacet
implements EntityFacet<class_2487> {
    private final class_1309 livingEntity;
    private float currentAmount = 20.0f;
    public static final class_2960 facetIdentifier = Miapi.id("stun_current_health");
    public static FacetKey<StunHealthFacet> KEY = FacetRegistry.register((class_2960)facetIdentifier, StunHealthFacet.class);

    public StunHealthFacet(class_1309 entity) {
        this.livingEntity = entity;
    }

    public void takeStunDamage(float stunDamage, class_1309 attacker) {
        this.currentAmount -= stunDamage;
        if (this.currentAmount <= 0.0f) {
            if (!this.livingEntity.method_6059(RegistryInventory.stunResistanceEffect)) {
                this.livingEntity.method_37222(new class_1293(RegistryInventory.stunEffect, MiapiConfig.getServerConfig().stunEffectCategory.stunLength, 0, false, true), (class_1297)attacker);
            }
            this.currentAmount = this.getMaxAmount();
        }
    }

    public float getCurrentStunHealth() {
        return this.currentAmount;
    }

    public void tick() {
        if (this.livingEntity.field_6012 % 5 == 4) {
            this.currentAmount = Math.min(this.getCurrentStunHealth() + 2.0f, this.getMaxAmount());
            class_1309 class_13092 = this.livingEntity;
            if (class_13092 instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)class_13092;
                if (serverPlayerEntity.field_13987 != null) {
                    this.sendToClient(serverPlayerEntity);
                }
            }
        }
    }

    public int ticksSinceLastAttack() {
        int lastAttackedTime = ((LivingEntityAccessor)this.livingEntity).getLastAttackedTime();
        if (lastAttackedTime > this.livingEntity.field_6012) {
            return this.livingEntity.field_6012;
        }
        return this.livingEntity.field_6012 - lastAttackedTime;
    }

    public float getMaxAmount() {
        return (float)this.livingEntity.method_45325(AttributeRegistry.STUN_MAX_HEALTH);
    }

    public class_2487 toNbt() {
        class_2487 compound = new class_2487();
        compound.method_10548("miapi:stun_current_health", this.getCurrentStunHealth());
        return compound;
    }

    public void sendToClient(class_1297 capHolder, class_3222 player) {
        if (player != null && player.field_13987 != null && player.method_37908() != null) {
            try {
                this.createPacket(capHolder).send(player);
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("facet sync issue", (Throwable)e);
            }
        }
    }

    public void loadNbt(class_2487 nbt) {
        this.currentAmount = nbt.method_10583("miapi:stun_current_health");
    }

    public PlayerSendable createPacket(class_1297 target) {
        return new FacetSyncPacket(target, KEY, (EntityFacet)this);
    }
}

