/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.fabric;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5455;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.conditions.ConditionManager;

public class MiapiReloadListener
implements class_3302 {
    Supplier<class_5455> registryAccess;
    static long timeStart;
    public static Map<class_2960, String> reloadData;

    public MiapiReloadListener(Supplier<class_5455> registryAccess) {
        this.registryAccess = registryAccess;
    }

    public CompletableFuture load(class_3300 manager, class_3695 profiler, Executor executor) {
        LinkedHashMap data = new LinkedHashMap();
        ReloadEvents.SYNCED_PATHS.forEach((modID, dataPaths) -> dataPaths.forEach(dataPath -> {
            Map map = manager.method_41265(dataPath, fileName -> true);
            map.forEach((identifier, resources) -> resources.forEach(resource -> {
                try {
                    BufferedReader reader = resource.method_43039();
                    String dataString = reader.lines().collect(Collectors.joining());
                    data.put(identifier, dataString);
                }
                catch (Exception e) {
                    Miapi.LOGGER.warn("Error Loading Resource" + String.valueOf(identifier) + " " + String.valueOf(resources));
                }
            }));
        }));
        return CompletableFuture.completedFuture(data);
    }

    public void apply(Object data, class_3300 manager, class_3695 profiler) {
        Miapi.registryAccess = this.registryAccess.get();
        HashMap<class_2960, String> dataMap = new HashMap<class_2960, String>((Map)data);
        HashMap<class_2960, String> filteredMap = new HashMap<class_2960, String>();
        dataMap.forEach((key, value) -> {
            if (!key.method_12832().endsWith(".json")) {
                filteredMap.put((class_2960)key, (String)value);
                return;
            }
            try {
                JsonObject element = (JsonObject)Miapi.gson.fromJson(value, JsonObject.class);
                if (!element.has("load_condition")) {
                    filteredMap.put((class_2960)key, (String)value);
                    return;
                }
                boolean allowed = ConditionManager.get(element.get("load_condition")).isAllowed(new ConditionManager.ConditionContext(this){

                    @Override
                    public ConditionManager.ConditionContext copy() {
                        return this;
                    }
                });
                if (allowed) {
                    element.remove("load_condition");
                    Miapi.LOGGER.info("redid " + String.valueOf(key));
                    filteredMap.put((class_2960)key, Miapi.gson.toJson((JsonElement)element));
                }
            }
            catch (Exception e) {
                filteredMap.put((class_2960)key, (String)value);
            }
        });
        reloadData = filteredMap;
    }

    public static void actualReload(class_5455 access) {
        ++ReloadEvents.reloadCounter;
        timeStart = System.nanoTime();
        MiapiEvents.ReloadEventData data = new MiapiEvents.ReloadEventData();
        data.data = new LinkedHashMap<class_2960, String>();
        data.data.putAll(reloadData);
        ReloadEvents.RAW_DATA_PACKS.clear();
        ReloadEvents.RAW_DATA_PACKS.putAll(reloadData);
        ((MiapiEvents.ReloadEvent)MiapiEvents.ADJUST_RAW_DATA.invoker()).onReload(data);
        ReloadEvents.START.fireEvent(false, access);
        ReloadEvents.DataPackLoader.trigger(data.data);
        ReloadEvents.MAIN.fireEvent(false, access);
        ReloadEvents.END.fireEvent(false, access);
        Miapi.LOGGER.info("Server load took " + (double)(System.nanoTime() - timeStart) / 1000.0 / 1000.0 + " ms");
        --ReloadEvents.reloadCounter;
        if (Miapi.server != null) {
            Miapi.server.method_3760().method_14571().forEach(ReloadEvents::triggerReloadOnClient);
        }
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)this.load(resourceManager, preparationsProfiler, backgroundExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenAcceptAsync(values -> this.apply(values, resourceManager, reloadProfiler), gameExecutor);
    }

    static {
        reloadData = new HashMap<class_2960, String>();
    }
}

