/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.ItemIdProperty;
import smartin.miapi.registries.RegistryInventory;

public class ItemToModularConverter
implements ModularItemStackConverter.ModularConverter {
    public static Map<String, class_1799> regexes = new ConcurrentHashMap<String, class_1799>();
    public static Codec<Map<String, ModuleInstance>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, ModuleInstance.CODEC);

    public ItemToModularConverter() {
        ReloadEvents.END.subscribe((isClient, registryAccess) -> Miapi.LOGGER.info("Loaded " + regexes.size() + " Modular Converters"));
    }

    public static void setupModularConverter(class_2960 path, String data) {
        try {
            JsonElement element = (JsonElement)Miapi.gson.fromJson(data, JsonElement.class);
            DataResult decoded = CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (decoded.isSuccess()) {
                ((Map)((Pair)decoded.getOrThrow()).getFirst()).forEach((key, modules) -> {
                    class_1799 stack = new class_1799((class_1935)RegistryInventory.modularItem);
                    modules.writeToItem(stack);
                    regexes.put((String)key, stack);
                });
            } else {
                Miapi.LOGGER.error("could not read modular converter in " + String.valueOf(path) + " " + decoded.error().toString());
            }
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("Error during Modular Converter setup for " + String.valueOf(path), (Throwable)e);
        }
    }

    public boolean preventConvert(class_1799 itemStack) {
        return itemStack.method_31573(RegistryInventory.MIAPI_FORBIDDEN_TAG);
    }

    @Override
    public class_1799 convert(class_1799 stack) {
        if (this.preventConvert(stack)) {
            return stack.method_7972();
        }
        try {
            for (Map.Entry<String, class_1799> entry : regexes.entrySet()) {
                if (!class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().matches(entry.getKey())) continue;
                class_1799 nextStack = entry.getValue().method_7972();
                nextStack.method_57365(stack.method_57353());
                nextStack.method_7939(stack.method_7947());
                MutableObject mutable = new MutableObject((Object)ItemIdProperty.changeId(nextStack));
                ((MiapiEvents.ItemConvertEvent)MiapiEvents.CONVERT_ITEM.invoker()).convert(stack, (Mutable<class_1799>)mutable);
                return (class_1799)mutable.getValue();
            }
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("error during modular convertion", (Throwable)e);
        }
        return stack;
    }
}

