/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8059;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9697;
import org.jetbrains.annotations.NotNull;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.registries.RegistryInventory;

public class MaterialSmithingRecipe
implements class_8059 {
    public static MapCodec<MaterialSmithingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1856.field_46095.fieldOf("template").forGetter(recipe -> recipe.smithingTemplate), (App)class_2960.field_25139.fieldOf("base").forGetter(recipe -> recipe.startMaterial), (App)class_1856.field_46095.fieldOf("addition").forGetter(recipe -> recipe.addition), (App)class_2960.field_25139.fieldOf("result").forGetter(recipe -> recipe.resultMaterial)).apply((Applicative)instance, MaterialSmithingRecipe::new));
    public final class_2960 startMaterial;
    public final class_2960 resultMaterial;
    public final class_1856 smithingTemplate;
    public final class_1856 addition;

    public MaterialSmithingRecipe(class_1856 template, class_2960 baseMaterial, class_1856 addition, class_2960 resultMaterial) {
        this.startMaterial = baseMaterial;
        this.resultMaterial = resultMaterial;
        this.smithingTemplate = template;
        this.addition = addition;
    }

    public boolean method_48453(@NotNull class_1799 stack) {
        return this.smithingTemplate.method_8093(stack);
    }

    public boolean method_48454(class_1799 stack) {
        if (stack.method_7909() instanceof VisualModularItem) {
            ModuleInstance instance = ItemModule.getModules(stack);
            return instance.allSubModules().stream().anyMatch(module -> {
                Material material = MaterialProperty.getMaterial(module);
                if (material != null) {
                    return material.getID().equals((Object)this.startMaterial);
                }
                return false;
            });
        }
        return false;
    }

    public boolean method_30029(@NotNull class_1799 stack) {
        return this.addition.method_8093(stack);
    }

    public boolean matches(class_9697 inventory, @NotNull class_1937 world) {
        return this.method_48453(inventory.method_59984(0)) && this.method_48454(inventory.method_59984(1)) && this.addition.method_8093(inventory.method_59984(2));
    }

    @NotNull
    public class_1799 assemble(class_9697 input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        class_1799 old = input.method_59984(1).method_7972();
        if (old.method_7909() instanceof VisualModularItem) {
            ModuleInstance instance = ItemModule.getModules(old).copy();
            instance.allSubModules().forEach(module -> {
                Material material = MaterialProperty.getMaterial(module);
                if (material != null && material.getID().equals((Object)this.startMaterial)) {
                    MaterialProperty.setMaterial(module, MaterialProperty.MATERIAL_REGISTRY.get(this.resultMaterial));
                }
            });
            instance.writeToItem(old);
        }
        MiapiEvents.MaterialCraft data = new MiapiEvents.MaterialCraft(old);
        ((MiapiEvents.SmithingEvent)MiapiEvents.SMITHING_EVENT.invoker()).craft(data);
        return data.itemStack;
    }

    @NotNull
    public class_1799 method_8110(class_7225.class_7874 registries) {
        return class_1799.field_8037;
    }

    public class_3956<?> method_17716() {
        return class_3956.field_25388;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return RegistryInventory.serializer;
    }

    public static class Serializer
    implements class_1865<MaterialSmithingRecipe> {
        @NotNull
        public MapCodec<MaterialSmithingRecipe> method_53736() {
            return CODEC;
        }

        @NotNull
        public class_9139<class_9129, MaterialSmithingRecipe> method_56104() {
            return class_9135.method_56896((Codec)CODEC.codec());
        }
    }
}

