/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular;

import com.ezylang.evalex.Expression;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import com.redpxnda.nucleus.codec.misc.CustomIntermediateCodec;
import com.redpxnda.nucleus.codec.misc.IntermediateCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import smartin.miapi.Miapi;
import smartin.miapi.material.EvalExResolverStuff;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ModuleInstance;

public class StatResolver {
    private static final Map<String, Resolver> resolverMap = new ConcurrentHashMap<String, Resolver>();

    public static String resolveString(String raw, ModuleInstance instance) {
        String resolved = raw;
        Pattern pattern = Pattern.compile("\\[([^\\[]*?)\\]");
        Matcher matcher = pattern.matcher(raw);
        int counter = 10;
        while (matcher.find() && counter > 0) {
            --counter;
            String match = matcher.group(1);
            String[] parts = match.split("\\.");
            if (parts.length >= 2) {
                String resolverKey = parts[0];
                String resolverData = String.join((CharSequence)".", Arrays.copyOfRange(parts, 1, parts.length));
                Resolver resolver = resolverMap.get(resolverKey);
                if (resolver != null) {
                    String resolvedData = resolver.resolveString(resolverData, instance);
                    resolved = resolved.replace("[" + match + "]", resolvedData);
                } else {
                    resolved = resolved.replace("[" + match + "]", "");
                }
            } else {
                resolved = resolved.replace("[" + match + "]", "");
            }
            matcher = pattern.matcher(resolved);
        }
        return resolved;
    }

    public static double resolveDouble(JsonElement raw, ModuleInstance instance) {
        try {
            return raw.getAsDouble();
        }
        catch (Exception exception) {
            return StatResolver.resolveDouble(raw.getAsString(), instance);
        }
    }

    public static double resolveDouble(String raw, ModuleInstance instance) {
        try {
            return Double.parseDouble(raw);
        }
        catch (Exception exception) {
            String resolved = raw;
            Pattern pattern = Pattern.compile("\\[(.*?)\\]");
            Matcher matcher = pattern.matcher(raw);
            while (matcher.find()) {
                String match = matcher.group(1);
                String[] parts = match.split("\\.");
                if (parts.length < 2) continue;
                String resolverKey = parts[0];
                String resolverData = String.join((CharSequence)".", Arrays.copyOfRange(parts, 1, parts.length));
                Resolver resolver = resolverMap.get(resolverKey);
                if (resolver != null) {
                    String resolvedData = String.valueOf(resolver.resolveDouble(resolverData, instance));
                    resolved = resolved.replace("[" + match + "]", resolvedData);
                    continue;
                }
                Miapi.LOGGER.error("material resolver for id " + resolverKey + " was not found!");
                resolved = resolved.replace("[" + match + "]", "0");
            }
            return StatResolver.resolveCalculation(resolved, raw);
        }
    }

    public static class_2561 translateAndResolve(String raw, ModuleInstance instance) {
        String old = "";
        String newString = raw;
        for (int i = 0; i < 100 && !old.equals(newString); ++i) {
            old = newString;
            newString = StatResolver.resolveString(old, instance);
            ArrayList translatedStrings = new ArrayList();
            Arrays.stream(newString.split(" ")).forEach(s -> translatedStrings.add(class_2561.method_43471((String)s).getString()));
            newString = String.join((CharSequence)" ", translatedStrings);
        }
        return class_2561.method_43470((String)newString);
    }

    public static void registerResolver(String keyWord, Resolver resolver) {
        resolverMap.put(keyWord, resolver);
    }

    public static double resolveCalculation(String string, String original) {
        try {
            Expression e = new Expression(string, EvalExResolverStuff.configuration);
            return e.evaluate().getNumberValue().doubleValue();
        }
        catch (Exception e) {
            Miapi.LOGGER.error("could not evaluate " + string + " from original" + original, (Throwable)e);
            return 0.0;
        }
    }

    static {
        StatResolver.registerResolver("translation", new Resolver(){

            @Override
            public double resolveDouble(String data, ModuleInstance instance) {
                return Double.parseDouble(class_2561.method_43471((String)data).getString());
            }

            @Override
            public String resolveString(String data, ModuleInstance instance) {
                return class_2561.method_43471((String)data).getString();
            }
        });
        StatResolver.registerResolver("collect", new Resolver(){

            @Override
            public double resolveDouble(String data, ModuleInstance instance) {
                if (data.contains(".")) {
                    String[] parts = data.split("\\.", 2);
                    Stream<Double> numbers = instance.getRoot().allSubModules().stream().map(module -> StatResolver.resolveDouble("[" + parts[1] + "]", module));
                    double result = 0.0;
                    switch (parts[0]) {
                        case "add": {
                            result = numbers.collect(Collectors.summarizingDouble(Double::doubleValue)).getSum();
                            break;
                        }
                        case "max": {
                            result = numbers.collect(Collectors.summarizingDouble(Double::doubleValue)).getMax();
                            break;
                        }
                        case "min": {
                            result = numbers.collect(Collectors.summarizingDouble(Double::doubleValue)).getMin();
                            break;
                        }
                        case "average": {
                            result = numbers.collect(Collectors.averagingDouble(Double::doubleValue));
                            break;
                        }
                        default: {
                            Miapi.LOGGER.warn("invalid collect Operation " + parts[0] + " add, max, min, average are valid operations");
                        }
                    }
                    return result;
                }
                return 0.0;
            }
        });
        StatResolver.registerResolver("material-module", new Resolver(){

            @Override
            public double resolveDouble(String data, ModuleInstance instance) {
                double firstResult = StatResolver.resolveDouble("[material." + data + "]", instance);
                if (firstResult == 0.0) {
                    return StatResolver.resolveDouble("[module." + data + "]", instance);
                }
                return firstResult;
            }

            @Override
            public String resolveString(String data, ModuleInstance instance) {
                String firstResult = StatResolver.resolveString("[material." + data + "]", instance);
                if (firstResult == null || firstResult.isEmpty()) {
                    return StatResolver.resolveString("[module." + data + "]", instance);
                }
                return firstResult;
            }
        });
        StatResolver.registerResolver("module-material", new Resolver(){

            @Override
            public double resolveDouble(String data, ModuleInstance instance) {
                double firstResult = StatResolver.resolveDouble("[module." + data + "]", instance);
                if (firstResult == 0.0) {
                    return StatResolver.resolveDouble("[material." + data + "]", instance);
                }
                return firstResult;
            }

            @Override
            public String resolveString(String data, ModuleInstance instance) {
                String firstResult = StatResolver.resolveString("[module." + data + "]", instance);
                if (firstResult == null || firstResult.isEmpty()) {
                    return StatResolver.resolveString("[material." + data + "]", instance);
                }
                return firstResult;
            }
        });
        StatResolver.registerResolver("slot", new Resolver(){

            @Override
            public double resolveDouble(String data, ModuleInstance instance) {
                String[] parts = data.split("\\.", 2);
                ModuleInstance module = instance.getSubModule(parts[0]);
                if (module != null) {
                    return StatResolver.resolveDouble(parts[1], module);
                }
                return 0.0;
            }
        });
        StatResolver.registerResolver("count", new Resolver(){

            @Override
            public double resolveDouble(String data, ModuleInstance instance) {
                double count = 0.0;
                switch (data) {
                    case "module": {
                        count = instance.getRoot().allSubModules().size();
                        break;
                    }
                    case "submodule": {
                        count = instance.allSubModules().size();
                        break;
                    }
                    case "unique_materials": {
                        count = instance.getRoot().allSubModules().stream().filter(m -> MaterialProperty.getMaterial(m) != null).map(MaterialProperty::getMaterial).filter(Objects::nonNull).count();
                        break;
                    }
                    case "root_material_matches": {
                        Optional<Material> material = instance.getRoot().allSubModules().stream().filter(m -> MaterialProperty.getMaterial(m) != null).map(MaterialProperty::getMaterial).findFirst();
                        if (!material.isPresent()) break;
                        count = instance.getRoot().allSubModules().stream().filter(m -> MaterialProperty.getMaterial(m) != null).map(MaterialProperty::getMaterial).filter(m -> ((Material)material.get()).equals(m)).count();
                        break;
                    }
                    case "material_matches": {
                        Optional<Material> material = instance.allSubModules().stream().filter(m -> MaterialProperty.getMaterial(m) != null).map(MaterialProperty::getMaterial).findFirst();
                        if (!material.isPresent()) break;
                        count = instance.getRoot().allSubModules().stream().filter(m -> MaterialProperty.getMaterial(m) != null).map(MaterialProperty::getMaterial).filter(m -> ((Material)material.get()).equals(m)).count();
                        break;
                    }
                    default: {
                        Miapi.LOGGER.warn("Statresolver count doesnt recognise " + data + " it only allows for module and submodules as keys");
                    }
                }
                return count;
            }
        });
    }

    public static interface Resolver {
        public double resolveDouble(String var1, ModuleInstance var2);

        default public String resolveString(String data, ModuleInstance instance) {
            return "";
        }
    }

    @CodecBehavior.Override(value="fullCodec")
    public static class IntegerFromStat
    extends IntermediateCodec.Median<String, ModuleInstance, Integer> {
        public static BiFunction<String, ModuleInstance, Integer> func = (raw, input) -> (int)StatResolver.resolveDouble(raw, input);
        public static Codec<IntegerFromStat> codec = new CustomIntermediateCodec((Codec)Codec.STRING, func, (s, b) -> new IntegerFromStat((String)s));
        public static Codec<IntegerFromStat> fullCodec = Codec.either((Codec)Codec.INT, codec).xmap(either -> {
            if (either.right().isPresent()) {
                return (IntegerFromStat)((Object)((Object)either.right().get()));
            }
            return new IntegerFromStat((Integer)either.left().get());
        }, Either::right);
        public int evaluatedOutput = 0;

        public IntegerFromStat(String start) {
            super((Object)start, func);
        }

        public IntegerFromStat(int start) {
            this(String.valueOf(start));
        }

        public Integer evaluate(ModuleInstance moduleInstance) {
            this.evaluatedOutput = (Integer)super.evaluate((Object)moduleInstance);
            return this.evaluatedOutput;
        }

        public String toString() {
            return "IntegerFromStat{start=" + (String)this.start + "}";
        }
    }

    @CodecBehavior.Override(value="fullCodec")
    @Deprecated
    public static class DoubleFromStat
    extends IntermediateCodec.Median<String, ModuleInstance, Double> {
        public static BiFunction<String, ModuleInstance, Double> func = StatResolver::resolveDouble;
        public static Codec<DoubleFromStat> codec = new CustomIntermediateCodec((Codec)Codec.STRING, func, (s, b) -> new DoubleFromStat((String)s));
        public static Codec<DoubleFromStat> fullCodec = Codec.either((Codec)Codec.DOUBLE, codec).xmap(either -> {
            if (either.right().isPresent()) {
                return (DoubleFromStat)((Object)((Object)either.right().get()));
            }
            return new DoubleFromStat((Double)either.left().get());
        }, Either::right);
        public double evaluatedOutput = 0.0;

        public Double evaluate(ModuleInstance moduleInstance) {
            this.evaluatedOutput = (Double)super.evaluate((Object)moduleInstance);
            return this.evaluatedOutput;
        }

        public DoubleFromStat(String start) {
            super((Object)start, func);
        }

        public DoubleFromStat(double start) {
            this(String.valueOf(start));
        }

        public String toString() {
            return "DoubleFromStat{start=" + (String)this.start + "}";
        }
    }

    @CodecBehavior.Override(value="codec")
    public static class StringFromStat
    extends IntermediateCodec.Median<String, ModuleInstance, String> {
        public static BiFunction<String, ModuleInstance, String> func = StatResolver::resolveString;
        public static Codec<StringFromStat> codec = new CustomIntermediateCodec((Codec)Codec.STRING, func, (s, b) -> new StringFromStat((String)s));

        public StringFromStat(String start) {
            super((Object)start, func);
        }
    }

    public static final class Codecs {
        public static Codec<JsonElement> JSONELEMENT_CODEC = new Codec<JsonElement>(){

            public <T> DataResult<T> encode(JsonElement input, DynamicOps<T> ops, T prefix) {
                if (input == null) {
                    return DataResult.success(prefix);
                }
                try {
                    return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, input));
                }
                catch (RuntimeException e) {
                    Miapi.LOGGER.info(String.valueOf(input) + "could not be converted!");
                    return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, input));
                }
            }

            public <T> DataResult<Pair<JsonElement, T>> decode(DynamicOps<T> ops, T input) {
                return DataResult.success((Object)new Pair((Object)((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)), input));
            }
        };

        public static Codec<String> STRING(ModuleInstance instance) {
            return Codec.STRING.xmap(s -> StatResolver.resolveString(s, instance), s -> s);
        }

        public static Codec<Double> DOUBLE(ModuleInstance instance) {
            return Codec.either((Codec)Codec.DOUBLE, (Codec)Codec.STRING.xmap(s -> StatResolver.resolveDouble(s, instance), String::valueOf)).xmap(e -> {
                if (e.left().isPresent()) {
                    return (Double)e.left().get();
                }
                return (Double)e.right().get();
            }, Either::left);
        }

        public static Codec<Integer> INTEGER(ModuleInstance instance) {
            return Codec.either((Codec)Codec.INT, (Codec)Codecs.DOUBLE(instance).xmap(Double::intValue, Integer::doubleValue)).xmap(e -> {
                if (e.left().isPresent()) {
                    return (Integer)e.left().get();
                }
                return (Integer)e.right().get();
            }, Either::left);
        }
    }
}

