/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular.items.bows;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_9278;
import net.minecraft.class_9334;
import net.minecraft.class_9463;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NonnullDefault;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.client.model.ModularModelPredicateProvider;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.entity.ProjectileWithBow;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.item.FakeItemManager;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.PlatformModularItemMethods;
import smartin.miapi.mixin.item.CrossbowItemAccessor;
import smartin.miapi.modules.properties.DisplayNameProperty;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.RepairPriority;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.enchanment.EnchantAbilityProperty;
import smartin.miapi.modules.properties.projectile.DrawTimeProperty;
import smartin.miapi.modules.properties.projectile.IsCrossbowShootAble;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;

@NonnullDefault
public class ModularCrossbow
extends class_1764
implements PlatformModularItemMethods,
ModularItem {
    public ModularCrossbow(class_1792.class_1793 settings) {
        super(settings.method_7889(1).method_7895(50));
        if (Environment.isClient()) {
            this.registerAnimations();
        }
    }

    public ModularCrossbow() {
        super(new class_1792.class_1793().method_7889(1).method_7895(50));
        if (Environment.isClient()) {
            this.registerAnimations();
        }
    }

    public class_1799 method_7854() {
        return FakeItemManager.getDefaultInstance((class_1792)this);
    }

    public void method_7860(class_1799 stack) {
        ComponentApplyProperty.initializeItemStack(stack, Miapi.registryAccess);
        super.method_7860(stack);
    }

    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public void registerAnimations() {
        ModularModelPredicateProvider.registerModelOverride((class_1792)this, class_2960.method_60654((String)"pull"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            int i = this.method_7881(stack, entity) - entity.method_6048();
            return entity.method_6030() != stack ? 0.0f : -ModularCrossbow.getPowerForTime(i, stack, entity);
        });
        ModularModelPredicateProvider.registerModelOverride((class_1792)this, class_2960.method_60654((String)"pulling"), (stack, world, entity, seed) -> entity != null && entity.method_6115() && entity.method_6030() == stack ? 1.0f : 0.0f);
        ModularModelPredicateProvider.registerModelOverride((class_1792)this, class_2960.method_60654((String)"charged"), (stack, world, entity, seed) -> entity != null && ModularCrossbow.method_7781((class_1799)stack) ? 1.0f : 0.0f);
    }

    public int method_31569(class_1799 stack) {
        return Math.round(13.0f - (float)stack.method_7919() * 13.0f / (float)ModularItem.getDurability(stack));
    }

    public int method_31571(class_1799 stack) {
        float f = Math.max(0.0f, ((float)ModularItem.getDurability(stack) - (float)stack.method_7919()) / (float)ModularItem.getDurability(stack));
        return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean method_7870(class_1799 itemStack) {
        return true;
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        ((MiapiEvents.InventoryTickEvent)MiapiEvents.INVENTORY_TICK.invoker()).tick(stack, level, entity, slotId, isSelected);
        super.method_7888(stack, level, entity, slotId, isSelected);
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return RepairPriority.getRepairValue(stack, ingredient) > 0.0;
    }

    public class_2561 method_7864(class_1799 stack) {
        return DisplayNameProperty.getDisplayText(stack);
    }

    public int method_7837() {
        class_1799 itemStack = FakeItemManager.getLastInstance((class_1792)this);
        if (itemStack != null) {
            return (int)EnchantAbilityProperty.getEnchantAbility(itemStack);
        }
        return 15;
    }

    protected class_1676 method_57344(class_1937 level, class_1309 shooter, class_1799 weapon, class_1799 ammo, boolean isCrit) {
        class_1792 class_17922;
        if (IsCrossbowShootAble.canCrossbowShoot(ammo) && (class_17922 = ammo.method_7909()) instanceof class_9463) {
            class_9463 projectileItem = (class_9463)class_17922;
            class_1676 projectile = super.method_57344(level, shooter, weapon, ammo, isCrit);
            if (projectile instanceof ItemProjectileEntity) {
                ItemProjectileEntity projectileEntity = (ItemProjectileEntity)projectile;
                projectileEntity.method_7439(isCrit);
            }
            ((ProjectileWithBow)projectile).setBowItem(weapon);
            return projectile;
        }
        class_1676 projectile1 = super.method_57344(level, shooter, weapon, ammo, isCrit);
        ((ProjectileWithBow)projectile1).setBowItem(weapon);
        return projectile1;
    }

    protected void method_7763(class_1309 shooter, class_1676 projectile, int index, float velocity, float inaccuracy, float angle, @Nullable class_1309 target) {
        if (index != 0 && projectile instanceof ItemProjectileEntity) {
            ItemProjectileEntity entity = (ItemProjectileEntity)projectile;
            entity.field_7572 = class_1665.class_1666.field_7594;
        }
        super.method_7763(shooter, projectile, index, velocity, inaccuracy, angle, target);
    }

    public static List<class_1799> drawPublic(class_1799 weapon, class_1799 ammo, class_1309 shooter) {
        return ModularCrossbow.method_57390((class_1799)weapon, (class_1799)ammo, (class_1309)shooter);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 crossbow = player.method_5998(usedHand);
        class_9278 chargedProjectiles = (class_9278)crossbow.method_57824(class_9334.field_49649);
        if (chargedProjectiles != null && !chargedProjectiles.method_57442()) {
            float divergence = (float)Math.pow(12.0, -AttributeUtil.getActualValue(crossbow, class_1304.field_6173, (class_1320)AttributeRegistry.PROJECTILE_ACCURACY.comp_349()));
            float speed = (float)Math.max(0.1, AttributeUtil.getActualValue(crossbow, class_1304.field_6173, (class_1320)AttributeRegistry.PROJECTILE_SPEED.comp_349()) + (double)ModularCrossbow.getShootingPower(chargedProjectiles));
            if (((MiapiProjectileEvents.CrossbowContext)MiapiProjectileEvents.MODULAR_CROSSBOW_PRE_SHOT.invoker()).shoot((class_1309)player, crossbow).interruptsFurtherEvaluation()) {
                return class_1271.method_22428((Object)crossbow);
            }
            this.method_7777(level, (class_1309)player, usedHand, crossbow, speed, divergence, null);
            if (((MiapiProjectileEvents.CrossbowContext)MiapiProjectileEvents.MODULAR_CROSSBOW_POST_SHOT.invoker()).shoot((class_1309)player, crossbow).interruptsFurtherEvaluation()) {
                return class_1271.method_22428((Object)crossbow);
            }
            return class_1271.method_22428((Object)crossbow);
        }
        if (!player.method_18808(crossbow).method_7960()) {
            ((CrossbowItemAccessor)((Object)this)).setStartSoundPlayed(false);
            ((CrossbowItemAccessor)((Object)this)).setMidLoadSoundPlayed(false);
            player.method_6019(usedHand);
            return class_1271.method_22428((Object)crossbow);
        }
        return class_1271.method_22431((Object)crossbow);
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 livingEntity, int timeCharged) {
        int ticks = this.method_7881(stack, livingEntity) - timeCharged;
        float charge = ModularCrossbow.getPowerForTime(ticks, stack, livingEntity);
        MiapiProjectileEvents.CrossbowLoadingContext context = new MiapiProjectileEvents.CrossbowLoadingContext(livingEntity, stack, livingEntity.method_18808(stack), class_1304.field_6173);
        if (charge >= 1.0f && !ModularCrossbow.method_7781((class_1799)stack) && !((MiapiProjectileEvents.CrossbowContextEvent)MiapiProjectileEvents.MODULAR_CROSSBOW_PRE_LOAD.invoker()).load(context).interruptsFurtherEvaluation() && CrossbowItemAccessor.callTryLoadProjectiles(livingEntity, stack)) {
            if (((MiapiProjectileEvents.CrossbowContextEvent)MiapiProjectileEvents.MODULAR_CROSSBOW_POST_LOAD.invoker()).load(context).interruptsFurtherEvaluation()) {
                return;
            }
            class_1764.class_9693 chargingSounds = ((CrossbowItemAccessor)((Object)this)).callGetChargingSounds(stack);
            chargingSounds.comp_2675().ifPresent(holder -> level.method_43128((class_1657)null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), (class_3414)holder.comp_349(), livingEntity.method_5634(), 1.0f, 1.0f / (level.method_8409().method_43057() * 0.5f + 1.0f) + 0.2f));
        }
    }

    public Predicate<class_1799> method_19268() {
        return super.method_19268().or(IsCrossbowShootAble::canCrossbowShoot);
    }

    private static float getPowerForTime(int timeLeft, class_1799 stack, class_1309 shooter) {
        float f = (float)timeLeft / (float)ModularCrossbow.getChargeDuration(stack, shooter);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static int getChargeDuration(class_1799 stack, class_1309 shooter) {
        double drawTime = DrawTimeProperty.property.getValue(stack).orElse(0.25);
        float f = class_1890.method_60159((class_1799)stack, (class_1309)shooter, (float)((float)drawTime));
        return class_3532.method_15375((float)(f * 20.0f));
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        class_9278 chargedProjectiles = (class_9278)stack.method_57824(class_9334.field_49649);
        LoreProperty.appendLoreTop(stack, tooltipComponents, context, tooltipFlag);
        if (chargedProjectiles != null && !chargedProjectiles.method_57442()) {
            class_1799 itemStack = (class_1799)chargedProjectiles.method_57437().getFirst();
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.minecraft.crossbow.projectile").method_10852(class_5244.field_41874).method_10852(itemStack.method_7954()));
            if (tooltipFlag.method_8035() && itemStack.method_31574(class_1802.field_8639)) {
                ArrayList list = Lists.newArrayList();
                class_1802.field_8639.method_7851(itemStack, context, (List)list, tooltipFlag);
                if (!list.isEmpty()) {
                    for (int i = 0; i < list.size(); ++i) {
                        list.set(i, class_2561.method_43470((String)"  ").method_10852((class_2561)list.get(i)).method_27692(class_124.field_1080));
                    }
                    tooltipComponents.addAll(list);
                }
            }
        }
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
    }

    private static float getShootingPower(class_9278 projectile) {
        return projectile.method_57438(class_1802.field_8639) ? 1.6f : 3.15f;
    }
}

