/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.loot;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_117;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import smartin.miapi.Miapi;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.material.AllowedMaterial;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.AllowedInLootProperty;
import smartin.miapi.modules.properties.ItemIdProperty;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.registries.RegistryInventory;

public record ModuleSwapLootFunction(class_2960 material, double chance, Optional<List<class_2960>> blacklist, Optional<List<class_2960>> whitelist, boolean allowStackable) implements class_117
{
    public static MapCodec<ModuleSwapLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("material", (Object)Miapi.id("empty")).forGetter(c -> c.material), (App)Codec.DOUBLE.fieldOf("chance").orElse((Object)1.0).forGetter(c -> c.chance), (App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("blacklist").forGetter(c -> c.blacklist), (App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("whitelist").forGetter(c -> c.whitelist), (App)Codec.BOOL.optionalFieldOf("allow_stackable", (Object)false).forGetter(c -> c.allowStackable())).apply((Applicative)instance, ModuleSwapLootFunction::new));

    @NotNull
    public class_5339<? extends class_117> method_29321() {
        return RegistryInventory.moduleSwapLootFunctionLootItemFunctionType;
    }

    public class_1799 apply(class_1799 stack, class_47 lootContext) {
        class_1799 modular = ModularItemStackConverter.getModularVersion(stack);
        if (ModularItem.isModularItem(modular)) {
            if (modular.method_7946() && !this.allowStackable()) {
                return stack;
            }
            ModuleInstance root = ItemModule.getModules(modular);
            if (VisualModularItem.isVisualModularItem(stack)) {
                return stack;
            }
            Material highestMaterial = MaterialProperty.getMaterial(root);
            for (ModuleInstance module : root.allSubModules()) {
                Material otherMaterial = MaterialProperty.getMaterial(module);
                if (highestMaterial == null) {
                    highestMaterial = otherMaterial;
                    continue;
                }
                if (otherMaterial == null || !this.isHigher(highestMaterial, otherMaterial)) continue;
                highestMaterial = otherMaterial;
            }
            if (this.material != null) {
                Material fromJson = MaterialProperty.MATERIAL_REGISTRY.get(this.material);
                if (highestMaterial == null || fromJson != null && this.isHigher(highestMaterial, fromJson)) {
                    highestMaterial = fromJson;
                }
            }
            root = this.randomizeModuleAndChildren(root, highestMaterial, lootContext.method_294());
            root.writeToItem(modular);
            modular = ItemIdProperty.changeId(modular);
        }
        return modular;
    }

    ModuleInstance randomizeModuleAndChildren(ModuleInstance moduleInstance, Material fallBackMaterial, class_5819 randomSource) {
        if ((double)randomSource.method_43057() <= this.chance()) {
            try {
                moduleInstance = this.findPossibleSubstitute(moduleInstance, randomSource);
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("could not randomize module", (Throwable)e);
            }
        }
        LinkedHashMap<String, ModuleInstance> submodules = new LinkedHashMap<String, ModuleInstance>(moduleInstance.getSubModuleMap());
        for (Map.Entry entry : submodules.entrySet()) {
            moduleInstance.setSubModule((String)entry.getKey(), this.randomizeModuleAndChildren((ModuleInstance)entry.getValue(), fallBackMaterial, randomSource));
            moduleInstance.clearCaches();
        }
        return moduleInstance;
    }

    ModuleInstance findPossibleSubstitute(ModuleInstance module, class_5819 randomSource) {
        List<ItemModule> possibleSubstitutes = RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.getFlatMap().values().stream().filter(m -> {
            if (this.whitelist().isPresent() && !this.whitelist().get().contains(m.id())) {
                return false;
            }
            if (this.blacklist().isPresent() && this.blacklist().get().contains(m.id())) {
                return false;
            }
            if (!(AllowedInLootProperty.property.isTrue((ItemModule)m) || this.whitelist().isPresent() && this.whitelist().get().contains(m.id()))) {
                return false;
            }
            Map<String, SlotProperty.ModuleSlot> testSlots = SlotProperty.getSlots(module);
            LinkedHashMap slots = new LinkedHashMap(SlotProperty.getInstance().getData((ItemModule)m).orElse(new LinkedHashMap()));
            for (String key : testSlots.keySet()) {
                if (!slots.containsKey(key)) {
                    return false;
                }
                ModuleInstance subModule = module.getSubModule(key);
                if (subModule == null || ((SlotProperty.ModuleSlot)slots.get(key)).allowedIn(subModule)) continue;
                return false;
            }
            SlotProperty.ModuleSlot parentSlot = SlotProperty.getSlotIn(module);
            if (parentSlot != null && !parentSlot.allowedIn((ItemModule)m)) {
                return false;
            }
            Material material1 = MaterialProperty.getMaterial(module);
            Optional data = AllowedMaterial.property.getData((ItemModule)m);
            if (material1 != null) {
                if (data.isEmpty()) {
                    return false;
                }
                if (!((AllowedMaterial.AllowedMaterialData)data.get()).isValid(material1)) {
                    return false;
                }
            }
            return true;
        }).toList();
        if (possibleSubstitutes.isEmpty()) {
            return module;
        }
        int randomIndex = randomSource.method_43048(possibleSubstitutes.size());
        ModuleInstance moduleInstance = new ModuleInstance(possibleSubstitutes.get(randomIndex));
        moduleInstance.moduleData = new HashMap<class_2960, JsonElement>(module.moduleData);
        module.subModules.forEach(moduleInstance::setSubModule);
        moduleInstance.clearCaches();
        return moduleInstance;
    }

    public boolean isHigher(Material material, Material other) {
        int otherMiningLevel;
        int roughMiningLevel = this.getTagSize(material.getIncorrectBlocksForDrops());
        if (roughMiningLevel != (otherMiningLevel = this.getTagSize(other.getIncorrectBlocksForDrops()))) {
            return otherMiningLevel < roughMiningLevel;
        }
        double tierDiff = this.isHigher(material, other, "tier", false);
        if (tierDiff != 0.0) {
            return tierDiff > 0.0;
        }
        double hardness = this.isHigher(material, other, "hardness", true);
        if (hardness != 0.0) {
            return hardness > 0.5;
        }
        double flexibility = this.isHigher(material, other, "flexibility", true);
        if (flexibility != 0.0) {
            return flexibility > 1.0;
        }
        return false;
    }

    public double isHigher(Material material, Material other, String stat, boolean canBeZero) {
        double materialHardness = material.getDouble(stat);
        double otherMaterialHardness = other.getDouble(stat);
        if (!canBeZero ? materialHardness != otherMaterialHardness && materialHardness != 0.0 && otherMaterialHardness != 0.0 : materialHardness != otherMaterialHardness) {
            return materialHardness - otherMaterialHardness;
        }
        return 0.0;
    }

    public int getTagSize(class_6862<class_2248> tag) {
        return class_7923.field_41175.method_40266(tag).map(holders -> (int)holders.method_40239().count()).orElse(0);
    }
}

