/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.blueprint.BlueprintComponent;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.crafter.replace.MaterialCraftingWidget;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.craft.MaterialCraftInfo;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.render.ServerReplaceProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;

public class BlueprintCrafting
extends ServerReplaceProperty
implements CraftingProperty {
    public static class_2960 KEY = Miapi.id("runtime_blueprint_property");
    double materialCostClient = 0.0;
    double materialRequirementClient = 0.0;
    int slotHeight = 19;

    @Override
    @Environment(value=EnvType.CLIENT)
    public InteractAbleWidget createGui(int x, int y, int width, int height, CraftAction craftAction) {
        BlueprintComponent blueprintComponent = BlueprintComponent.getBlueprint(craftAction.data, craftAction.screenHandler);
        if (blueprintComponent != null && !blueprintComponent.useMaterialCrafting()) {
            return new MaterialCraftingWidget(new MaterialCraftInfo(){

                @Override
                public int getSlotHeight() {
                    return BlueprintCrafting.this.slotHeight;
                }

                @Override
                public void setSlotHeight(int newHeight) {
                    BlueprintCrafting.this.slotHeight = newHeight;
                }

                @Override
                public double getMaterialCostClient() {
                    return BlueprintCrafting.this.materialCostClient;
                }

                @Override
                public double getMaterialRequirementClient() {
                    return BlueprintCrafting.this.materialRequirementClient;
                }

                @Override
                public boolean renderMaterialWidget() {
                    return false;
                }
            }, x, y, width, height, craftAction);
        }
        return null;
    }

    @Override
    public List<class_241> getSlotPositions() {
        return List.of(new class_241(96.0f, (float)(this.slotHeight - 12)));
    }

    @Override
    public boolean shouldExecuteOnCraft(@Nullable ModuleInstance module, ModuleInstance root, class_1799 stack, CraftAction craftAction) {
        BlueprintComponent blueprintComponent = BlueprintComponent.getBlueprint(craftAction.data, craftAction.screenHandler);
        return blueprintComponent != null;
    }

    @Override
    public float getPriority() {
        return -10.0f;
    }

    @Override
    public boolean canPerform(class_1799 old, class_1799 crafting, @Nullable ModularWorkBenchEntity bench, class_1657 player, CraftAction craftAction, ItemModule module, List<class_1799> inventory, Map<class_2960, JsonElement> data) {
        BlueprintComponent blueprintComponent = BlueprintComponent.getBlueprint(craftAction.data, craftAction.screenHandler);
        if (blueprintComponent != null) {
            if (blueprintComponent.useMaterialCrafting()) {
                return true;
            }
            class_1799 input = inventory.getFirst();
            this.materialRequirementClient = blueprintComponent.getCost();
            this.materialCostClient = 0.0;
            if (blueprintComponent.isValidCorrectType(input, blueprintComponent.retrieve(craftAction.screenHandler))) {
                this.materialCostClient = input.method_7947();
                return blueprintComponent.isValid(input, blueprintComponent.retrieve(craftAction.screenHandler));
            }
            return false;
        }
        return true;
    }

    @Override
    public class_1799 preview(class_1799 old, class_1799 crafting, class_1657 player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<class_1799> inventory, Map<class_2960, JsonElement> data) {
        ModuleInstance moduleInstance;
        BlueprintComponent blueprintComponent = BlueprintComponent.getBlueprint(craftAction.data, craftAction.screenHandler);
        if (blueprintComponent != null && (moduleInstance = craftAction.getModifyingModuleInstance(crafting)) != null) {
            blueprintComponent.apply(moduleInstance);
            moduleInstance.getRoot().writeToItem(crafting);
        }
        return crafting;
    }

    @Override
    public List<class_1799> performCraftAction(class_1799 old, class_1799 crafting, class_1657 player, @Nullable ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<class_1799> inventory, Map<class_2960, JsonElement> data) {
        List<class_1799> result = CraftingProperty.super.performCraftAction(old, crafting, player, bench, craftAction, module, inventory, data);
        BlueprintComponent blueprintComponent = BlueprintComponent.getBlueprint(craftAction.data, craftAction.screenHandler);
        if (blueprintComponent != null && !blueprintComponent.useMaterialCrafting()) {
            result.set(1, blueprintComponent.adjustCost(inventory.getFirst()));
        }
        return result;
    }
}

