/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.blueprint.IngredientWithCount;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.material.MaterialIcons;
import smartin.miapi.material.MaterialVariant;
import smartin.miapi.material.base.IngredientController;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.base.PropertyController;
import smartin.miapi.material.palette.FallbackColorer;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.material.palette.MaterialRenderControllers;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleDataPropertiesManager;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.properties.render.ColorProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class CodecMaterial
implements Material {
    class_2960 id;
    public Optional<JsonElement> iconJson;
    Optional<JsonElement> paletteJson;
    Optional<JsonElement> dyePaletteJson;
    Map<String, Map<ModuleProperty<?>, Object>> mergedAllAppliedProperties = new HashMap();
    Map<String, Map<ModuleProperty<?>, Object>> mergedAllVisualProperties = new HashMap();
    Map<String, Map<ModuleProperty<?>, Object>> normalProperties = new HashMap();
    Map<String, Map<ModuleProperty<?>, Object>> displayProperties = new HashMap();
    Map<String, Map<ModuleProperty<?>, Object>> hiddenProperties = new HashMap();
    public List<String> groups;
    List<String> guiGroups;
    public List<String> textureKeys;
    Optional<class_6862<class_2248>> incorrectForTool = Optional.empty();
    Optional<Integer> color = Optional.empty();
    public List<IngredientWithCount> items;
    public Map<String, String> stringData = new HashMap<String, String>();
    public Map<String, Double> doubleMap = new HashMap<String, Double>();
    public Optional<class_2561> translation = Optional.empty();
    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public MaterialIcons.MaterialIcon icon;
    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    protected MaterialRenderController palette;
    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    @Nullable
    protected MaterialRenderController dyeAblePalette;
    public Either<Boolean, List<class_6880<class_1792>>> toGenerate = Either.left((Object)false);
    public List<MaterialVariant> variants = new ArrayList<MaterialVariant>();
    public static final Codec<CodecMaterial> CODEC = new Codec<CodecMaterial>(){

        public <T> DataResult<Pair<CodecMaterial, T>> decode(DynamicOps<T> ops, T input) {
            HashMap<String, String> stringData = new HashMap<String, String>();
            HashMap<String, Double> doubleMap = new HashMap<String, Double>();
            try {
                ((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)).getAsJsonObject().asMap().forEach((key, element) -> {
                    if (element.isJsonPrimitive()) {
                        try {
                            stringData.put((String)key, element.getAsString());
                        }
                        catch (Exception e) {
                            Miapi.LOGGER.debug("Failed to read '{}' as string: {}", key, (Object)e.getMessage());
                        }
                        try {
                            doubleMap.put((String)key, element.getAsDouble());
                        }
                        catch (Exception e) {
                            Miapi.LOGGER.debug("Failed to read '{}' as double: {}", key, (Object)e.getMessage());
                        }
                    }
                });
            }
            catch (Exception e) {
                Miapi.LOGGER.error("Error converting input during decode: {}", input, (Object)e);
                return DataResult.error(() -> "Failed to parse input: " + e.getMessage());
            }
            DataResult dataResult = INNER_CODEC.decode(ops, input);
            if (dataResult.isSuccess()) {
                try {
                    ((CodecMaterial)((Pair)dataResult.getOrThrow()).getFirst()).setData(stringData, doubleMap);
                }
                catch (Exception e) {
                    Miapi.LOGGER.error("Failed to attach parsed data to CodecMaterial", (Throwable)e);
                    return DataResult.error(() -> "Failed to attach parsed data: " + e.getMessage());
                }
            } else {
                Miapi.LOGGER.warn("INNER_CODEC failed to decode input: {}", input);
                Miapi.LOGGER.warn(((DataResult.Error)dataResult.error().get()).message());
            }
            return dataResult;
        }

        public <T> DataResult<T> encode(CodecMaterial input, DynamicOps<T> ops, T prefix) {
            UnboundedMapCodec stringCodec = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING);
            prefix = stringCodec.encode(input.stringData, ops, prefix).result().get();
            UnboundedMapCodec doubleCodec = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.DOUBLE);
            prefix = doubleCodec.encode(input.doubleMap, ops, prefix).result().get();
            return INNER_CODEC.encode((Object)input, ops, prefix);
        }
    };
    public static final Codec<CodecMaterial> INNER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StatResolver.Codecs.JSONELEMENT_CODEC.optionalFieldOf("icon").forGetter(material -> material.iconJson), (App)StatResolver.Codecs.JSONELEMENT_CODEC.optionalFieldOf("color_palette").forGetter(material -> material.paletteJson), (App)StatResolver.Codecs.JSONELEMENT_CODEC.optionalFieldOf("dye_color_palette").forGetter(material -> material.dyePaletteJson), (App)Codec.STRING.listOf().optionalFieldOf("groups", new ArrayList()).forGetter(m -> m.getGroups().stream().filter(g -> m.getGuiGroups().contains(g)).toList()), (App)Codec.STRING.listOf().optionalFieldOf("hidden_groups", new ArrayList()).forGetter(m -> m.getGroups().stream().filter(g -> !m.getGuiGroups().contains(g)).toList()), (App)Codec.STRING.listOf().optionalFieldOf("gui_groups", new ArrayList()).forGetter(m -> m.getGuiGroups().stream().filter(g -> !m.getGroups().contains(g)).toList()), (App)Codec.unboundedMap((Codec)Codec.STRING, StatResolver.Codecs.JSONELEMENT_CODEC).optionalFieldOf("properties", new HashMap()).forGetter(m -> PropertyController.toJsonMap(m.normalProperties)), (App)Codec.unboundedMap((Codec)Codec.STRING, StatResolver.Codecs.JSONELEMENT_CODEC).optionalFieldOf("display_properties", new HashMap()).forGetter(m -> PropertyController.toJsonMap(m.displayProperties)), (App)Codec.unboundedMap((Codec)Codec.STRING, StatResolver.Codecs.JSONELEMENT_CODEC).optionalFieldOf("hidden_properties", new HashMap()).forGetter(m -> PropertyController.toJsonMap(m.hiddenProperties)), (App)Codec.STRING.listOf().optionalFieldOf("textures", List.of("default")).forGetter(CodecMaterial::getTextureKeys), (App)class_2960.field_25139.optionalFieldOf("mining_level").forGetter(material -> Optional.of(material.getIncorrectBlocksForDrops().comp_327())), (App)class_8824.field_46597.optionalFieldOf("translation").forGetter(material -> material.translation), (App)Codec.STRING.optionalFieldOf("color").forGetter(m -> Optional.of(Long.toHexString((long)m.getColor(new ModuleInstance(ItemModule.empty)) & 0xFFFFFFFFFFFFFFFFL))), (App)IngredientWithCount.CODEC.listOf().optionalFieldOf("items", new ArrayList()).forGetter(material -> material.items), (App)Codec.either(Miapi.FIXED_BOOL_CODEC, (Codec)class_1799.field_47312.listOf()).optionalFieldOf("generate_converters", (Object)Either.left((Object)false)).forGetter(m -> m.toGenerate), (App)MaterialVariant.CODEC.listOf().optionalFieldOf("variants", new ArrayList()).forGetter(m -> m.variants)).apply((Applicative)instance, CodecMaterial::new));
    private static List<class_1831> tieredItems;
    private static List<class_1738> armorItems;
    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public FallbackColorer fallbackColorer;

    public CodecMaterial(Optional<JsonElement> iconJson, Optional<JsonElement> paletteJson, Optional<JsonElement> dyePaletteJson, List<String> groups, List<String> hiddenGroups, List<String> guiGroups, Map<String, JsonElement> property, Map<String, JsonElement> visualProperty, Map<String, JsonElement> hiddenProperty, List<String> textureKeys, Optional<class_2960> incorrectForToolId, Optional<class_2561> translation, Optional<String> color, List<IngredientWithCount> items, Either<Boolean, List<class_6880<class_1792>>> generateConverters, List<MaterialVariant> variants) {
        this.variants = variants;
        this.iconJson = iconJson;
        this.paletteJson = paletteJson;
        this.dyePaletteJson = dyePaletteJson;
        this.groups = new ArrayList<String>(groups);
        this.guiGroups = new ArrayList<String>(guiGroups);
        this.guiGroups.addAll(groups);
        this.groups.addAll(hiddenGroups);
        this.textureKeys = textureKeys;
        this.translation = translation;
        if (incorrectForToolId.isPresent()) {
            Optional<Pair> found = class_7923.field_41175.method_40272().filter(pair -> ((class_6862)pair.getFirst()).comp_327().equals(incorrectForToolId.get())).findAny();
            found.ifPresent(tagKeyNamedPair -> {
                this.incorrectForTool = Optional.of((class_6862)tagKeyNamedPair.getFirst());
            });
        }
        if (color.isPresent()) {
            try {
                long longValue = Long.parseLong(color.get(), 16);
                this.color = Optional.of((int)(longValue & 0xFFFFFFFFL));
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.info("failed color decoding");
            }
        }
        this.items = items;
        this.toGenerate = generateConverters;
        hiddenProperty.forEach((type, json) -> {
            Map<ModuleProperty<?>, Object> data = ModuleDataPropertiesManager.resolvePropertiesFromJson(json);
            this.mergedAllAppliedProperties.put((String)type, data);
            this.hiddenProperties.put((String)type, data);
        });
        property.forEach((type, json) -> {
            Map<ModuleProperty<?>, Object> data = ModuleDataPropertiesManager.resolvePropertiesFromJson(json);
            this.mergedAllAppliedProperties.put((String)type, data);
            this.mergedAllVisualProperties.put((String)type, data);
            this.normalProperties.put((String)type, data);
        });
        visualProperty.forEach((type, json) -> {
            Map<ModuleProperty<?>, Object> data = ModuleDataPropertiesManager.resolvePropertiesFromJson(json);
            this.mergedAllVisualProperties.put((String)type, data);
            this.displayProperties.put((String)type, data);
        });
        if (Environment.isClient()) {
            this.clientSetup(iconJson, paletteJson, dyePaletteJson);
        }
    }

    public void setup() {
        if (Environment.isClient()) {
            this.clientSetup(this.iconJson, this.paletteJson, this.dyePaletteJson);
        }
    }

    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    private void clientSetup(Optional<JsonElement> iconJson, Optional<JsonElement> paletteJson, Optional<JsonElement> dyePaletteJson) {
        if (iconJson.isPresent()) {
            JsonPrimitive primitive;
            JsonElement jsonElement = iconJson.get();
            this.icon = jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isString() ? new MaterialIcons.TextureMaterialIcon(class_2960.method_60654((String)primitive.getAsString())) : MaterialIcons.getMaterialIcon(this.id, iconJson.get());
        }
        if (paletteJson.isPresent()) {
            this.palette = MaterialRenderControllers.creators.get(paletteJson.get().getAsJsonObject().get("type").getAsString()).createPalette(paletteJson.get(), this);
            if (this.color.isEmpty()) {
                this.color = Optional.of(this.palette.getAverageColor().argb());
            }
        }
        dyePaletteJson.ifPresent(element -> {
            this.dyeAblePalette = MaterialRenderControllers.creators.get(element.getAsJsonObject().get("type").getAsString()).createPalette((JsonElement)element, this);
        });
    }

    public CodecMaterial copy() {
        CodecMaterial copy = new CodecMaterial(this.iconJson, this.paletteJson, this.dyePaletteJson, new ArrayList<String>(this.groups), List.of(), new ArrayList<String>(this.guiGroups), PropertyController.toJsonMap(this.normalProperties), PropertyController.toJsonMap(this.hiddenProperties), PropertyController.toJsonMap(this.displayProperties), new ArrayList<String>(this.textureKeys), this.incorrectForTool.map(class_6862::comp_327), this.translation, this.color.map(Integer::toHexString), new ArrayList<IngredientWithCount>(this.items), this.toGenerate, new ArrayList<MaterialVariant>(this.variants));
        copy.id = this.id;
        copy.stringData = new HashMap<String, String>(this.stringData);
        copy.doubleMap = new HashMap<String, Double>(this.doubleMap);
        copy.mergedAllAppliedProperties = new HashMap(this.mergedAllAppliedProperties);
        copy.mergedAllVisualProperties = new HashMap(this.mergedAllVisualProperties);
        copy.incorrectForTool = this.incorrectForTool;
        copy.translation = this.translation;
        copy.iconJson = this.iconJson;
        copy.paletteJson = this.paletteJson;
        copy.dyePaletteJson = this.dyePaletteJson;
        if (Environment.isClient()) {
            this.copyClient(copy);
        }
        return copy;
    }

    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    private void copyClient(CodecMaterial copy) {
        if (this.iconJson.isPresent()) {
            JsonPrimitive primitive;
            JsonElement jsonElement = this.iconJson.get();
            copy.icon = jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isString() ? new MaterialIcons.TextureMaterialIcon(class_2960.method_60654((String)primitive.getAsString())) : MaterialIcons.getMaterialIcon(this.id, this.iconJson.get());
        }
        if (copy.paletteJson.isPresent()) {
            copy.palette = MaterialRenderControllers.creators.get(copy.paletteJson.get().getAsJsonObject().get("type").getAsString()).createPalette(copy.paletteJson.get(), this);
            if (copy.color.isEmpty()) {
                copy.color = Optional.of(this.palette.getAverageColor().argb());
            }
        }
        if (copy.dyePaletteJson.isPresent()) {
            copy.dyeAblePalette = MaterialRenderControllers.creators.get(copy.dyePaletteJson.get().getAsJsonObject().get("type").getAsString()).createPalette(copy.dyePaletteJson.get(), this);
            if (copy.color.isEmpty()) {
                copy.color = Optional.of(this.dyeAblePalette.getAverageColor().argb());
            }
        }
    }

    public void merge(CodecMaterial material) {
        if (material.iconJson.isPresent()) {
            this.iconJson = material.iconJson;
        }
        if (material.paletteJson.isPresent()) {
            this.paletteJson = material.paletteJson;
            this.palette = MaterialRenderControllers.creators.get(this.paletteJson.get().getAsJsonObject().get("type").getAsString()).createPalette(this.paletteJson.get(), this);
        }
        if (material.dyePaletteJson.isPresent()) {
            this.dyePaletteJson = material.paletteJson;
            this.dyeAblePalette = MaterialRenderControllers.creators.get(this.dyePaletteJson.get().getAsJsonObject().get("type").getAsString()).createPalette(this.dyePaletteJson.get(), this);
        }
        this.groups = new ArrayList<String>(this.groups);
        this.groups.addAll(material.groups);
        this.guiGroups = new ArrayList<String>(this.guiGroups);
        this.guiGroups.addAll(material.guiGroups);
        CodecMaterial.mergeProperties(material.mergedAllAppliedProperties, this.mergedAllAppliedProperties);
        CodecMaterial.mergeProperties(material.mergedAllVisualProperties, this.mergedAllVisualProperties);
        this.textureKeys = new ArrayList<String>(this.textureKeys);
        this.textureKeys.addAll(material.textureKeys);
        material.incorrectForTool.ifPresent(tagKey -> {
            this.incorrectForTool = Optional.of(tagKey);
        });
        if (material.color.isPresent()) {
            this.color = material.color;
        }
        this.items = new ArrayList<IngredientWithCount>(this.items);
        this.items.addAll(material.items);
        this.toGenerate = material.toGenerate;
        this.stringData.putAll(material.stringData);
        this.doubleMap.putAll(material.doubleMap);
        material.translation.ifPresent(value -> {
            this.translation = Optional.of(value);
        });
        if (Environment.isClient()) {
            this.mergeClient(material);
        }
    }

    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    private void mergeClient(CodecMaterial material) {
        if (material.icon != null) {
            this.icon = material.icon;
        }
        if (material.palette != null) {
            this.palette = material.palette;
        }
        this.dyeAblePalette = material.dyeAblePalette;
    }

    private static void mergeProperties(Map<String, Map<ModuleProperty<?>, Object>> source, Map<String, Map<ModuleProperty<?>, Object>> target) {
        source.forEach((key, sourceProperties) -> {
            Map targetProperties = target.getOrDefault(key, new HashMap());
            sourceProperties.forEach((property, sourceValue) -> {
                if (targetProperties.containsKey(property)) {
                    Object targetValue = targetProperties.get(property);
                    targetProperties.put(property, ItemModule.merge(property, targetValue, sourceValue, MergeType.SMART));
                } else {
                    targetProperties.put(property, sourceValue);
                }
            });
            target.put((String)key, targetProperties);
        });
    }

    public void setID(class_2960 id) {
        this.id = id;
        ArrayList<String> g = new ArrayList<String>(this.groups);
        g.addFirst(this.getStringID());
        this.groups = g;
        this.guiGroups = new ArrayList<String>(this.guiGroups);
    }

    public void setData(Map<String, String> stringData, Map<String, Double> doubleMap) {
        this.stringData = stringData;
        this.doubleMap = doubleMap;
    }

    @Override
    public double getDouble(String property) {
        return this.doubleMap.getOrDefault(property, 0.0);
    }

    @Override
    public String getData(String property) {
        return this.stringData.getOrDefault(property, "");
    }

    @Override
    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public int renderIcon(class_332 drawContext, int x, int y) {
        if (this.icon == null) {
            return 0;
        }
        return this.icon.render(drawContext, x, y);
    }

    @Override
    public void addSmithingGroup() {
        if (!this.groups.contains("smithing")) {
            this.groups = new ArrayList<String>(this.groups);
            this.groups.add("smithing");
        }
        if (!this.guiGroups.contains("smithing")) {
            this.guiGroups = new ArrayList<String>(this.guiGroups);
            this.guiGroups.add("smithing");
        }
    }

    @Override
    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public boolean hasIcon() {
        return this.icon != null;
    }

    @Override
    public class_2960 getID() {
        return this.id;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public List<String> getGuiGroups() {
        return this.guiGroups;
    }

    @Override
    public Map<ModuleProperty<?>, Object> materialProperties(String key) {
        return this.mergedAllAppliedProperties.getOrDefault(key, new HashMap());
    }

    @Override
    public Map<ModuleProperty<?>, Object> getDisplayMaterialProperties(String key) {
        return this.mergedAllVisualProperties.getOrDefault(key, new HashMap());
    }

    @Override
    public List<String> getAllPropertyKeys() {
        return new ArrayList<String>(this.mergedAllAppliedProperties.keySet());
    }

    @Override
    public List<String> getAllDisplayPropertyKeys() {
        return new ArrayList<String>(this.mergedAllVisualProperties.keySet());
    }

    @Override
    public List<String> getTextureKeys() {
        return this.textureKeys;
    }

    private static List<class_1831> getTieredItems() {
        if (tieredItems == null) {
            tieredItems = class_7923.field_41178.method_10220().filter(class_1831.class::isInstance).map(i -> (class_1831)i).toList();
        }
        return tieredItems;
    }

    private static List<class_1738> getArmorItems() {
        if (armorItems == null) {
            armorItems = class_7923.field_41178.method_10220().filter(class_1738.class::isInstance).map(i -> (class_1738)i).toList();
        }
        return armorItems;
    }

    public void generateConverters(boolean isClient) {
        if (this.toGenerate.left().isPresent()) {
            if (((Boolean)this.toGenerate.left().get()).booleanValue()) {
                ArrayList<class_1831> matchedTiered = null;
                ArrayList<class_1738> matchedArmor = null;
                for (class_1831 class_18312 : CodecMaterial.getTieredItems()) {
                    if (this.getPriorityOfIngredientItem(class_18312.method_7854()) == null) continue;
                    if (matchedTiered == null) {
                        matchedTiered = new ArrayList<class_1831>();
                    }
                    matchedTiered.add(class_18312);
                }
                for (class_1738 class_17382 : CodecMaterial.getArmorItems()) {
                    if (this.getPriorityOfIngredientItem(class_17382.method_7854()) == null) continue;
                    if (matchedArmor == null) {
                        matchedArmor = new ArrayList<class_1738>();
                    }
                    matchedArmor.add(class_17382);
                }
                if (matchedTiered != null && !matchedTiered.isEmpty() || matchedArmor != null && !matchedArmor.isEmpty()) {
                    ((MiapiEvents.CreateMaterialModularConvertersEvent)MiapiEvents.GENERATE_MATERIAL_CONVERTERS.invoker()).generated(this, matchedTiered != null ? matchedTiered : List.of(), matchedArmor != null ? matchedArmor : List.of(), isClient);
                }
            }
        } else {
            List<class_1792> items = ((List)this.toGenerate.right().get()).stream().map(class_6880::comp_349).toList();
            ((MiapiEvents.CreateMaterialModularConvertersEvent)MiapiEvents.GENERATE_MATERIAL_CONVERTERS.invoker()).generated(this, items.stream().filter(class_1831.class::isInstance).map(i -> (class_1831)i).toList(), items.stream().filter(class_1738.class::isInstance).map(i -> (class_1738)i).toList(), isClient);
        }
    }

    @Override
    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public int getColor(ModuleInstance context) {
        return this.color.orElse(Color.BLACK.getRGB());
    }

    @Override
    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public MaterialRenderController getRenderController(ModuleInstance context, class_811 mode) {
        if (context.contextStack != null && this.dyeAblePalette != null && ColorProperty.hasColor(context.contextStack, context)) {
            return this.dyeAblePalette;
        }
        if (this.palette == null) {
            if (this.fallbackColorer == null) {
                this.fallbackColorer = new FallbackColorer(this);
            }
            return this.fallbackColorer;
        }
        return this.palette;
    }

    @Override
    public boolean canBeDyed() {
        return this.dyePaletteJson.isPresent();
    }

    @Override
    public double getValueOfItem(class_1799 item) {
        if (this.items == null) {
            return 0.0;
        }
        for (IngredientWithCount value : this.items) {
            if (!value.ingredient.method_8093(item)) continue;
            return value.count;
        }
        return 0.0;
    }

    @Override
    public Double getPriorityOfIngredientItem(class_1799 item) {
        if (this.items == null) {
            return null;
        }
        for (IngredientWithCount value : this.items) {
            if (!value.ingredient.method_8093(item)) continue;
            return value.count;
        }
        return null;
    }

    @Override
    public class_1856 getRepairIngredient() {
        return IngredientController.mergeIngredients(this.items.stream().map(ingredientWithCount -> ingredientWithCount.ingredient));
    }

    @Override
    public JsonObject getDebugJson() {
        return ((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow()).getAsJsonObject();
    }

    @Override
    public class_6862<class_2248> getIncorrectBlocksForDrops() {
        return this.incorrectForTool.orElse((class_6862<class_2248>)class_3481.field_49930);
    }

    @Override
    public Material getMaterial(ModuleInstance moduleInstance, Map<ModuleProperty<?>, Object> properties) {
        ConditionManager.ConditionContext context = ConditionManager.moduleContext(moduleInstance, properties);
        for (MaterialVariant variant : this.variants) {
            if (!variant.condition().isAllowed(context)) continue;
            CodecMaterial material = this.copy();
            material.setID(this.getID());
            material.merge(variant.overwrite());
            material.setID(this.getID());
            material.setup();
            return material;
        }
        return this;
    }

    public int hashCode() {
        return this.getID().hashCode() + 13 * this.variants.size();
    }

    @Override
    public class_2561 getTranslation() {
        return this.translation.orElseGet(() -> class_2561.method_43471((String)("miapi.material." + this.getStringID())));
    }
}

