/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import com.redpxnda.nucleus.codec.misc.MiscCodecs;
import com.redpxnda.nucleus.codec.misc.PolyCodec;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_898;
import net.minecraft.class_918;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class MaterialIcons {
    public static final Map<String, MaterialIconCreator> iconCreators = new HashMap<String, MaterialIconCreator>();
    public static MaterialIconCreator textureIconCreator;

    public static MaterialIcon getMaterialIcon(class_2960 materialKey, JsonElement element) {
        return iconCreators.get(element.getAsJsonObject().get("type").getAsString()).create(element, materialKey);
    }

    public static void setup() {
        textureIconCreator = (element, mat) -> {
            JsonPrimitive primitive;
            if (!(element instanceof JsonObject)) {
                throw new RuntimeException("JSON data for the icon of the '" + String.valueOf(mat) + "' material is not a JSON object! -> " + String.valueOf(element));
            }
            JsonObject object = (JsonObject)element;
            JsonElement patt0$temp = object.get("path");
            if (!(patt0$temp instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)patt0$temp).isString()) {
                throw new RuntimeException("'path' field for the icon of the '" + String.valueOf(mat) + "' material is either missing, or not a string! -> " + String.valueOf(element));
            }
            return new TextureMaterialIcon(class_2960.method_60654((String)primitive.getAsString()));
        };
        iconCreators.put("texture", textureIconCreator);
        Codec byItem = class_7923.field_41178.method_39673().xmap(class_1792::method_7854, class_1799::method_7909);
        iconCreators.put("item", (element, mat) -> {
            int n;
            if (!(element instanceof JsonObject)) {
                throw new RuntimeException("JSON data for the icon of the '" + String.valueOf(mat) + "' material is not a JSON object! -> " + String.valueOf(element));
            }
            JsonObject object = (JsonObject)element;
            if (!object.has("item")) {
                throw new RuntimeException("'item' field for the icon of the '" + String.valueOf(mat) + "' material is missing! -> " + String.valueOf(element));
            }
            class_1799 stack = (class_1799)MiscCodecs.quickParse((JsonElement)object.get("item"), (Codec)PolyCodec.of((Codec[])new Codec[]{byItem, class_1799.field_24671}), s -> new RuntimeException("Failed to parse item for the icon of the '" + String.valueOf(mat) + "' material! -> " + s));
            JsonElement patt0$temp = object.get("offset");
            if (patt0$temp instanceof JsonPrimitive) {
                JsonPrimitive prim = (JsonPrimitive)patt0$temp;
                n = prim.getAsInt();
            } else {
                n = 16;
            }
            int offset = n;
            SpinSettings spin = object.has("spin") ? (SpinSettings)MiscCodecs.quickParse((JsonElement)object.get("spin"), SpinSettings.CODEC, s -> new RuntimeException("Failed to parse spin settings for item icon of the '" + String.valueOf(mat) + "' material! -> " + s)) : null;
            return new ItemMaterialIcon(stack, offset, spin);
        });
        iconCreators.put("entity", (element, materialKey) -> {
            EntityIconHolder holder = (EntityIconHolder)MiscCodecs.quickParse((JsonElement)element, EntityIconHolder.codec, s -> new RuntimeException("Failed to parse entity icon for the '" + String.valueOf(materialKey) + "' material! -> " + s));
            return new EntityMaterialIcon(holder);
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void renderRotatingItem(class_332 context, class_1799 stack, int x, int y, int z, SpinSettings spin) {
        if (stack.method_7960()) {
            return;
        }
        class_918 itemRenderer = class_310.method_1551().method_1480();
        class_1087 bakedModel = itemRenderer.method_4019(stack, (class_1937)class_310.method_1551().field_1687, (class_1309)class_310.method_1551().field_1724, 0);
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)(x + 8), (float)(y + 8), (float)(150 + (bakedModel.method_4712() ? z : 0)));
        boolean bl = !bakedModel.method_24304();
        context.method_51448().method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        context.method_51448().method_22905(16.0f, 16.0f, 16.0f);
        spin.multiplyMatrices(context.method_51448());
        if (bl) {
            class_308.method_24210();
        }
        itemRenderer.method_23179(stack, class_811.field_4317, false, context.method_51448(), (class_4597)context.method_51450(), 0xF000F0, class_4608.field_21444, bakedModel);
        context.method_51452();
        if (bl) {
            class_308.method_24211();
        }
        context.method_51448().method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    public static void renderRotatingEntity(class_332 context, int x, int y, int z, EntityIconHolder holder) {
        if (holder.actual == null) {
            holder.actual = holder.entity.method_5883((class_1937)class_310.method_1551().field_1687);
        }
        class_898 renderer = class_310.method_1551().method_1561();
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)(x + 8) + holder.x, (float)(y + 16) - holder.y, (float)(150 + z));
        context.method_51448().method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        context.method_51448().method_22905(16.0f, 16.0f, 16.0f);
        context.method_51448().method_22905(holder.scale, holder.scale, holder.scale);
        if (holder.spin != null) {
            holder.spin.multiplyMatrices(context.method_51448());
        }
        renderer.method_3954(holder.actual, 0.0, 0.0, 0.0, 0.0f, 0.0f, context.method_51448(), (class_4597)class_310.method_1551().method_22940().method_23000(), 0xF000F0);
        context.method_51452();
        context.method_51448().method_22909();
    }

    public static interface MaterialIconCreator {
        public MaterialIcon create(JsonElement var1, class_2960 var2);
    }

    public static interface MaterialIcon {
        @Environment(value=EnvType.CLIENT)
        public int render(class_332 var1, int var2, int var3);
    }

    @CodecBehavior.Override(value="codec")
    @AutoCodec.Settings(defaultOptionalBehavior=@CodecBehavior.Optional)
    public static class SpinSettings {
        public static final Codec<SpinSettings> CODEC = AutoCodec.of(SpinSettings.class).codec();
        public boolean x = false;
        public boolean y = true;
        public boolean z = false;
        public int originX = 0;
        public int originY = 0;
        public int originZ = 0;
        public float speed = 1.0f;

        public void multiplyMatrices(class_4587 matrices) {
            float amount = (float)class_156.method_658() * (1.745E-4f * this.speed);
            matrices.method_49278(new Quaternionf().rotationXYZ(this.x ? amount : 0.0f, this.y ? amount : 0.0f, this.z ? amount : 0.0f), (float)this.originX, (float)this.originY, (float)this.originZ);
        }
    }

    public static class EntityIconHolder {
        public static final Codec<EntityIconHolder> codec = AutoCodec.of(EntityIconHolder.class).codec();
        @AutoCodec.Ignored
        public class_1297 actual = null;
        public class_1299<?> entity;
        @CodecBehavior.Optional
        public int offset = 16;
        @CodecBehavior.Optional
        public float x = 0.0f;
        @CodecBehavior.Optional
        public float y = 0.0f;
        @CodecBehavior.Optional
        public float scale = 0.85f;
        @CodecBehavior.Optional
        public SpinSettings spin = null;
    }

    public record EntityMaterialIcon(EntityIconHolder holder) implements MaterialIcon
    {
        @Override
        @Environment(value=EnvType.CLIENT)
        public int render(class_332 context, int x, int y) {
            MaterialIcons.renderRotatingEntity(context, x, y, 0, this.holder);
            return this.holder.offset;
        }
    }

    public record ItemMaterialIcon(class_1799 item, int offset, SpinSettings spin) implements MaterialIcon
    {
        @Override
        @Environment(value=EnvType.CLIENT)
        public int render(class_332 context, int x, int y) {
            if (this.spin != null) {
                MaterialIcons.renderRotatingItem(context, this.item, x, y, 0, this.spin);
            } else {
                context.method_51427(this.item, x, y);
            }
            return this.offset;
        }
    }

    public record TextureMaterialIcon(class_2960 texture) implements MaterialIcon
    {
        @Override
        @Environment(value=EnvType.CLIENT)
        public int render(class_332 context, int x, int y) {
            context.method_25290(this.texture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            return 16;
        }
    }
}

