/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.generated;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_2561;
import smartin.miapi.Miapi;

public class NamingUtil {
    public static String generateTranslation(List<class_1831> items, class_1799 mainIngredient) {
        ArrayList<String> names = new ArrayList<String>();
        items.forEach(item -> names.add(class_2561.method_43471((String)item.method_7876()).getString()));
        String materialName = class_2561.method_43471((String)mainIngredient.method_7922()).getString();
        String fakeTranslation = NamingUtil.findCommonSubstring(names, materialName);
        return fakeTranslation.trim();
    }

    static String findCommonSubstring(List<String> itemNames, String materialName) {
        int score;
        String commonString;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int highestScore = 0;
        String bestSubstring = "";
        for (String itemName : itemNames) {
            commonString = NamingUtil.longestSubsString(itemName, materialName);
            if (commonString.length() <= 3) continue;
            score = NamingUtil.calculateScore(commonString, 4);
            map.put(commonString, map.getOrDefault(commonString, 0) + score);
        }
        for (int i = 0; i < itemNames.size(); ++i) {
            for (int j = i + 1; j < itemNames.size(); ++j) {
                commonString = NamingUtil.longestSubsString(itemNames.get(i), itemNames.get(j));
                if (commonString.length() <= 3) continue;
                score = NamingUtil.calculateScore(commonString, 1);
                map.put(commonString, map.getOrDefault(commonString, 0) + score);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() <= highestScore) continue;
            highestScore = (Integer)entry.getValue();
            bestSubstring = (String)entry.getKey();
        }
        return bestSubstring;
    }

    private static int calculateScore(String substring, int weight) {
        int length = substring.length();
        int occurrences = 1;
        return weight * (length + occurrences * 3);
    }

    static String longestSubsString(String stringA, String stringB) {
        if (stringB == null || stringA == null) {
            return "";
        }
        try {
            if (stringB.length() > stringA.length()) {
                String buffer = stringA;
                stringA = stringB;
                stringB = buffer;
            }
            int aLength = stringA.length();
            int bLength = stringB.length();
            int result = 0;
            int end = 0;
            int[][] len = new int[2][bLength + 1];
            int currRow = 0;
            for (int i = 0; i <= aLength; ++i) {
                for (int j = 0; j <= bLength; ++j) {
                    if (i == 0 || j == 0) {
                        len[currRow][j] = 0;
                        continue;
                    }
                    if (stringA.charAt(i - 1) == stringB.charAt(j - 1)) {
                        len[currRow][j] = len[1 - currRow][j - 1] + 1;
                        if (len[currRow][j] <= result) continue;
                        result = len[currRow][j];
                        end = i;
                        continue;
                    }
                    len[currRow][j] = 0;
                }
                currRow = 1 - currRow;
            }
            if (result == 0) {
                return "";
            }
            return stringA.substring(end - result, end);
        }
        catch (Exception e) {
            Miapi.LOGGER.warn("Exception during string comparison", (Throwable)e);
            return "";
        }
    }
}

