/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.generated;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8060;
import net.minecraft.class_8786;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.item.MaterialSmithingRecipe;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.generated.GeneratedMaterial;
import smartin.miapi.material.generated.GeneratedMaterialManager;
import smartin.miapi.material.generated.GeneratedMaterialPropertyManager;
import smartin.miapi.mixin.smithing.SmithingTransformRecipeAccessor;

public class SmithingRecipeUtil {
    public static class_1863 manager = null;

    public static void setupSmithingRecipes(boolean isClient, class_5455 registryAccess, class_1863 manager) {
        List<GeneratedMaterial> materials = MaterialProperty.MATERIAL_REGISTRY.getFlatMap().values().stream().filter(GeneratedMaterial.class::isInstance).map(m -> (GeneratedMaterial)m).toList();
        materials.forEach(m -> MaterialProperty.MATERIAL_REGISTRY.remove(m.key));
        SmithingRecipeUtil.setupSmithingRecipe(materials, isClient, m -> MaterialProperty.MATERIAL_REGISTRY.register(m.key, (Material)m), registryAccess, null);
    }

    public static void setupSmithingRecipe(List<GeneratedMaterial> materials, boolean isClient, Consumer<GeneratedMaterial> register, class_5455 registryAccess, class_1863 recipeManager) {
        try {
            if (recipeManager == null) {
                recipeManager = SmithingRecipeUtil.findManager(isClient);
            }
            if (registryAccess == null || recipeManager == null) {
                Miapi.LOGGER.warn("Could not setup Smithing Materials, could not find Recipes");
                materials.forEach(register);
                return;
            }
            ArrayList<GeneratedMaterial> todo = new ArrayList<GeneratedMaterial>(materials);
            ArrayList done = new ArrayList();
            AtomicBoolean hasMadeProgress = new AtomicBoolean(false);
            do {
                hasMadeProgress.set(false);
                ArrayList<GeneratedMaterial> currentTodo = new ArrayList<GeneratedMaterial>(todo);
                for (GeneratedMaterial material : currentTodo) {
                    if (GeneratedMaterialManager.verboseLogging()) {
                        Miapi.LOGGER.info("testing material " + material.getStringID());
                    }
                    SmithingRecipeUtil.testForSmithingMaterial(recipeManager, registryAccess, material, smithing -> {
                        if (GeneratedMaterialManager.verboseLogging()) {
                            Miapi.LOGGER.info("registered smithing material " + smithing.getStringID());
                        }
                        todo.remove(smithing);
                        done.add(smithing);
                        register.accept((GeneratedMaterial)smithing);
                        hasMadeProgress.set(true);
                    }, normal -> {
                        if (GeneratedMaterialManager.verboseLogging()) {
                            Miapi.LOGGER.info("registered normal generated material " + normal.getStringID());
                        }
                        todo.remove(normal);
                        register.accept((GeneratedMaterial)normal);
                        hasMadeProgress.set(true);
                    });
                }
            } while (hasMadeProgress.get());
            todo.forEach(register);
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("Exception during SmithingRecipe setup!", (Throwable)e);
        }
    }

    public static boolean testForSmithingMaterial(class_1863 manager, class_5455 registryManager, GeneratedMaterial material, Consumer<GeneratedMaterial> smithingMaterial, Consumer<GeneratedMaterial> normal) {
        try {
            if (!GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.smithingOption, material.getID().toString())) {
                normal.accept(material);
                return false;
            }
            Optional<class_8060> optionalRecipe = manager.method_30027(class_3956.field_25388).stream().map(class_8786::comp_1933).filter(class_8060.class::isInstance).map(class_8060.class::cast).filter(recipe -> SmithingRecipeUtil.isValidRecipe(recipe, material.getSwordItem(), registryManager)).findAny();
            if (optionalRecipe.isEmpty()) {
                normal.accept(material);
            }
            optionalRecipe.ifPresent(smithingTransformRecipe -> {
                class_1799 templateItem = Arrays.stream(((SmithingTransformRecipeAccessor)smithingTransformRecipe).getTemplate().method_8105()).filter(itemStack -> !itemStack.method_7960()).findAny().orElse(class_1799.field_8037);
                if (templateItem.method_7960()) {
                    normal.accept(material);
                    return;
                }
                class_1799[] baseItems = ((SmithingTransformRecipeAccessor)smithingTransformRecipe).getBase().method_8105();
                if (baseItems.length > 1 && GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.allowMultiSmithing, material.getID().toString())) {
                    normal.accept(material);
                    return;
                }
                Optional<Material> optional = Arrays.stream(((SmithingTransformRecipeAccessor)smithingTransformRecipe).getBase().method_8105()).filter(itemStack -> {
                    class_1792 patt0$temp = itemStack.method_7909();
                    if (patt0$temp instanceof class_1831) {
                        class_1831 toolItem = (class_1831)patt0$temp;
                        Material parentMaterial = MaterialProperty.getMaterialFromIngredient(toolItem.method_8022().method_8023().method_8105()[0]);
                        return parentMaterial != null;
                    }
                    return false;
                }).map(itemStack -> MaterialProperty.getMaterialFromIngredient(((class_1831)itemStack.method_7909()).method_8022().method_8023().method_8105()[0])).findAny();
                optional.ifPresent(sourceMaterial -> {
                    smithingMaterial.accept(material);
                    SmithingRecipeUtil.addSmithingRecipe(sourceMaterial, material, templateItem, smithingTransformRecipe, registryManager, manager);
                });
            });
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("Error during Smithing recipe generation!", (Throwable)e);
        }
        return false;
    }

    static boolean isValidRecipe(class_8060 recipe, class_1829 swordItem, class_5455 manager) {
        if (recipe.method_8110((class_7225.class_7874)manager).method_7909().equals(swordItem)) {
            return true;
        }
        return ((SmithingTransformRecipeAccessor)recipe).getResult().method_7909().equals(swordItem);
    }

    public static class_1863 findManager(boolean isClient) {
        if (isClient) {
            class_1863 manager;
            if (class_310.method_1551().method_1562() != null && (manager = class_310.method_1551().method_1562().method_2877()) != null) {
                return manager;
            }
            if (Miapi.server != null) {
                return Miapi.server.method_3772();
            }
        } else {
            if (manager != null) {
                return manager;
            }
            if (Miapi.server != null) {
                return Miapi.server.method_3772();
            }
        }
        return manager;
    }

    public static void addSmithingRecipe(Material sourceMaterial, GeneratedMaterial outputMaterial, class_1799 templateItem, class_8060 smithingTransformRecipe, class_5455 registryAccess, class_1863 recipeManager) {
        ArrayList<class_8786> recipes = recipeManager.method_8126();
        Object id = "generated_material_recipe." + String.valueOf(outputMaterial.getID()) + "." + String.valueOf(sourceMaterial.getID()) + "." + String.valueOf(class_7923.field_41178.method_10221((Object)templateItem.method_7909()));
        class_2960 recipeId = Miapi.id((String)(id = ((String)id).replace(":", ".")));
        if (recipeManager.method_8130(recipeId).isEmpty()) {
            class_1856 template = ((SmithingTransformRecipeAccessor)smithingTransformRecipe).getTemplate();
            MaterialSmithingRecipe materialSmithingRecipe = new MaterialSmithingRecipe(template, sourceMaterial.getID(), ((SmithingTransformRecipeAccessor)smithingTransformRecipe).getAddition(), outputMaterial.getID());
            class_8786 materialSmithingRecipeRecipeHolder = new class_8786(recipeId, (class_1860)materialSmithingRecipe);
            recipes = new ArrayList<class_8786>(recipes);
            recipes.add(materialSmithingRecipeRecipeHolder);
            if (GeneratedMaterialManager.verboseLogging()) {
                Miapi.LOGGER.warn("added Smithing Recipe for " + String.valueOf(sourceMaterial.getID()) + " to " + String.valueOf(outputMaterial.key) + " via " + String.valueOf(class_7923.field_41178.method_10221((Object)templateItem.method_7909())));
            }
            outputMaterial.setSmithingMaterial(sourceMaterial.getID(), template);
            recipeManager.method_20702(recipes);
        }
    }
}

