/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.generated;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1810;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import smartin.miapi.loot.MaterialSwapLootFunction;
import smartin.miapi.material.generated.GeneratedMaterialManager;

public class TierManager {
    private static final Map<class_6862<class_2248>, List<class_1810>> TAG_LOOK_UP = new HashMap<class_6862<class_2248>, List<class_1810>>();

    public static void setup() {
        TAG_LOOK_UP.clear();
        List<class_1810> pickaxeItems = GeneratedMaterialManager.getRegistry().method_10220().filter(class_1810.class::isInstance).map(class_1810.class::cast).filter(p -> p.method_8022() != null && p.method_8022().method_58419() != null).toList();
        TAG_LOOK_UP.putAll(pickaxeItems.stream().collect(Collectors.groupingBy(p -> p.method_8022().method_58419())));
    }

    public static Optional<class_1810> getPreferredPickaxe(class_6862<class_2248> tag) {
        List<class_1810> candidates = TAG_LOOK_UP.get(tag);
        if (candidates == null || candidates.isEmpty()) {
            return Optional.empty();
        }
        return candidates.stream().sorted((a, b) -> {
            boolean aVanilla = TierManager.isMojangItem(a);
            boolean bVanilla = TierManager.isMojangItem(b);
            if (aVanilla && !bVanilla) {
                return -1;
            }
            if (!aVanilla && bVanilla) {
                return 1;
            }
            return a.method_7864(a.method_7854()).getString().compareToIgnoreCase(b.method_7864(b.method_7854()).getString());
        }).findFirst();
    }

    public static List<class_1810> getAllPickaxes(class_6862<class_2248> tag) {
        return TAG_LOOK_UP.getOrDefault(tag, List.of());
    }

    private static boolean isMojangItem(class_1810 item) {
        return item.arch$registryName() != null && "minecraft".equals(item.arch$registryName().method_12836());
    }

    public static int getEstimatedTier(class_6862<class_2248> incorrecTag) {
        int tier2Level = MaterialSwapLootFunction.getTagSize((class_6862<class_2248>)class_3481.field_49928);
        int tier3Level = MaterialSwapLootFunction.getTagSize((class_6862<class_2248>)class_3481.field_49927);
        int tier4Level = MaterialSwapLootFunction.getTagSize((class_6862<class_2248>)class_3481.field_49926);
        int tier5Level = MaterialSwapLootFunction.getTagSize((class_6862<class_2248>)class_3481.field_49925);
        int estimateTag = MaterialSwapLootFunction.getTagSize(incorrecTag);
        if (estimateTag < tier5Level) {
            int tierDiff = tier3Level - tier5Level;
            return 4 + estimateTag / tierDiff;
        }
        if (estimateTag < tier4Level) {
            return 4;
        }
        if (estimateTag < tier3Level) {
            return 3;
        }
        if (estimateTag < tier2Level) {
            return 2;
        }
        return 1;
    }
}

