/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.palette;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.misc.MiscCodecs;
import com.redpxnda.nucleus.util.Color;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5253;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7764;
import net.minecraft.class_7923;
import smartin.miapi.client.renderer.NativeImageGetter;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.MaterialRenderControllers;
import smartin.miapi.material.palette.SpriteFromJson;
import smartin.miapi.material.palette.SpritePixelReplacer;

@Environment(value=EnvType.CLIENT)
public class GrayscalePaletteColorer
extends SpritePixelReplacer {
    public static final Codec<Integer> stringToIntCodec = Codec.STRING.xmap(Integer::parseInt, String::valueOf);
    protected final int[] colors;
    protected final Color averageColor;

    public static GrayscalePaletteColorer createForImageJson(Material material, JsonElement json, boolean isItem) {
        if (isItem) {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)json.getAsJsonObject().get("item").getAsString()));
            return GrayscalePaletteColorer.createForGeneratedMaterial(material, item.method_7854());
        }
        return new GrayscalePaletteColorer(material, GrayscalePaletteColorer.createImagePalette(SpriteFromJson.getFromJson((JsonElement)json).imageSupplier.get()));
    }

    public static GrayscalePaletteColorer createForImageJson(Material material, JsonElement json) {
        Optional item;
        class_2960 id = class_2960.method_60654((String)json.getAsJsonObject().get("tag").getAsString());
        class_6862 tag = class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)id);
        Optional optinal = class_7923.field_41178.method_40266(tag);
        if (optinal.isPresent() && (item = ((class_6885.class_6888)optinal.get()).method_40239().findFirst()).isPresent()) {
            return GrayscalePaletteColorer.createForGeneratedMaterial(material, ((class_1792)((class_6880)item.get()).comp_349()).method_7854());
        }
        return new GrayscalePaletteColorer(material, GrayscalePaletteColorer.createImagePalette(SpriteFromJson.getFromJson((JsonElement)json).imageSupplier.get()));
    }

    public static GrayscalePaletteColorer createForGeneratedMaterial(Material material, class_1799 mainIngredient) {
        class_1087 itemModel = class_310.method_1551().method_1480().method_4019(mainIngredient, (class_1937)class_310.method_1551().field_1687, null, 0);
        class_7764 contents = itemModel.method_4711().method_45851();
        NativeImageGetter.ImageHolder image = NativeImageGetter.getFromContents(contents);
        return new GrayscalePaletteColorer(material, GrayscalePaletteColorer.createImagePalette(image));
    }

    public GrayscalePaletteColorer(Material material, Map<Integer, Color> colorsMap) {
        super(material);
        GrayscalePaletteColorer.interpolateColorsMap(colorsMap, MaterialRenderControllers.interpolateFiller);
        this.averageColor = GrayscalePaletteColorer.createAverageColor(colorsMap);
        this.colors = GrayscalePaletteColorer.createColorsArray(colorsMap);
    }

    public GrayscalePaletteColorer(Material material, JsonElement json) {
        super(material);
        JsonObject object;
        if (json instanceof JsonObject) {
            object = (JsonObject)json;
            if (!object.has("colors")) {
                throw new JsonParseException("ModularItem API failed to parse grayscale_map sampling palette for material '" + String.valueOf(material.getID()) + "'! Missing member 'colors'.");
            }
        } else {
            throw new JsonParseException("ModularItem API failed to parse grayscale_map sampling palette for material '" + String.valueOf(material.getID()) + "'! Not a JSON object -> " + String.valueOf(json));
        }
        JsonElement element = object.get("colors");
        HashMap<Integer, Color> colorsMap = new HashMap<Integer, Color>((Map)MiscCodecs.quickParse((JsonElement)element, (Codec)Codec.unboundedMap(stringToIntCodec, (Codec)MiscCodecs.COLOR), s -> new RuntimeException("Failed to create material palette color map from JSON '" + String.valueOf(element) + "'! -> " + s)));
        String key = object.has("filler") ? object.get("filler").getAsString() : "interpolate";
        MaterialRenderControllers.FillerFunction filler = MaterialRenderControllers.fillers.getOrDefault(key, MaterialRenderControllers.interpolateFiller);
        GrayscalePaletteColorer.interpolateColorsMap(colorsMap, filler);
        this.averageColor = GrayscalePaletteColorer.createAverageColor(colorsMap);
        this.colors = GrayscalePaletteColorer.createColorsArray(colorsMap);
    }

    public int[] getColors() {
        return this.colors;
    }

    @Override
    public int getReplacementColor(int pixelX, int pixelY, int previousAbgr) {
        int red = class_5253.class_8045.method_48345((int)previousAbgr);
        return this.colors[red];
    }

    @Override
    public Color getAverageColor() {
        return this.averageColor;
    }

    @Override
    public boolean doTick() {
        return false;
    }

    public static void interpolateColorsMap(Map<Integer, Color> colors, MaterialRenderControllers.FillerFunction filler) {
        colors.putIfAbsent(0, Color.BLACK);
        colors.putIfAbsent(255, Color.WHITE);
        MaterialRenderControllers.PixelPlacer placer = (color, x, y) -> colors.put(x, color);
        List list = colors.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList();
        for (int i = 0; i < list.size(); ++i) {
            Map.Entry<Integer, Color> last = i == 0 ? Map.entry(0, Color.BLACK) : list.get(i - 1);
            Map.Entry current = list.get(i);
            Map.Entry<Integer, Color> next = i == list.size() - 1 ? Map.entry(255, Color.WHITE) : list.get(i + 1);
            filler.fill(last.getValue(), (Color)current.getValue(), next.getValue(), last.getKey(), (Integer)current.getKey(), next.getKey(), placer);
            colors.put((Integer)current.getKey(), (Color)current.getValue());
        }
    }

    public static int[] createColorsArray(Map<Integer, Color> colors) {
        if (colors.size() != 256) {
            throw new IllegalArgumentException("There must be 256 colors! there are " + colors.size() + " colors!");
        }
        int[] array = new int[256];
        colors.forEach((pos, color) -> {
            array[pos.intValue()] = color.abgr();
        });
        return array;
    }

    public static Color createAverageColor(Map<Integer, Color> colors) {
        Color color = new Color();
        colors.forEach((pos, col) -> {
            color.x += col.x;
            color.y += col.y;
            color.z += col.z;
            color.w += col.w;
        });
        color.x /= colors.size();
        color.y /= colors.size();
        color.z /= colors.size();
        color.w /= colors.size();
        return color;
    }

    public static int[] createImagePixelArray(NativeImageGetter.ImageHolder image) {
        if (image.getFormat() != class_1011.class_1012.field_4997) {
            throw new UnsupportedOperationException("can only call makePixelArray for RGBA images.");
        }
        int[] is = new int[image.getWidth() * image.getHeight()];
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int k = image.getColor(j, i);
                is[j + i * image.getWidth()] = class_5253.class_5254.method_27764((int)class_5253.class_8045.method_48342((int)k), (int)class_5253.class_8045.method_48345((int)k), (int)class_5253.class_8045.method_48346((int)k), (int)class_5253.class_8045.method_48347((int)k));
            }
        }
        return is;
    }

    public static Map<Integer, Color> createImagePalette(NativeImageGetter.ImageHolder image) {
        List<Color> pixels = Arrays.stream(GrayscalePaletteColorer.createImagePixelArray(image)).mapToObj(Color::new).filter(color -> color.a() > 5).sorted(Comparator.comparingDouble(a -> a.toFloatVecNoDiv().length())).toList();
        LinkedHashMap<Integer, Color> finalColorMap = new LinkedHashMap<Integer, Color>();
        List uniqueColors = pixels.stream().distinct().toList();
        for (int i = 0; i < uniqueColors.size() - 1; ++i) {
            float scale = 256.0f / (float)pixels.size();
            Color current = (Color)uniqueColors.get(i);
            float distanceCurrent = Math.max(1, pixels.lastIndexOf(current) - pixels.indexOf(current));
            int medianScaled = (int)((float)pixels.indexOf(current) + distanceCurrent / 2.0f);
            finalColorMap.put((int)((float)medianScaled * scale), current);
            Color next = (Color)uniqueColors.get(i + 1);
            float distanceNext = Math.max(1, pixels.lastIndexOf(next) - pixels.indexOf(next));
            float weight = Math.min(1.0f, Math.max(0.0f, distanceCurrent / (distanceCurrent + distanceNext)));
            Color weightedAverage = new Color(current.redAsFloat() * weight + next.redAsFloat() * (1.0f - weight), current.greenAsFloat() * weight + next.greenAsFloat() * (1.0f - weight), current.blueAsFloat() * weight + next.blueAsFloat() * (1.0f - weight), current.alphaAsFloat() * weight + next.alphaAsFloat() * (1.0f - weight));
            float weightedPos = (float)pixels.lastIndexOf(current) + (float)(pixels.lastIndexOf(current) - pixels.indexOf(next)) * 0.5f;
            finalColorMap.put(Math.clamp((long)((int)(weightedPos * scale)), 0, 255), weightedAverage);
        }
        finalColorMap.putIfAbsent(0, Color.BLACK);
        if (uniqueColors.isEmpty()) {
            finalColorMap.putIfAbsent(255, Color.WHITE);
        } else {
            finalColorMap.putIfAbsent(255, (Color)uniqueColors.getLast());
        }
        return finalColorMap;
    }
}

