/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.palette;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.util.Color;
import com.redpxnda.nucleus.util.MiscUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5253;
import net.minecraft.class_7764;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.client.atlas.MaterialAtlasManager;
import smartin.miapi.client.atlas.MaterialSpriteManager;
import smartin.miapi.client.renderer.NativeImageGetter;
import smartin.miapi.material.palette.SpriteColorer;

@Environment(value=EnvType.CLIENT)
public class SpriteFromJson {
    public static final Map<String, class_2960> atlasIdShortcuts = (Map)MiscUtil.initialize(new HashMap(), m -> {
        m.put("block", class_1059.field_5275);
        m.put("particle", class_1059.field_17898);
        m.put("material", MaterialAtlasManager.MATERIAL_ATLAS_ID);
    });
    public Supplier<NativeImageGetter.ImageHolder> imageSupplier;
    public boolean isAnimated;
    @Nullable
    public class_1058 rawSprite = null;
    public static final Codec<SpriteFromJson> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("atlas").forGetter(sprite -> {
        for (Map.Entry<String, class_2960> entry : atlasIdShortcuts.entrySet()) {
            if (!entry.getValue().equals((Object)sprite.rawSprite.method_45852())) continue;
            return entry.getKey();
        }
        return sprite.rawSprite.method_45852().toString();
    }), (App)Codec.STRING.fieldOf("texture").forGetter(sprite -> sprite.rawSprite.method_45851().method_45816().toString()), (App)Codec.BOOL.optionalFieldOf("forceTick", (Object)false).forGetter(sprite -> sprite.isAnimated)).apply((Applicative)instance, SpriteFromJson::new));
    public static final MapCodec<SpriteFromJson> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("atlas").forGetter(sprite -> {
        for (Map.Entry<String, class_2960> entry : atlasIdShortcuts.entrySet()) {
            if (!entry.getValue().equals((Object)sprite.rawSprite.method_45852())) continue;
            return entry.getKey();
        }
        return sprite.rawSprite.method_45852().toString();
    }), (App)Codec.STRING.fieldOf("texture").forGetter(sprite -> sprite.rawSprite.method_45851().method_45816().toString()), (App)Codec.BOOL.optionalFieldOf("forceTick", (Object)false).forGetter(sprite -> sprite.isAnimated)).apply((Applicative)instance, SpriteFromJson::new));

    public static SpriteFromJson getFromJson(JsonElement element) {
        return (SpriteFromJson)((Pair)MAP_CODEC.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow()).getFirst();
    }

    public SpriteFromJson(String atlasKey, String texturePath, boolean forceTick) {
        class_2960 atlasId = atlasIdShortcuts.getOrDefault(atlasKey, class_2960.method_60654((String)atlasKey));
        class_2960 textureId = class_2960.method_60654((String)texturePath);
        class_1059 atlasSprite = class_310.method_1551().method_1554().method_24153(atlasId);
        if (atlasSprite == null) {
            throw new RuntimeException("could not find atlas" + atlasKey);
        }
        this.rawSprite = atlasSprite.method_4608(textureId);
        if (atlasSprite == null) {
            throw new RuntimeException("could not find atlas image" + String.valueOf(textureId) + " on atlas " + atlasKey);
        }
        class_7764 contents = this.rawSprite.method_45851();
        this.imageSupplier = () -> NativeImageGetter.get(contents);
        this.isAnimated = forceTick || SpriteColorer.isAnimatedSpriteStatic(contents);
    }

    public static class_1011 loadTexture(class_3300 resourceManager, class_2960 id) {
        try {
            class_1011 nativeImage;
            class_3298 resource = resourceManager.getResourceOrThrow(id);
            try (InputStream inputStream = resource.method_14482();){
                nativeImage = class_1011.method_4309((InputStream)inputStream);
            }
            return nativeImage;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to fetch texture '" + String.valueOf(id) + "' for json sprite data!", ex);
        }
    }

    public void markUse() {
        if (this.isAnimated() && this.rawSprite != null) {
            MaterialSpriteManager.markTextureAsAnimatedInUse(this.rawSprite);
        }
    }

    boolean isAnimated() {
        return this.isAnimated;
    }

    public NativeImageGetter.ImageHolder getNativeImage() {
        return this.imageSupplier.get();
    }

    public Color getAverageColor() {
        int red = 0;
        int green = 0;
        int blue = 0;
        int count = 0;
        NativeImageGetter.ImageHolder img = this.getNativeImage();
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                int color = img.getColor(x, y);
                red += class_5253.class_8045.method_48345((int)color);
                green += class_5253.class_8045.method_48346((int)color);
                blue += class_5253.class_8045.method_48347((int)color);
                ++count;
            }
        }
        return new Color(red / count, green / count, blue / count, 255);
    }
}

