/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.handler.codec.DecoderException;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2960;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.PropertyHolder;
import smartin.miapi.modules.properties.tag.ModuleTagProperty;
import smartin.miapi.registries.RegistryInventory;

public record ItemModuleExtension(PropertyHolder holder, List<ItemModule> modules) {
    public static ItemModuleExtension loadModuleExtension(class_2960 path, JsonElement data, boolean isClient) {
        try {
            JsonObject moduleJson = data.getAsJsonObject();
            PropertyHolder holder = (PropertyHolder)((Pair)PropertyHolder.MAP_CODEC.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)moduleJson).getOrThrow(s -> new DecoderException("Failed to decode ItemModule Extension " + String.valueOf(path) + " " + s))).getFirst();
            if (moduleJson.has("tag")) {
                String tag = moduleJson.get("tag").getAsString();
                List<ItemModule> toChange = ModuleTagProperty.getModulesWithTag(tag);
                return new ItemModuleExtension(holder, toChange);
            }
            if (moduleJson.has("id")) {
                class_2960 id = Miapi.id(moduleJson.get("id").getAsString());
                ItemModule module = RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.get(id);
                if (module == null) {
                    throw new DecoderException("module not found for id " + String.valueOf(id) + " by module extension " + String.valueOf(path));
                }
                return new ItemModuleExtension(holder, List.of(module));
            }
            throw new DecoderException("module extension " + String.valueOf(path) + " did not include a id or tag.");
        }
        catch (Exception e) {
            throw new DecoderException("Could not load Module to extend " + String.valueOf(path), (Throwable)e);
        }
    }

    public void apply() {
        for (ItemModule module : this.modules) {
            RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.remove(module.id());
            RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.register(module.id(), new ItemModule(module.id(), this.holder.applyHolder(module.properties(), Optional.empty())));
        }
    }
}

