/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import org.slf4j.Logger;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.mixin.RegistryOpsAccessor;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;

public class ModuleInstanceCodec
implements Codec<ModuleInstance> {
    private final Codec<Map<class_2960, JsonElement>> dataJsonCodec = Codec.unboundedMap(Miapi.ID_CODEC, StatResolver.Codecs.JSONELEMENT_CODEC);
    private final Codec<Map<String, ModuleInstance>> subModulesCodec = Codec.unboundedMap((Codec)Codec.STRING, (Codec)this);

    public <T> DataResult<Pair<ModuleInstance, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getMap(input).flatMap(map -> {
            DataResult keyResult = Miapi.ID_CODEC.parse(ops, map.get("key"));
            Object childData = map.get("child");
            DataResult childResult = childData != null ? this.subModulesCodec.parse(ops, childData) : DataResult.success(new HashMap());
            Object data = map.get("data");
            DataResult dataResult = data != null ? this.dataJsonCodec.parse(ops, data) : DataResult.success(new HashMap());
            return keyResult.flatMap(key -> childResult.flatMap(children -> dataResult.map(subData -> {
                ModuleInstance inst = new ModuleInstance((class_2960)key, (Map<String, ModuleInstance>)children, (Map<class_2960, JsonElement>)subData);
                return Pair.of((Object)inst, (Object)input);
            })));
        });
    }

    public <T> DataResult<T> encode(ModuleInstance input, DynamicOps<T> ops, T prefix) {
        LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
        Object keyElement = Miapi.ID_CODEC.encodeStart(ops, (Object)input.moduleID).resultOrPartial(arg_0 -> ((Logger)Miapi.LOGGER).warn(arg_0)).orElse(null);
        if (keyElement != null) {
            values.put(ops.createString("key"), keyElement);
        }
        if (!input.subModules.isEmpty()) {
            Object childElement = this.subModulesCodec.encodeStart(ops, input.getSubModuleMapForSave()).resultOrPartial(arg_0 -> ((Logger)Miapi.LOGGER).warn(arg_0)).orElse(null);
            if (childElement != null) {
                values.put(ops.createString("child"), childElement);
            }
        }
        if (!input.moduleData.isEmpty()) {
            Object dataElement = this.dataJsonCodec.encodeStart(ops, input.getSaveData()).resultOrPartial(arg_0 -> ((Logger)Miapi.LOGGER).warn(arg_0)).orElse(null);
            if (dataElement != null) {
                values.put(ops.createString("data"), dataElement);
            }
        }
        return DataResult.success((Object)ops.createMap(values));
    }

    public static void performanceTest(class_1799 ammo) {
        long totalModularCheckTime = 0L;
        long totalEncodeTime = 0L;
        long totalDecodeTime = 0L;
        ammo = ammo.method_7972();
        ammo.method_57381(ModuleInstance.MODULE_BACKUP);
        for (int i = 0; i < 10000; ++i) {
            long start = System.nanoTime();
            boolean isModular = ModularItem.isModularItem(ammo);
            long end = System.nanoTime();
            totalModularCheckTime += end - start;
            start = System.nanoTime();
            JsonElement encoded = (JsonElement)class_1799.field_24671.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ammo).getOrThrow();
            end = System.nanoTime();
            totalEncodeTime += end - start;
            start = System.nanoTime();
            class_1799 dec = (class_1799)((Pair)class_1799.field_24671.decode((DynamicOps)JsonOps.INSTANCE, (Object)encoded).getOrThrow()).getFirst();
            end = System.nanoTime();
            totalDecodeTime += end - start;
        }
        Miapi.LOGGER.warn("Modular check time (ms): " + (double)totalModularCheckTime / 1000000.0);
        Miapi.LOGGER.warn("Encoding time (ms): " + (double)totalEncodeTime / 1000000.0);
        Miapi.LOGGER.warn("Decoding time (ms): " + (double)totalDecodeTime / 1000000.0);
    }

    public static Codec<ModuleInstance> createWrappedCodec() {
        ModuleInstanceCodec base = new ModuleInstanceCodec();
        return ModuleInstanceCodec.registrySavingCodec(base, (m, l) -> {
            ModuleInstanceCodec.setupModule(m, l);
            ComponentApplyProperty.trySetup(m);
        });
    }

    private static void setupModule(ModuleInstance moduleInstance, class_6903.class_7863 lookup) {
        moduleInstance.lookup = lookup;
        moduleInstance.mutable = false;
        moduleInstance.getSubModuleMapForSave().values().forEach(m -> ModuleInstanceCodec.setupModule(m, lookup));
    }

    public static <T> Codec<T> registrySavingCodec(final Codec<T> baseCodec, final BiConsumer<T, class_6903.class_7863> applyLookup) {
        return new Codec<T>(){

            public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
                DataResult basicResult = baseCodec.decode(ops, input);
                if (ops instanceof class_6903) {
                    class_6903 registryOps = (class_6903)ops;
                    if (basicResult.isSuccess()) {
                        applyLookup.accept(((Pair)basicResult.getOrThrow()).getFirst(), ((RegistryOpsAccessor)registryOps).getLookupProvider());
                    }
                }
                return basicResult;
            }

            public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
                return baseCodec.encode(input, ops, prefix);
            }
        };
    }
}

