/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import com.redpxnda.nucleus.pose.server.ServerPoseFacet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeType;

public class CommandExecuteAbility
implements ItemUseDefaultCooldownAbility<CommandExecuteJson>,
ItemUseMinHoldAbility<CommandExecuteJson> {
    public static String KEY = "command";
    public static Codec<CommandExecuteJson> CODEC = AutoCodec.of(CommandExecuteJson.class).codec();

    @Override
    public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, ItemAbilityManager.AbilityHitContext abilityHitContext, CommandExecuteJson context) {
        return true;
    }

    @Override
    public class_1839 getUseAction(class_1799 itemStack, CommandExecuteJson context) {
        return context.userAnim;
    }

    @Override
    public int getMaxUseTime(class_1799 itemStack, class_1309 entity, CommandExecuteJson context) {
        return 72000;
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand, CommandExecuteJson context) {
        class_3222 serverPlayer;
        ServerPoseFacet facet;
        if (user.method_7357().method_7904(user.method_5998(hand).method_7909())) {
            return class_1271.method_22430((Object)user.method_5998(hand));
        }
        user.method_6019(hand);
        if (context.startPose != null && user instanceof class_3222 && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)(serverPlayer = (class_3222)user))) != null) {
            facet.set(context.startPose, serverPlayer, hand);
        }
        return class_1271.method_22428((Object)user.method_5998(hand));
    }

    @Override
    public Codec<CommandExecuteJson> getCodec() {
        return CODEC;
    }

    @Override
    public void onStoppedUsingAfter(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks, CommandExecuteJson context) {
        class_2168 source;
        Object serverPlayer;
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)user;
        int heldTicks = this.getMaxUseTime(stack, user, context) - remainingUseTicks;
        if ((double)heldTicks < context.minHold.getValue()) {
            this.resetAnimation(user);
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (context.asPlayer && player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            source = serverPlayer.method_5671();
        } else {
            source = serverWorld.method_8503().method_3739();
        }
        if (context.atPlayer) {
            source = source.method_9208(player.method_19538()).method_9232((class_1297)player);
        }
        for (String cmd : context.command) {
            serverWorld.method_8503().method_3734().method_44252(source, cmd);
        }
        if (context.executePose != null && player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            ServerPoseFacet facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)serverPlayer);
            if (facet != null) {
                facet.set(context.executePose, (class_3222)serverPlayer, player.method_6058());
            }
        } else {
            this.resetAnimation(user);
        }
        player.method_7357().method_7906(stack.method_7909(), (int)context.cooldown.getValue());
        player.method_6104(player.method_6058());
    }

    private void resetAnimation(class_1309 entity) {
        class_3222 player;
        ServerPoseFacet facet;
        if (entity instanceof class_3222 && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)(player = (class_3222)entity))) != null) {
            facet.reset(player);
        }
    }

    @Override
    public int getCooldown(class_1799 itemStack) {
        return (int)((CommandExecuteJson)this.getSpecialContext((class_1799)itemStack)).cooldown.getValue();
    }

    @Override
    public CommandExecuteJson getDefaultContext() {
        return null;
    }

    @Override
    public CommandExecuteJson initialize(CommandExecuteJson json, ModuleInstance moduleInstance) {
        return json.initialize(moduleInstance);
    }

    @Override
    public int getMinHoldTime(class_1799 itemStack) {
        return (int)((CommandExecuteJson)this.getSpecialContext((class_1799)itemStack)).minHold.getValue();
    }

    @Override
    public CommandExecuteJson merge(CommandExecuteJson left, CommandExecuteJson right, MergeType mergeType) {
        CommandExecuteJson merged = new CommandExecuteJson();
        merged.command = new ArrayList<String>(left.command);
        if (MergeType.OVERWRITE.equals((Object)mergeType)) {
            merged.command = right.command;
        } else {
            merged.command.addAll(right.command);
        }
        merged.asPlayer = mergeType.equals((Object)MergeType.OVERWRITE) ? right.asPlayer : left.asPlayer;
        merged.atPlayer = mergeType.equals((Object)MergeType.OVERWRITE) ? right.atPlayer : left.atPlayer;
        merged.minHold = left.minHold.merge(right.minHold, mergeType);
        merged.cooldown = left.cooldown.merge(right.cooldown, mergeType);
        merged.userAnim = right.userAnim != null ? right.userAnim : left.userAnim;
        merged.startPose = right.startPose != null ? right.startPose : left.startPose;
        merged.executePose = right.executePose != null ? right.executePose : left.executePose;
        return merged;
    }

    public static class CommandExecuteJson {
        public List<String> command = new ArrayList<String>();
        @CodecBehavior.Optional
        public boolean asPlayer = false;
        @CodecBehavior.Optional
        public boolean atPlayer = true;
        @AutoCodec.Name(value="min_hold")
        @CodecBehavior.Optional
        public DoubleOperationResolvable minHold = new DoubleOperationResolvable(0.0);
        @CodecBehavior.Optional
        public DoubleOperationResolvable cooldown = new DoubleOperationResolvable(20.0);
        @CodecBehavior.Optional
        public class_1839 userAnim = class_1839.field_8952;
        @CodecBehavior.Optional
        public String startPose;
        @CodecBehavior.Optional
        public String executePose;

        public CommandExecuteJson initialize(ModuleInstance moduleInstance) {
            CommandExecuteJson json = new CommandExecuteJson();
            json.command = this.command;
            json.asPlayer = this.asPlayer;
            json.atPlayer = this.atPlayer;
            json.minHold = this.minHold.initialize(moduleInstance);
            json.cooldown = this.cooldown.initialize(moduleInstance);
            json.userAnim = this.userAnim;
            return json;
        }
    }
}

