/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_9278;
import net.minecraft.class_9334;
import smartin.miapi.MixinContextFlags;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.item.modular.items.bows.ModularCrossbow;
import smartin.miapi.modules.abilities.CopyItemAbility;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseAbility;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.projectile.DrawTimeProperty;

public class CrossbowAbility
implements ItemUseAbility<Context> {
    public static final Codec<Context> CODEC = Codec.BOOL.optionalFieldOf("dummy", (Object)false).xmap(Context::new, Context::dummy).codec();

    @Override
    public Codec<Context> getCodec() {
        return CODEC;
    }

    @Override
    public boolean allowedOnItem(class_1799 stack, class_1937 world, class_1657 player, class_1268 hand, ItemAbilityManager.AbilityHitContext abilityHitContext, Context context) {
        return true;
    }

    @Override
    public class_1839 getUseAction(class_1799 stack, Context context) {
        return class_1839.field_8947;
    }

    @Override
    public int getMaxUseTime(class_1799 stack, class_1309 entity, Context context) {
        return CrossbowAbility.getChargeDuration(stack, entity);
    }

    @Override
    public class_1271<class_1799> use(class_1937 level, class_1657 player, class_1268 hand, Context context) {
        class_1799 crossbow = player.method_5998(hand);
        class_9278 charged = (class_9278)crossbow.method_57824(class_9334.field_49649);
        if (charged != null && !charged.method_57442()) {
            float divergence = (float)Math.pow(12.0, -AttributeUtil.getActualValue(crossbow, class_1304.field_6173, (class_1320)AttributeRegistry.PROJECTILE_ACCURACY.comp_349()));
            float speed = (float)Math.max(0.1, AttributeUtil.getActualValue(crossbow, class_1304.field_6173, (class_1320)AttributeRegistry.PROJECTILE_SPEED.comp_349()) + (double)CrossbowAbility.getShootingPower(charged));
            if (((MiapiProjectileEvents.CrossbowContext)MiapiProjectileEvents.MODULAR_CROSSBOW_PRE_SHOT.invoker()).shoot((class_1309)player, crossbow).interruptsFurtherEvaluation()) {
                return class_1271.method_22428((Object)crossbow);
            }
            player.method_6075();
            if (((MiapiProjectileEvents.CrossbowContext)MiapiProjectileEvents.MODULAR_CROSSBOW_POST_SHOT.invoker()).shoot((class_1309)player, crossbow).interruptsFurtherEvaluation()) {
                return class_1271.method_22428((Object)crossbow);
            }
            return class_1271.method_22428((Object)crossbow);
        }
        if (!player.method_18808(crossbow).method_7960()) {
            player.method_6019(hand);
            return class_1271.method_22428((Object)crossbow);
        }
        return class_1271.method_22431((Object)crossbow);
    }

    @Override
    public void onStoppedUsing(class_1799 stack, class_1937 level, class_1309 user, int remainingUseTicks, Context context) {
        int ticks = this.getMaxUseTime(stack, user, context) - remainingUseTicks;
        float charge = CrossbowAbility.getPowerForTime(ticks, stack, user);
        MiapiProjectileEvents.CrossbowLoadingContext ctx = new MiapiProjectileEvents.CrossbowLoadingContext(user, stack, user.method_18808(stack), class_1304.field_6173);
        if (charge >= 1.0f && !class_1764.method_7781((class_1799)stack) && !((MiapiProjectileEvents.CrossbowContextEvent)MiapiProjectileEvents.MODULAR_CROSSBOW_PRE_LOAD.invoker()).load(ctx).interruptsFurtherEvaluation() && CrossbowAbility.tryLoadProjectiles(user, stack) && ((MiapiProjectileEvents.CrossbowContextEvent)MiapiProjectileEvents.MODULAR_CROSSBOW_POST_LOAD.invoker()).load(ctx).interruptsFurtherEvaluation()) {
            return;
        }
    }

    private static boolean tryLoadProjectiles(class_1309 shooter, class_1799 crossbowStack) {
        List<class_1799> list = ModularCrossbow.drawPublic(crossbowStack, shooter.method_18808(crossbowStack), shooter);
        if (!list.isEmpty()) {
            crossbowStack.method_57379(class_9334.field_49649, (Object)class_9278.method_57441(list));
            return true;
        }
        return false;
    }

    private static float getPowerForTime(int timeLeft, class_1799 stack, class_1309 shooter) {
        float f = (float)timeLeft / (float)CrossbowAbility.getChargeDuration(stack, shooter);
        return Math.min(f, 1.0f);
    }

    private static int getChargeDuration(class_1799 stack, class_1309 shooter) {
        double drawTime = DrawTimeProperty.property.getValue(stack).orElse(0.25);
        float f = class_1890.method_60159((class_1799)stack, (class_1309)shooter, (float)((float)drawTime));
        return (int)(f * 20.0f);
    }

    private static float getShootingPower(class_9278 projectile) {
        return projectile.method_57438(class_1802.field_8639) ? 1.6f : 3.15f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T withFlag(class_1799 stack, CopyItemAbility.ItemContext item, Supplier<T> action) {
        if (item == null) {
            return null;
        }
        try {
            if (item.fakeItemIdentity) {
                MixinContextFlags.IGNORE_NEXT_GET_ITEM_CALL.get().put(stack, item.item);
            }
            T t = action.get();
            return t;
        }
        finally {
            if (item.fakeItemIdentity) {
                MixinContextFlags.IGNORE_NEXT_GET_ITEM_CALL.get().remove(stack);
            }
        }
    }

    public record Context(boolean dummy) {
    }
}

