/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeType;

public class RiptideAbility
implements ItemUseDefaultCooldownAbility<RiptideContextJson>,
ItemUseMinHoldAbility<RiptideContextJson> {
    public static Codec<RiptideContextJson> CODEC = AutoCodec.of(RiptideContextJson.class).codec();
    public static String KEY = "riptide";

    @Override
    public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, ItemAbilityManager.AbilityHitContext abilityHitContext, RiptideContextJson context) {
        return class_1890.method_60123((class_1799)itemStack, (class_1309)player) != 0.0f;
    }

    @Override
    public class_1839 getUseAction(class_1799 itemStack, RiptideContextJson context) {
        return class_1839.field_8951;
    }

    @Override
    public int getMaxUseTime(class_1799 itemStack, class_1309 entity, RiptideContextJson context) {
        return 7200;
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand, RiptideContextJson context) {
        class_3218 serverLevel;
        class_1799 itemStack = user.method_5998(hand);
        if (itemStack.method_7919() >= itemStack.method_7936() - 1) {
            return class_1271.method_22431((Object)itemStack);
        }
        if (world instanceof class_3218 && class_1890.method_60169((class_3218)(serverLevel = (class_3218)world), (class_1799)itemStack, (class_1297)user) > 0 && !user.method_5721()) {
            return class_1271.method_22431((Object)itemStack);
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)itemStack);
    }

    @Override
    public Codec<RiptideContextJson> getCodec() {
        return CODEC;
    }

    @Override
    public void onStoppedUsingAfter(class_1799 stack, class_1937 level, class_1309 livingEntity, int timeCharged, RiptideContextJson context) {
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            int var6 = this.getMaxUseTime(stack, livingEntity, context) - timeCharged;
            if (var6 >= 10) {
                float f = class_1890.method_60123((class_1799)stack, (class_1309)player);
                if (player.method_5721() && !RiptideAbility.isTooDamagedToUse(stack)) {
                    class_6880 holder = class_1890.method_60165((class_1799)stack, (class_9331)class_9701.field_51654).orElse(class_3417.field_15001);
                    player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                    if (f > 0.0f) {
                        float g = player.method_36454();
                        float h = player.method_36455();
                        float j = -class_3532.method_15374((float)(g * ((float)Math.PI / 180))) * class_3532.method_15362((float)(h * ((float)Math.PI / 180)));
                        float k = -class_3532.method_15374((float)(h * ((float)Math.PI / 180)));
                        float l = class_3532.method_15362((float)(g * ((float)Math.PI / 180))) * class_3532.method_15362((float)(h * ((float)Math.PI / 180)));
                        float m = class_3532.method_15355((float)(j * j + k * k + l * l));
                        player.method_5762((double)(j *= f / m), (double)(k *= f / m), (double)(l *= f / m));
                        player.method_40126(20, 8.0f, stack);
                        if (player.method_24828()) {
                            float n = 1.1999999f;
                            player.method_5784(class_1313.field_6308, new class_243(0.0, 1.1999999284744263, 0.0));
                        }
                        level.method_43129((class_1657)null, (class_1297)player, (class_3414)holder.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    private static boolean isTooDamagedToUse(class_1799 stack) {
        return stack.method_7919() >= stack.method_7936() - 1;
    }

    @Override
    public RiptideContextJson getDefaultContext() {
        return null;
    }

    @Override
    public int getMinHoldTime(class_1799 itemStack) {
        return (int)((RiptideContextJson)this.getSpecialContext((class_1799)itemStack)).minUse.getValue();
    }

    @Override
    public int getCooldown(class_1799 itemStack) {
        return (int)((RiptideContextJson)this.getSpecialContext((class_1799)itemStack)).cooldown.getValue();
    }

    @Override
    public RiptideContextJson initialize(RiptideContextJson json, ModuleInstance moduleInstance) {
        return json.initialize(moduleInstance);
    }

    @Override
    public RiptideContextJson merge(RiptideContextJson left, RiptideContextJson right, MergeType mergeType) {
        RiptideContextJson merged = new RiptideContextJson();
        merged.cooldown = left.cooldown.merge(right.cooldown, mergeType);
        merged.minUse = left.minUse.merge(right.minUse, mergeType);
        merged.spinDuration = left.spinDuration.merge(right.spinDuration, mergeType);
        merged.riptideStrength = left.riptideStrength.merge(right.riptideStrength, mergeType);
        merged.customSound = MergeType.EXTEND.equals((Object)mergeType) && left.customSound != null ? left.customSound : right.customSound;
        return merged;
    }

    public static class RiptideContextJson {
        @CodecBehavior.Optional
        public DoubleOperationResolvable cooldown = new DoubleOperationResolvable(20.0);
        @AutoCodec.Name(value="min_use")
        @CodecBehavior.Optional
        public DoubleOperationResolvable minUse = new DoubleOperationResolvable(10.0);
        @AutoCodec.Name(value="spin_duration_base")
        @CodecBehavior.Optional
        public DoubleOperationResolvable spinDuration = new DoubleOperationResolvable(20.0);
        @AutoCodec.Name(value="riptide_strength")
        @CodecBehavior.Optional
        public DoubleOperationResolvable riptideStrength = new DoubleOperationResolvable(20.0);
        @CodecBehavior.Optional
        @AutoCodec.Name(value="custom_sound")
        public class_2960 customSound = null;

        public RiptideContextJson initialize(ModuleInstance moduleInstance) {
            RiptideContextJson init = new RiptideContextJson();
            init.cooldown = this.cooldown.initialize(moduleInstance);
            init.minUse = this.minUse.initialize(moduleInstance);
            init.spinDuration = this.spinDuration.initialize(moduleInstance);
            init.riptideStrength = this.riptideStrength.initialize(moduleInstance);
            init.customSound = this.customSound;
            return init;
        }

        public class_3414 resolveSoundEvent(int riptideLevel) {
            if (this.customSound != null && class_7923.field_41172.method_10250(this.customSound)) {
                return (class_3414)class_7923.field_41172.method_10223(this.customSound);
            }
            if (riptideLevel >= 3) {
                return (class_3414)class_3417.field_14717.comp_349();
            }
            if (riptideLevel == 2) {
                return (class_3414)class_3417.field_14806.comp_349();
            }
            return (class_3414)class_3417.field_14606.comp_349();
        }
    }
}

