/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5250;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.AbilityProperty;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeType;

public class ThrowingAbility
implements ItemUseDefaultCooldownAbility<BasicContext>,
ItemUseMinHoldAbility<BasicContext> {
    public static Codec<BasicContext> CODEC = AutoCodec.of(BasicContext.class).codec();

    public ThrowingAbility() {
        LoreProperty.bottomLoreSuppliers.add(itemStack -> {
            ArrayList<class_5250> texts = new ArrayList<class_5250>();
            if (AbilityProperty.isPrimaryAbility(this, itemStack)) {
                texts.add(class_2561.method_43471((String)"miapi.ability.throw.lore"));
            }
            return texts;
        });
    }

    @Override
    public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, ItemAbilityManager.AbilityHitContext abilityHitContext, BasicContext context) {
        return true;
    }

    @Override
    public class_1839 getUseAction(class_1799 itemStack, BasicContext context) {
        return class_1839.field_8951;
    }

    @Override
    public int getMaxUseTime(class_1799 stack, class_1309 entity, BasicContext context) {
        return 72000;
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand, BasicContext context) {
        user.method_6019(hand);
        return class_1271.method_22428((Object)user.method_5998(hand));
    }

    @Override
    public Codec<BasicContext> getCodec() {
        return CODEC;
    }

    @Override
    public void onStoppedUsingAfter(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks, BasicContext context) {
        if (user instanceof class_1657) {
            class_1657 playerEntity = (class_1657)user;
            int i = this.getMaxUseTime(stack, user, context) - remainingUseTicks;
            if (i >= 10) {
                playerEntity.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    class_1304 equipmentSlot = this.getEquipmentSlot(user.method_6058());
                    stack.method_7970(1, (class_1309)playerEntity, equipmentSlot);
                    ItemProjectileEntity projectileEntity = new ItemProjectileEntity(world, (class_1309)playerEntity, stack, stack);
                    float divergence = (float)AttributeUtil.getActualValue(stack, class_1304.field_6173, (class_1320)AttributeRegistry.PROJECTILE_ACCURACY.comp_349());
                    float speed = (float)AttributeUtil.getActualValue(stack, class_1304.field_6173, (class_1320)AttributeRegistry.PROJECTILE_SPEED.comp_349());
                    float damage = (float)AttributeUtil.getActualValue(stack, class_1304.field_6173, (class_1320)AttributeRegistry.PROJECTILE_DAMAGE.comp_349());
                    damage /= speed;
                    if (ModularItem.isModularItem(stack)) {
                        speed = 0.5f;
                    }
                    projectileEntity.method_24919((class_1297)playerEntity, playerEntity.method_36455(), playerEntity.method_36454(), 0.0f, speed, divergence);
                    projectileEntity.method_7438(damage);
                    projectileEntity.setSpeedDamage(true);
                    if (user.method_6058() == class_1268.field_5810) {
                        projectileEntity.setPreferredSlot(-2);
                    } else {
                        projectileEntity.setPreferredSlot(playerEntity.method_31548().field_7545);
                    }
                    projectileEntity.thrownStack = stack;
                    world.method_8649((class_1297)projectileEntity);
                    world.method_43129(null, (class_1297)user, (class_3414)class_3417.field_15001.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
                    if (playerEntity.method_31549().field_7477) {
                        projectileEntity.field_7572 = class_1665.class_1666.field_7594;
                    } else {
                        user.method_6122(user.method_6058(), class_1799.field_8037);
                    }
                }
            }
        }
    }

    @Override
    public BasicContext initialize(BasicContext data, ModuleInstance moduleInstance) {
        data.cooldown.initialize(moduleInstance);
        data.minUseTime.initialize(moduleInstance);
        return data;
    }

    @Override
    public int getCooldown(class_1799 itemstack) {
        return (int)((BasicContext)this.getSpecialContext((class_1799)itemstack)).cooldown.getValue();
    }

    @Override
    public int getMinHoldTime(class_1799 itemStack) {
        return (int)((BasicContext)this.getSpecialContext((class_1799)itemStack)).minUseTime.getValue();
    }

    @Override
    public BasicContext getDefaultContext() {
        return null;
    }

    @Override
    public BasicContext merge(BasicContext right, BasicContext left, MergeType mergeType) {
        BasicContext context = new BasicContext();
        context.minUseTime = left.minUseTime.merge(right.minUseTime, mergeType);
        context.cooldown = left.cooldown.merge(right.cooldown, mergeType);
        return context;
    }

    public static class BasicContext {
        @AutoCodec.Name(value="min_hold_time")
        @CodecBehavior.Optional
        public DoubleOperationResolvable minUseTime = new DoubleOperationResolvable(0.0);
        @CodecBehavior.Optional
        public DoubleOperationResolvable cooldown = new DoubleOperationResolvable(0.0);
    }
}

