/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.shield;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.MapCodec;
import com.redpxnda.nucleus.pose.server.ServerPoseFacet;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import smartin.miapi.Miapi;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.shield.BlockDataOld;
import smartin.miapi.modules.abilities.util.AbilityProperty;
import smartin.miapi.modules.abilities.util.EntityAttributeAbility;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.MinMaxCDAbility;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.registries.RegistryInventory;

public class BlockAbility
extends EntityAttributeAbility<BlockDataOld> {
    class_2960 id = Miapi.id("block_ability_temporary_attribute");

    public BlockAbility() {
        LoreProperty.bottomLoreSuppliers.add(itemStack -> {
            ArrayList<class_5250> texts = new ArrayList<class_5250>();
            if (AbilityProperty.isPrimaryAbility(this, itemStack)) {
                class_5250 raw = class_2561.method_43471((String)"miapi.ability.block.lore");
                texts.add(raw);
            }
            return texts;
        });
        MiapiEvents.LIVING_HURT.register(event -> {
            class_1309 patt0$temp = event.defender;
            if (!(patt0$temp instanceof class_1657)) {
                return EventResult.pass();
            }
            class_1657 player = (class_1657)patt0$temp;
            class_1799 stack = player.method_6030();
            if (stack == null || stack.method_7960()) {
                return EventResult.pass();
            }
            ModuleInstance moduleInstance = ItemModule.getModules(stack);
            BlockDataOld data = this.getData(stack).orElse(null);
            if (data == null || moduleInstance == null) {
                return EventResult.pass();
            }
            player.method_7357().method_7906(stack.method_7909(), this.getCooldown(stack));
            class_1297 patt1$temp = event.damageSource.method_5529();
            if (patt1$temp instanceof class_1309) {
                class_1309 attacker = (class_1309)patt1$temp;
                int attackerCD = (int)data.cooldownAttackerWeapon.getValue();
                if (attacker instanceof class_1657) {
                    class_1657 p = (class_1657)attacker;
                    class_1799 attackStack = p.method_6047();
                    if (!attackStack.method_7960()) {
                        p.method_7357().method_7906(attackStack.method_7909(), attackerCD);
                    }
                } else {
                    attacker.method_6092(new class_1293(RegistryInventory.stunEffect, attackerCD));
                }
                float returnPercent = (float)data.damageReturnPercent.getValue() / 100.0f;
                float reflected = event.amount * returnPercent;
                attacker.method_5643(player.method_48923().method_48802(player), reflected);
            }
            if (data.sound != null) {
                class_6880 holder = class_6880.method_40223((Object)class_3414.method_47908((class_2960)data.sound));
                player.method_5783((class_3414)holder.comp_349(), (float)data.volume.getValue(), (float)data.pitch.getValue());
            }
            return EventResult.pass();
        });
    }

    @Override
    protected Multimap<class_6880<class_1320>, class_1322> getAttributes(class_1799 itemStack) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        double value = this.getData(itemStack).map(c -> c.blocking.getValue()).orElse(1.0);
        value = BlockAbility.calculate(value);
        multimap.put((Object)class_5134.field_23719, (Object)new class_1322(this.id, -(value / 2.0) / 100.0, class_1322.class_1323.field_6331));
        multimap.put(AttributeRegistry.DAMAGE_RESISTANCE, (Object)new class_1322(this.id, value, class_1322.class_1323.field_6328));
        return multimap;
    }

    public static double calculate(double value) {
        return 160.0 / (1.0 + Math.exp(-value / 50.0)) - 80.0;
    }

    @Override
    public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, ItemAbilityManager.AbilityHitContext abilityHitContext, MinMaxCDAbility.MinMaxCDData<BlockDataOld> context) {
        return true;
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand, MinMaxCDAbility.MinMaxCDData<BlockDataOld> context) {
        this.setAnimation(user, hand);
        return super.use(world, user, hand, context);
    }

    @Override
    public class_1799 finishUsing(class_1799 stack, class_1937 world, class_1309 user, MinMaxCDAbility.MinMaxCDData<BlockDataOld> context) {
        this.resetAnimation(user);
        return super.finishUsing(stack, world, user, context);
    }

    @Override
    public void onStoppedUsingAfter(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks, MinMaxCDAbility.MinMaxCDData<BlockDataOld> context) {
        this.resetAnimation(user);
        super.onStoppedUsingAfter(stack, world, user, remainingUseTicks, context);
    }

    @Override
    public void onStoppedHolding(class_1799 stack, class_1937 world, class_1309 user, MinMaxCDAbility.MinMaxCDData<BlockDataOld> context) {
        this.resetAnimation(user);
        super.onStoppedHolding(stack, world, user, context);
    }

    public void setAnimation(class_1657 p, class_1268 hand) {
        class_3222 player;
        ServerPoseFacet facet;
        if (p instanceof class_3222 && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)(player = (class_3222)p))) != null) {
            facet.set("miapi:block", player, hand);
        }
    }

    public void resetAnimation(class_1309 entity) {
        class_3222 player;
        ServerPoseFacet facet;
        if (entity instanceof class_3222 && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)(player = (class_3222)entity))) != null) {
            facet.reset(player);
        }
    }

    @Override
    protected MapCodec<BlockDataOld> getMapCodec() {
        return BlockDataOld.CODEC;
    }

    @Override
    protected BlockDataOld mergeData(BlockDataOld left, BlockDataOld right, MergeType mergeType) {
        return left.merge(left, right, mergeType);
    }

    @Override
    public BlockDataOld initializeData(BlockDataOld data, ModuleInstance moduleInstance) {
        return data.initialize(data, moduleInstance);
    }
}

