/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.shield;

import com.mojang.serialization.MapCodec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.pose.server.ServerPoseFacet;
import dev.architectury.event.EventResult;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.apache.commons.lang3.mutable.MutableInt;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.client.gui.crafting.statdisplay.DoubleResolvableStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.events.ClientEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.mixin.CooldownInstanceAccessor;
import smartin.miapi.mixin.ItemCooldownsAccessor;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.shield.BlockData;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.MinMaxCDAbility;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.registries.RegistryInventory;

public class ParryBlock
extends MinMaxCDAbility<BlockData> {
    public static final String KEY = "parry_block";
    public static final MapCodec<BlockData> CODEC = AutoCodec.of(BlockData.class);

    public ParryBlock() {
        super(0, 7200, 30);
        MiapiEvents.GET_ITEM_SHIELD_COOLDOWN.register((Object)new MiapiEvents.CooldownAttackingWeaponGatherEvent(this){

            @Override
            public void durability(MutableInt cooldown, class_1799 attacking, class_1799 shield, class_1309 defender, class_1297 attacker) {
                if (ModularItem.isModularItem(attacking) && attacker instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)attacker;
                    double value = livingEntity.method_45325(AttributeRegistry.SHIELD_BREAK);
                    cooldown.setValue((Number)(value * 20.0));
                }
                if (cooldown.getValue() == 0 && attacking.method_7909() instanceof class_1743) {
                    cooldown.setValue(100);
                }
            }
        }, -1.0f);
        MiapiEvents.LIVING_HURT.register(event -> {
            class_3414 soundEvent;
            class_243 toAttacker;
            class_1309 patt0$temp = event.defender;
            if (!(patt0$temp instanceof class_1657)) {
                return EventResult.pass();
            }
            class_1657 player = (class_1657)patt0$temp;
            class_1799 stack = player.method_6030();
            if (stack == null || stack.method_7960()) {
                return EventResult.pass();
            }
            ModuleInstance moduleInstance = ItemModule.getModules(stack);
            BlockData data = this.getData(stack).orElse(null);
            if (data == null || moduleInstance == null || event.attacker == null) {
                return EventResult.pass();
            }
            double allowedAngle = data.angle().getValue();
            class_243 playerLook = player.method_5720().method_1029();
            double angle = Math.toDegrees(Math.acos(playerLook.method_1026(toAttacker = event.attacker.method_19538().method_1020(player.method_19538()).method_1029())));
            if (angle <= allowedAngle && (angle = Math.toDegrees(Math.acos(playerLook.method_1026(toAttacker = event.attacker.method_33571().method_1020(player.method_19538()).method_1029())))) <= allowedAngle) {
                return EventResult.interruptTrue();
            }
            class_1297 patt1$temp = event.damageSource.method_5529();
            if (patt1$temp instanceof class_1309) {
                class_1309 attacker = (class_1309)patt1$temp;
                int attackerCD = (int)data.cooldownAttackerWeapon().getValue();
                if (attacker instanceof class_1657) {
                    class_1657 p = (class_1657)attacker;
                    class_1799 attackStack = p.method_6047();
                    if (!attackStack.method_7960()) {
                        this.addCooldown(p, attackStack, attackerCD);
                    }
                } else if (attackerCD > 10) {
                    attacker.method_6092(new class_1293(RegistryInventory.stunEffect, attackerCD));
                }
                float returnPercent = (float)data.damageReturnPercent().getValue() / 100.0f;
                if (returnPercent > 1.0f) {
                    float reflected = event.amount * returnPercent;
                    attacker.method_5643(player.method_48923().method_48802(player), reflected);
                }
            }
            if (data.sound() != null && (soundEvent = (class_3414)class_7923.field_41172.method_10223(data.sound())) != null && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_37908().method_8396(player, player.method_23312(), soundEvent, class_3419.field_15248, (float)data.volume().getValue(), (float)data.pitch().getValue());
            }
            double blocking = data.blocking().getValue();
            int cooldown = this.getCooldown(stack);
            if (data.respectAttackingWeaponCooldown().getValue() > 0.0) {
                MutableInt base = new MutableInt(0);
                ((MiapiEvents.CooldownAttackingWeaponGatherEvent)MiapiEvents.GET_ITEM_SHIELD_COOLDOWN.invoker()).durability(base, event.getMainCausingStack(), stack, event.defender, event.attacker);
                cooldown += base.getValue().intValue();
            }
            if (blocking >= 100.0) {
                this.addCooldown(player, stack, cooldown);
                return EventResult.interruptDefault();
            }
            if (blocking > 0.0) {
                float blockPercent = (float)blocking / 100.0f;
                event.amount = Math.max(0.0f, event.amount - blockPercent * event.amount);
                this.addCooldown(player, stack, cooldown);
                return EventResult.pass();
            }
            return EventResult.pass();
        });
        if (Platform.getEnvironment() == Env.CLIENT) {
            ClientEvents.STAT_WIDGET_REGISTRATION.register(this::registerStatDisplays);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void registerStatDisplays() {
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((BlockData)((MinMaxCDAbility.MinMaxCDData)a.context()).data()).blocking())).setName((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.block")).setHoverDescription((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.block.description")).build());
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((MinMaxCDAbility.MinMaxCDData)a.context()).max())).setName((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.max_use")).setHoverDescription((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.max_use.description")).build());
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((MinMaxCDAbility.MinMaxCDData)a.context()).min())).setName((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.min_use")).setHoverDescription((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.min_use.description")).build());
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((BlockData)((MinMaxCDAbility.MinMaxCDData)a.context()).data()).respectAttackingWeaponCooldown())).setName((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.respect_attacker_weapon_cd")).setHoverDescription((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.respect_attacker_weapon_cd")).build());
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((BlockData)((MinMaxCDAbility.MinMaxCDData)a.context()).data()).angle())).setName((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.angle")).setHoverDescription((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.angle")).build());
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((BlockData)((MinMaxCDAbility.MinMaxCDData)a.context()).data()).cooldownAttackerWeapon())).setName((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.cooldown_attacker_weapon")).setHoverDescription((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.cooldown_attacker_weapon.description")).build());
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((BlockData)((MinMaxCDAbility.MinMaxCDData)a.context()).data()).damageReturnPercent())).setName((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.damage_return_percent")).setHoverDescription((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.damage_return_percent.description")).build());
        StatListWidget.addStatDisplay(DoubleResolvableStatDisplay.builder(s -> ItemAbilityManager.getAbilities(s).stream().filter(a -> a.ability() instanceof ParryBlock).findAny().map(a -> ((BlockData)((MinMaxCDAbility.MinMaxCDData)a.context()).data()).cooldownMissTime())).setName((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.cooldown_miss_time")).setHoverDescription((class_2561)class_2561.method_43471((String)"miapi.stat.miapi.ability.blocking.cooldown_miss_time.description")).build());
    }

    public void addCooldown(class_1657 player, class_1799 stack, int cooldown) {
        if (cooldown > 0) {
            int currentCD;
            Map<class_1792, class_1796.class_1797> cd = ((ItemCooldownsAccessor)player.method_7357()).getCooldowns();
            if (cd.containsKey(stack.method_7909()) && (currentCD = ((CooldownInstanceAccessor)cd.get(stack.method_7909())).getEndTime() - ((ItemCooldownsAccessor)player.method_7357()).getTickCount()) > cooldown) {
                return;
            }
            player.method_7357().method_7906(stack.method_7909(), cooldown);
            player.method_6021();
            player.method_7357().method_7906(stack.method_7909(), cooldown);
        }
    }

    @Override
    protected MapCodec<BlockData> getMapCodec() {
        return BlockData.CODEC;
    }

    @Override
    protected BlockData mergeData(BlockData left, BlockData right, MergeType mergeType) {
        return left.merge(left, right, mergeType);
    }

    @Override
    public BlockData initializeData(BlockData data, ModuleInstance moduleInstance) {
        return data.initialize(data, moduleInstance);
    }

    @Override
    public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, ItemAbilityManager.AbilityHitContext abilityHitContext, MinMaxCDAbility.MinMaxCDData<BlockData> context) {
        return true;
    }

    @Override
    public class_1839 getUseAction(class_1799 itemStack, MinMaxCDAbility.MinMaxCDData<BlockData> context) {
        BlockData data;
        if (this.getData(itemStack).isPresent() && (data = (BlockData)this.getData(itemStack).get()).pose().isEmpty()) {
            return class_1839.field_8949;
        }
        return class_1839.field_8952;
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand, MinMaxCDAbility.MinMaxCDData<BlockData> context) {
        if (!world.field_9236 && user instanceof class_3222) {
            BlockData data;
            class_3222 serverPlayer = (class_3222)user;
            ModuleInstance moduleInstance = ItemModule.getModules(user.method_5998(hand));
            if (moduleInstance != null && (data = (BlockData)this.getData(user.method_5998(hand)).orElse(null)) != null && data.pose() != null && data.pose().isPresent()) {
                this.setAnimation((class_1657)serverPlayer, data.pose().get(), hand);
            }
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)user.method_5998(hand));
    }

    @Override
    public class_1799 finishUsing(class_1799 stack, class_1937 world, class_1309 user, MinMaxCDAbility.MinMaxCDData<BlockData> context) {
        this.resetAnimation(user);
        this.applyCooldownMissTime(stack, user);
        return super.finishUsing(stack, world, user, context);
    }

    @Override
    public void onStoppedUsingAfter(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks, MinMaxCDAbility.MinMaxCDData<BlockData> context) {
        this.resetAnimation(user);
        super.onStoppedUsingAfter(stack, world, user, remainingUseTicks, context);
        this.applyCooldownMissTime(stack, user);
    }

    @Override
    public void onStoppedHolding(class_1799 stack, class_1937 world, class_1309 user, MinMaxCDAbility.MinMaxCDData<BlockData> context) {
        this.resetAnimation(user);
        super.onStoppedHolding(stack, world, user, context);
        this.applyCooldownMissTime(stack, user);
    }

    public void applyCooldownMissTime(class_1799 itemStack, class_1309 livingEntity) {
        BlockData data = this.getData(itemStack).orElse(null);
        if (livingEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)livingEntity;
            if (data != null) {
                this.addCooldown((class_1657)serverPlayer, itemStack, (int)data.cooldownMissTime().getValue());
            }
        }
    }

    public void setAnimation(class_1657 p, class_2960 id, class_1268 hand) {
        class_3222 player;
        ServerPoseFacet facet;
        if (p instanceof class_3222 && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)(player = (class_3222)p))) != null) {
            facet.set(id.toString(), player, hand);
        }
    }

    public void resetAnimation(class_1309 entity) {
        class_3222 player;
        ServerPoseFacet facet;
        if (entity instanceof class_3222 && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)(player = (class_3222)entity))) != null) {
            facet.reset(player);
        }
    }
}

