/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemUseAbility;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.registries.RegistryInventory;

@Deprecated
public class AbilityMangerProperty
extends CodecProperty<Map<ItemUseAbility<?>, Object>> {
    public static String KEY = "ability_context_old";
    public static AbilityMangerProperty property;
    public static Codec<Map<ItemUseAbility<?>, Object>> CODEC;

    public AbilityMangerProperty() {
        super(CODEC);
        property = this;
    }

    public static boolean isPrimaryAbility(ItemUseAbility<?> itemUseAbility, class_1799 itemStack) {
        if (VisualModularItem.isVisualModularItem(itemStack) && !ModularItem.isModularItem(itemStack)) {
            return false;
        }
        LinkedHashMap map = property.getData(itemStack).orElse(new LinkedHashMap());
        if (!map.sequencedEntrySet().isEmpty()) {
            return itemUseAbility == ((Map.Entry)map.sequencedEntrySet().getFirst()).getKey();
        }
        return false;
    }

    @Override
    public Map<ItemUseAbility<?>, Object> merge(Map<ItemUseAbility<?>, Object> left, Map<ItemUseAbility<?>, Object> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType, (key, leftAbility, rightAbility) -> this.mergeValues((ItemUseAbility)key, leftAbility, rightAbility, mergeType));
    }

    @Override
    public Map<ItemUseAbility<?>, Object> initialize(Map<ItemUseAbility<?>, Object> property, ModuleInstance context) {
        LinkedHashMap initialized = new LinkedHashMap();
        property.forEach((itemUseAbility, o) -> initialized.put((ItemUseAbility<?>)itemUseAbility, this.initialize((ItemUseAbility)itemUseAbility, o, context)));
        return initialized;
    }

    private <T> T initialize(ItemUseAbility<T> itemUseAbility, Object value, ModuleInstance moduleInstance) {
        return (T)itemUseAbility.initialize(value, moduleInstance);
    }

    private <T> T mergeValues(ItemUseAbility<T> itemUseAbility, Object leftValue, Object rightValue, MergeType mergeType) {
        return (T)itemUseAbility.merge(leftValue, rightValue, mergeType);
    }

    static {
        CODEC = new Codec<Map<ItemUseAbility<?>, Object>>(){

            public <T> DataResult<T> encode(Map<ItemUseAbility<?>, Object> input, DynamicOps<T> ops, T prefix) {
                LinkedHashMap encodedMap = new LinkedHashMap();
                RecordBuilder map = ops.mapBuilder();
                for (Map.Entry<ItemUseAbility<?>, Object> entry : input.entrySet()) {
                    ItemUseAbility<?> ability = entry.getKey();
                    Object data = entry.getValue();
                    String abilityId = RegistryInventory.ITEM_USE_ABILITY_MIAPI_REGISTRY.findKey(ability).toString();
                    if (abilityId == null) {
                        Miapi.LOGGER.error("Failed to encode ItemUseAbility: Ability not found in registry.");
                        continue;
                    }
                    DataResult keyResult = Codec.STRING.encode((Object)abilityId, ops, ops.empty());
                    if (keyResult.error().isPresent()) {
                        Miapi.LOGGER.error("Failed to encode ItemUseAbility key: " + ((DataResult.Error)keyResult.error().get()).message());
                        continue;
                    }
                    if (keyResult.result().isEmpty()) {
                        Miapi.LOGGER.error("Failed to encode ItemUseAbility key: " + abilityId);
                        continue;
                    }
                    DataResult valueResult = DataResult.success(ability.encodeObject(ops, data));
                    if (valueResult.error().isPresent()) {
                        Miapi.LOGGER.error("Failed to encode data for ability: " + abilityId + " - " + ((DataResult.Error)valueResult.error().get()).message());
                        continue;
                    }
                    encodedMap.put(keyResult.result().get(), valueResult.result().get());
                    map.add(keyResult.result().get(), valueResult.result().get());
                }
                return map.build(prefix);
            }

            public <T> DataResult<Pair<Map<ItemUseAbility<?>, Object>, T>> decode(DynamicOps<T> ops, T input) {
                LinkedHashMap abilityMap = new LinkedHashMap();
                ((MapLike)ops.getMap(input).getOrThrow()).entries();
                ((Stream)ops.getMapValues(input).getOrThrow()).toList().forEach(pair -> {
                    String resourceLocation = (String)((Pair)Codec.STRING.decode(ops, pair.getFirst()).getOrThrow()).getFirst();
                    ItemUseAbility itemUseAbility = RegistryInventory.ITEM_USE_ABILITY_MIAPI_REGISTRY.get(resourceLocation);
                    if (itemUseAbility == null) {
                        Miapi.LOGGER.error("can not find ItemUseAbility " + resourceLocation);
                    } else {
                        Object data = itemUseAbility.decode(ops, pair.getSecond());
                        abilityMap.put(itemUseAbility, data);
                    }
                });
                return DataResult.success((Object)new Pair(abilityMap, input));
            }
        };
    }
}

