/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.modules.abilities.key.KeyBindAbilityManagerProperty;
import smartin.miapi.modules.abilities.key.KeyBindFacet;
import smartin.miapi.modules.abilities.util.AbilityHolder;
import smartin.miapi.modules.abilities.util.AbilityMangerProperty;
import smartin.miapi.modules.abilities.util.AbilityProperty;
import smartin.miapi.modules.abilities.util.ItemUseAbility;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.registries.MiapiRegistry;
import smartin.miapi.registries.RegistryInventory;

public class ItemAbilityManager {
    private static final Map<class_1657, class_1799> playerActiveItems = new WeakHashMap<class_1657, class_1799>();
    private static final Map<class_1657, class_1799> playerActiveItemsClient = new WeakHashMap<class_1657, class_1799>();
    public static final MiapiRegistry<ItemUseAbility> useAbilityRegistry = MiapiRegistry.getInstance(ItemUseAbility.class);
    private static final AbilityHolder<?> emptyAbility = new AbilityHolder<Object>(new EmptyAbility(), new Object());
    private static final Map<class_1799, AbilityHolder<?>> abilityMap = Collections.synchronizedMap(new WeakHashMap());
    public static final Map<class_1657, class_2960> clientKeyBindID = new WeakHashMap<class_1657, class_2960>();
    public static final Map<class_1657, class_2960> serverKeyBindID = new WeakHashMap<class_1657, class_2960>();

    public static void setup() {
        TickEvent.PLAYER_PRE.register(playerEntity -> {
            Map<class_1657, class_1799> activeItems = playerActiveItems;
            if (playerEntity.method_37908().field_9236) {
                activeItems = playerActiveItemsClient;
            }
            class_1799 oldItem = activeItems.get(playerEntity);
            class_1799 playerItem = playerEntity.method_6030();
            if (playerItem != null && !playerItem.equals(oldItem)) {
                activeItems.put((class_1657)playerEntity, playerItem);
                if (oldItem != null) {
                    AbilityHolder<?> holder = ItemAbilityManager.getAbility(oldItem);
                    holder.onStoppedHolding(oldItem, playerEntity.method_37908(), (class_1309)playerEntity);
                    ItemAbilityManager.clearAbility(oldItem);
                }
            }
        });
        useAbilityRegistry.addCallback(ability -> ModularItemCache.setSupplier(AbilityMangerProperty.KEY + "_" + String.valueOf(RegistryInventory.ITEM_USE_ABILITY_MIAPI_REGISTRY.findKey((ItemUseAbility)ability)), itemStack -> {
            AbilityHolder<?> optional = abilityMap.get(itemStack);
            if (optional != null && optional.ability().equals(ability)) {
                return optional.context();
            }
            return null;
        }));
        useAbilityRegistry.register(Miapi.id("empty"), emptyAbility.ability());
    }

    public static AbilityHolder<?> getEmpty() {
        return emptyAbility;
    }

    private static AbilityHolder<?> getAbility(class_1799 itemStack) {
        AbilityHolder<?> useAbility = abilityMap.get(itemStack);
        return useAbility == null ? emptyAbility : useAbility;
    }

    public static List<AbilityHolder<?>> getAbilities(class_1799 itemStack) {
        ArrayList result = new ArrayList();
        AbilityProperty.property.getData(itemStack).ifPresent(list -> list.forEach(context -> result.add(context.ability.getAsHolder(context.data))));
        Map keyboundAbilities = KeyBindAbilityManagerProperty.property.getData(itemStack).orElse(new HashMap());
        for (List list2 : keyboundAbilities.values()) {
            list2.forEach(context -> result.add(context.ability.getAsHolder(context.data)));
        }
        return result;
    }

    private static AbilityHolder<?> getAbility(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, AbilityHitContext abilityHitContext) {
        class_2960 keybindID = null;
        keybindID = player.method_37908().field_9236 ? clientKeyBindID.get(player) : serverKeyBindID.get(player);
        if (keybindID == null) {
            AbilityHolder abilityHolder = AbilityProperty.property.getData(itemStack).flatMap(list -> list.stream().filter(abilityContext -> {
                if (abilityHitContext.hitEntity() != null && abilityContext.allowedOnEntity.isTrue()) {
                    return true;
                }
                if (abilityContext.allowedOnBlock.isTrue() && abilityHitContext.hitEntity() == null && abilityHitContext.hitResult() != null && abilityHitContext.hitResult().method_8037() != null) {
                    return true;
                }
                return abilityContext.allowedOnAir.isTrue() && abilityHitContext.hitEntity() == null && abilityHitContext.hitResult() == null;
            }).map(abilityContext -> abilityContext.ability.getAsHolder(abilityContext.data)).filter(ability -> ability.allowedOnItem(itemStack, world, player, hand, abilityHitContext)).findFirst()).orElse(null);
            if (abilityHolder != null) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    KeyBindFacet.get(serverPlayer).reset(serverPlayer);
                }
                ItemAbilityManager.setCurrentAbility(itemStack, abilityHolder);
                return abilityHolder;
            }
        } else {
            Map map = KeyBindAbilityManagerProperty.property.getData(itemStack).orElse(new LinkedHashMap());
            AbilityHolder abilityHolder = Optional.ofNullable((List)map.get(keybindID)).flatMap(list -> list.stream().filter(abilityContext -> {
                if (abilityHitContext.hitEntity() != null && abilityContext.allowedOnEntity.isTrue()) {
                    return true;
                }
                if (abilityContext.allowedOnBlock.isTrue() && abilityHitContext.hitEntity() == null && abilityHitContext.hitResult() != null && abilityHitContext.hitResult().method_8037() != null) {
                    return true;
                }
                return abilityContext.allowedOnAir.isTrue() && abilityHitContext.hitEntity() == null && abilityHitContext.hitResult() == null;
            }).map(abilityContext -> abilityContext.ability.getAsHolder(abilityContext.data)).filter(ability -> ability.allowedOnItem(itemStack, world, player, hand, abilityHitContext)).findFirst()).orElse(null);
            if (abilityHolder != null) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    KeyBindFacet.get(serverPlayer).reset(serverPlayer);
                }
                ItemAbilityManager.setCurrentAbility(itemStack, abilityHolder);
                return abilityHolder;
            }
        }
        ItemAbilityManager.clearAbility(itemStack);
        return emptyAbility;
    }

    @Nullable
    private static AbilityHolder<?> setCurrentAbility(class_1799 itemStack, AbilityHolder<?> abilityHolder) {
        ModularItemCache.clear(itemStack, AbilityMangerProperty.KEY + "_" + String.valueOf(RegistryInventory.ITEM_USE_ABILITY_MIAPI_REGISTRY.findKey(abilityHolder.ability())));
        return abilityMap.put(itemStack, abilityHolder);
    }

    private static AbilityHolder<?> clearAbility(class_1799 oldItem) {
        AbilityHolder<?> abilityHolder = abilityMap.remove(oldItem);
        if (abilityHolder != null) {
            ModularItemCache.clear(oldItem, AbilityMangerProperty.KEY + "_" + String.valueOf(RegistryInventory.ITEM_USE_ABILITY_MIAPI_REGISTRY.findKey(abilityHolder.ability())));
        }
        return abilityHolder;
    }

    public static class_1839 getUseAction(class_1799 itemStack, Supplier<class_1839> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(itemStack);
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        return ability.getUseAction(itemStack);
    }

    public static int getMaxUseTime(class_1799 itemStack, class_1309 livingEntity, Supplier<Integer> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(itemStack);
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        return ability.getMaxUseTime(itemStack, livingEntity);
    }

    public static class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand, Supplier<class_1271<class_1799>> getItem) {
        class_1799 itemStack = user.method_5998(hand);
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(itemStack, world, user, hand, new AbilityHitContext(){

            @Override
            @Nullable
            public class_1838 hitResult() {
                return null;
            }

            @Override
            @Nullable
            public class_1297 hitEntity() {
                return null;
            }
        });
        ItemAbilityManager.setCurrentAbility(itemStack, ability);
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        return ability.use(world, user, hand);
    }

    public static class_1799 finishUsing(class_1799 stack, class_1937 world, class_1309 user, Supplier<class_1799> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            ItemAbilityManager.clearAbility(stack);
            return getItem.get();
        }
        class_1799 itemStack = ability.finishUsing(stack, world, user);
        ItemAbilityManager.clearAbility(stack);
        return itemStack;
    }

    public static void onStoppedUsing(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks, Runnable getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            getItem.run();
            return;
        }
        ability.onStoppedUsing(stack, world, user, remainingUseTicks);
        ItemUseAbility<?> itemUseAbility = ability.ability();
        if (itemUseAbility instanceof ItemUseDefaultCooldownAbility) {
            ItemUseDefaultCooldownAbility itemUseDefaultCooldownAbility = (ItemUseDefaultCooldownAbility)itemUseAbility;
            itemUseDefaultCooldownAbility.afterStopAbility(stack, world, user, remainingUseTicks);
        }
        ItemAbilityManager.clearAbility(stack);
    }

    public static void usageTick(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks, Runnable getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            ItemAbilityManager.clearAbility(stack);
            getItem.run();
            return;
        }
        ability.usageTick(world, user, stack, remainingUseTicks);
    }

    public static boolean useOnRelease(class_1799 stack, Supplier<Boolean> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack);
        if (emptyAbility.equals(ability)) {
            ItemAbilityManager.clearAbility(stack);
            return getItem.get();
        }
        return ability.useOnRelease(stack);
    }

    public static class_1269 useOnEntity(class_1799 stack, class_1657 user, final class_1309 entity, class_1268 hand, Supplier<class_1269> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(stack, user.method_37908(), user, hand, new AbilityHitContext(){

            @Override
            @Nullable
            public class_1838 hitResult() {
                return null;
            }

            @Override
            @Nullable
            public class_1297 hitEntity() {
                return entity;
            }
        });
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        ItemAbilityManager.setCurrentAbility(stack, ability);
        return ItemAbilityManager.getAbility(stack).useOnEntity(stack, user, entity, hand);
    }

    public static class_1269 useOnBlock(final class_1838 context, Supplier<class_1269> getItem) {
        AbilityHolder<?> ability = ItemAbilityManager.getAbility(context.method_8041(), context.method_8045(), context.method_8036(), context.method_20287(), new AbilityHitContext(){

            @Override
            @Nullable
            public class_1838 hitResult() {
                return context;
            }

            @Override
            @Nullable
            public class_1297 hitEntity() {
                return null;
            }
        });
        if (emptyAbility.equals(ability)) {
            return getItem.get();
        }
        ItemAbilityManager.setCurrentAbility(context.method_8041(), ability);
        if (Platform.isForgeLike()) {
            class_1269 result = ItemAbilityManager.getAbility(context.method_8041()).useOnBlock(context);
            if (result.equals((Object)class_1269.field_5811)) {
                return getItem.get();
            }
            return result;
        }
        AbilityHolder<?> executing = ItemAbilityManager.getAbility(context.method_8041());
        return executing.useOnBlock(context);
    }

    public static interface AbilityHitContext {
        @Nullable
        public class_1838 hitResult();

        @Nullable
        public class_1297 hitEntity();
    }

    static class EmptyAbility
    implements ItemUseAbility {
        EmptyAbility() {
        }

        public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, AbilityHitContext abilityHitContext, Object context) {
            return true;
        }

        public class_1839 getUseAction(class_1799 itemStack, Object context) {
            return class_1839.field_8952;
        }

        public int getMaxUseTime(class_1799 itemStack, class_1309 entity, Object context) {
            return 0;
        }

        public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand, Object context) {
            return class_1271.method_22430((Object)user.method_5998(hand));
        }

        public Codec getCodec() {
            return AutoCodec.of(EmptyAbility.class).codec();
        }
    }
}

