/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemUseAbility;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeType;

public abstract class MinMaxCDAbility<T>
implements ItemUseMinHoldAbility<MinMaxCDData<T>>,
ItemUseDefaultCooldownAbility<MinMaxCDData<T>>,
ItemUseAbility<MinMaxCDData<T>> {
    public int defaultMinHoldTime;
    public int defaultMaxHoldTime;
    public int defaultCoolDown;

    protected MinMaxCDAbility(int defaultMin, int defaultCoolDown) {
        this(defaultMin, 72000, defaultCoolDown);
    }

    protected MinMaxCDAbility(int defaultMin, int defaultMax, int defaultCoolDown) {
        this.defaultMinHoldTime = defaultMin;
        this.defaultCoolDown = defaultCoolDown;
        this.defaultMaxHoldTime = defaultMax;
    }

    private Optional<MinMaxCDData<T>> getContext(class_1799 stack) {
        return Optional.ofNullable((MinMaxCDData)this.getSpecialContext(stack));
    }

    @Override
    public int getMinHoldTime(class_1799 itemStack) {
        return this.getContext(itemStack).map(a -> a.min().evaluate(0.0, this.defaultMinHoldTime)).orElse(Double.valueOf(this.defaultMinHoldTime)).intValue();
    }

    @Override
    public int getCooldown(class_1799 itemStack) {
        return this.getContext(itemStack).map(a -> a.cooldown().evaluate(0.0, this.defaultCoolDown)).orElse(Double.valueOf(this.defaultCoolDown)).intValue();
    }

    @Override
    public int getMaxUseTime(class_1799 itemStack, class_1309 livingEntity, MinMaxCDData<T> context) {
        return this.getContext(itemStack).map(a -> a.max().evaluate(0.0, this.defaultMaxHoldTime)).orElse(Double.valueOf(this.defaultMaxHoldTime)).intValue();
    }

    @Override
    public MinMaxCDData<T> merge(MinMaxCDData<T> left, MinMaxCDData<T> right, MergeType mergeType) {
        return new MinMaxCDData<T>(this.mergeData(left.data(), right.data(), mergeType), DoubleOperationResolvable.merge(left.min(), left.min(), mergeType), DoubleOperationResolvable.merge(left.max(), left.max(), mergeType), DoubleOperationResolvable.merge(left.cooldown(), left.cooldown(), mergeType));
    }

    @Override
    public MinMaxCDData<T> initialize(MinMaxCDData<T> property, ModuleInstance context) {
        return new MinMaxCDData<T>(this.initializeData(property.data(), context), property.min().initialize(context), property.max().initialize(context), property.cooldown().initialize(context));
    }

    protected abstract T mergeData(T var1, T var2, MergeType var3);

    protected abstract T initializeData(T var1, ModuleInstance var2);

    protected abstract MapCodec<T> getMapCodec();

    public Optional<T> getData(class_1799 itemStack) {
        return this.getContext(itemStack).map(c -> c.data);
    }

    @Override
    public Codec<MinMaxCDData<T>> getCodec() {
        MapCodec<T> dataCodec = this.getMapCodec();
        return RecordCodecBuilder.create(instance -> instance.group((App)dataCodec.forGetter(MinMaxCDData::data), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("min_hold", (Object)new DoubleOperationResolvable(this.defaultMinHoldTime)).forGetter(MinMaxCDData::min), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("max_hold", (Object)new DoubleOperationResolvable(this.defaultMaxHoldTime)).forGetter(MinMaxCDData::max), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("cooldown", (Object)new DoubleOperationResolvable(this.defaultCoolDown)).forGetter(MinMaxCDData::cooldown)).apply((Applicative)instance, MinMaxCDData::new));
    }

    public record MinMaxCDData<T>(T data, DoubleOperationResolvable min, DoubleOperationResolvable max, DoubleOperationResolvable cooldown) {
    }
}

