/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.action;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.action.ActionContext;
import smartin.miapi.modules.action.ActionEffect;
import smartin.miapi.modules.action.ActionPredicate;

public record Action(List<ActionPredicate> predicates, List<ActionEffect> effects) {
    public static Map<class_2960, MapCodec<? extends ActionEffect>> ACTION_EFFECT_REGISTRY = new ConcurrentHashMap<class_2960, MapCodec<? extends ActionEffect>>();
    public static Codec<ActionEffect> ACTION_CODEC = class_2960.field_25139.dispatch("type", ActionEffect::getType, id -> ACTION_EFFECT_REGISTRY.get(id));
    public static Map<class_2960, MapCodec<? extends ActionPredicate>> ACTION_PREDICATE_REGISTRY = new ConcurrentHashMap<class_2960, MapCodec<? extends ActionPredicate>>();
    public static Codec<ActionPredicate> ACTION_PREDICATE = class_2960.field_25139.dispatch("type", ActionPredicate::getType, id -> ACTION_PREDICATE_REGISTRY.get(id));

    public Action initialize(ModuleInstance moduleInstance) {
        return new Action(this.predicates().stream().map(a -> a.initialize(moduleInstance)).toList(), this.effects().stream().map(a -> a.initialize(moduleInstance)).toList());
    }

    public void execute(ActionContext context) {
        boolean progressMade;
        ArrayList<ActionEffect> pendingEffects = new ArrayList<ActionEffect>(this.effects);
        pendingEffects.addAll(this.predicates());
        do {
            progressMade = false;
            ArrayList<ActionPredicate> resolvedEffects = new ArrayList<ActionPredicate>();
            for (ActionPredicate actionPredicate : pendingEffects) {
                boolean dependenciesResolved = actionPredicate.dependencyMet(context);
                if (!dependenciesResolved) continue;
                if (!actionPredicate.setup(context)) {
                    return;
                }
                resolvedEffects.add(actionPredicate);
                progressMade = true;
            }
            pendingEffects.removeAll(resolvedEffects);
        } while (progressMade && !pendingEffects.isEmpty());
        if (!pendingEffects.isEmpty()) {
            Miapi.LOGGER.error("COULD NOT EXECUTE ACTION, dependencies were not fullfilled " + String.valueOf(((ActionPredicate)pendingEffects.getFirst()).dependency(context)));
            return;
        }
        for (ActionEffect effect : this.effects) {
            effect.execute(context);
        }
    }
}

