/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.action.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.action.ActionContext;
import smartin.miapi.modules.action.ActionEffect;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

public record DamageActionEffect(String sourceKey, String targetKey, boolean useWeaponOnHit, boolean useEnchants, Optional<String> item, DoubleOperationResolvable value, class_2960 type) implements ActionEffect
{
    public static final class_2960 TYPE = Miapi.id("damage_action_effect");
    public static final Codec<DamageActionEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("source").forGetter(DamageActionEffect::sourceKey), (App)Codec.STRING.fieldOf("target").forGetter(DamageActionEffect::targetKey), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("use_weapon_effects", (Object)true).forGetter(DamageActionEffect::useWeaponOnHit), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("use_enchants", (Object)true).forGetter(DamageActionEffect::useEnchants), (App)Codec.STRING.optionalFieldOf("item").forGetter(DamageActionEffect::item), (App)DoubleOperationResolvable.CODEC.fieldOf("damage").forGetter(DamageActionEffect::value), (App)class_2960.field_25139.fieldOf("type").orElse((Object)TYPE).forGetter(DamageActionEffect::type)).apply((Applicative)instance, DamageActionEffect::new));

    @Override
    public List<String> dependency(ActionContext context) {
        return List.of(this.sourceKey, this.targetKey);
    }

    @Override
    public boolean setup(ActionContext context) {
        boolean sourceExists = context.getObject(class_1297.class, this.sourceKey).isPresent();
        boolean targetsExist = context.getList(class_1297.class, this.targetKey).isPresent();
        return sourceExists && targetsExist;
    }

    @Override
    public void execute(ActionContext context) {
        Optional<class_1799> opt;
        Optional<class_1297> sourceOpt = context.getObject(class_1297.class, this.sourceKey);
        Optional<List<class_1297>> targetsOpt = context.getList(class_1297.class, this.targetKey);
        class_1799 itemStack = context.contextItem;
        if (this.item.isPresent() && (opt = context.getObject(class_1799.class, this.item().get())).isPresent()) {
            itemStack = opt.get();
        }
        if (sourceOpt.isPresent() && targetsOpt.isPresent()) {
            class_1297 sourceEntity = sourceOpt.get();
            List<class_1297> targetEntities = targetsOpt.get();
            class_6880 damageType = (class_6880)((class_2378)context.level.method_30349().method_33310(class_7924.field_42534).get()).method_55841(this.type).get();
            class_1282 damageSource = new class_1282(damageType, sourceEntity);
            for (class_1297 targetEntity : targetEntities) {
                float bonusDamage = 0.0f;
                if (this.useEnchants() && itemStack != null) {
                    if (sourceEntity instanceof class_1657) {
                        class_1657 player = (class_1657)sourceEntity;
                        if (targetEntity instanceof class_1309) {
                            class_1309 livingTarget = (class_1309)targetEntity;
                            itemStack.method_7979(livingTarget, player);
                        }
                    }
                    bonusDamage = itemStack.method_7909().method_58403(targetEntity, (float)this.value().getValue(), damageSource);
                }
                if (this.useEnchants()) {
                    bonusDamage += class_1890.method_60120((class_3218)context.level, (class_1799)itemStack, (class_1297)targetEntity, (class_1282)damageSource, (float)((float)this.value().getValue()));
                }
                targetEntity.method_5643(damageSource, (float)this.value().getValue() + bonusDamage);
                if (!this.useEnchants()) continue;
                class_1890.method_60619((class_3218)context.level, (class_1297)sourceEntity, (class_1282)damageSource, (class_1799)itemStack);
            }
        }
    }

    @Override
    public DamageActionEffect initialize(ModuleInstance moduleInstance) {
        return new DamageActionEffect(this.sourceKey(), this.targetKey(), this.useWeaponOnHit(), this.useEnchants(), this.item(), this.value().initialize(moduleInstance), this.type());
    }

    @Override
    public class_2960 getType() {
        return TYPE;
    }
}

