/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.cache;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.platform.Platform;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_9135;
import net.minecraft.server.MinecraftServer;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.network.modern.ModernNetworking;

public class CacheCommands {
    public static String SEND_MATERIAL_CLIENT = "miapi_drop_cache";
    public static class_2960 CLEAR_CACHE_PACKET_ID = Miapi.id("clear_cache");

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder literal = (LiteralArgumentBuilder)class_2170.method_9247((String)"miapi").then(class_2170.method_9247((String)"clear_cache").executes(CacheCommands::executeCacheClear));
        LiteralArgumentBuilder reloadCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"miapi").then(class_2170.method_9247((String)"miapi_reload").executes(CacheCommands::executeMiapiReload));
        LiteralArgumentBuilder testCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"miapi").then(class_2170.method_9247((String)"test").executes(CacheCommands::executeMiapiReload));
        dispatcher.register(literal);
        dispatcher.register(reloadCommand);
        dispatcher.register(testCommand);
        ModernNetworking.registerC2SReceiver(CLEAR_CACHE_PACKET_ID, class_9135.method_56896(Miapi.FIXED_BOOL_CODEC), (data, player, registryAccess) -> ((MiapiEvents.EmptyEvent)MiapiEvents.CLEAR_CACHE.invoker()).onReload());
        ModernNetworking.registerS2CReceiver(CLEAR_CACHE_PACKET_ID, class_9135.method_56896(Miapi.FIXED_BOOL_CODEC), (data, player, registryAccess) -> ((MiapiEvents.EmptyEvent)MiapiEvents.CLEAR_CACHE.invoker()).onReload());
    }

    private static int executeCacheClear(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Clearing all miapi Caches"), false);
        CacheCommands.clearCacheAllClients(((class_2168)context.getSource()).method_9211());
        ((MiapiEvents.EmptyEvent)MiapiEvents.CLEAR_CACHE.invoker()).onReload();
        return 1;
    }

    public static void clearCacheAllClients(MinecraftServer server) {
        server.method_3760().method_14571().forEach(CacheCommands::reloadPlayerFromServer);
    }

    public static void reloadPlayerFromServer(class_3222 p) {
        ModernNetworking.sendToPlayer(CLEAR_CACHE_PACKET_ID, (class_1657)p, class_9135.method_56896(Miapi.FIXED_BOOL_CODEC), true);
    }

    private static int executeMiapiReload(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"starting reload"), false);
        CacheCommands.triggerServerReload();
        return 1;
    }

    private static int executeMiapiTest(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"starting reload"), false);
        CacheCommands.triggerServerReload();
        return 1;
    }

    public static void triggerServerReload() {
        if (Platform.getEnv() == EnvType.CLIENT && class_310.method_1551().method_18854()) {
            ReloadEvents.requestClientSideDataReload(true);
            return;
        }
        if (Miapi.server == null) {
            ReloadEvents.requestClientSideDataReload(true);
            return;
        }
        Miapi.server.execute(() -> {
            ++ReloadEvents.reloadCounter;
            MiapiEvents.ReloadEventData data = new MiapiEvents.ReloadEventData();
            data.data = new LinkedHashMap<class_2960, String>();
            data.data.putAll(ReloadEvents.RAW_DATA_PACKS);
            ((MiapiEvents.ReloadEvent)MiapiEvents.ADJUST_RAW_DATA.invoker()).onReload(data);
            ReloadEvents.START.fireEvent(false, (class_5455)Miapi.server.method_30611());
            ReloadEvents.DataPackLoader.trigger(data.data);
            ReloadEvents.MAIN.fireEvent(false, (class_5455)Miapi.server.method_30611());
            ReloadEvents.END.fireEvent(false, (class_5455)Miapi.server.method_30611());
            ReloadEvents.reloadCounter = 0;
            Miapi.server.method_3760().method_14571().forEach(ReloadEvents::triggerReloadOnClient);
            ((MiapiEvents.EmptyEvent)MiapiEvents.POST_HOT_RELOAD.invoker()).onReload();
            ((MiapiEvents.EmptyEvent)MiapiEvents.CLEAR_CACHE.invoker()).onReload();
        });
    }

    static ArgumentType<String> getArgumentType() {
        return new ArgumentType<String>(){

            public String parse(StringReader reader) {
                return reader.getRead();
            }

            public Collection<String> getExamples() {
                return CacheCommands.getMaterialOptions();
            }
        };
    }

    private static List<String> getMaterialOptions() {
        return MaterialProperty.MATERIAL_REGISTRY.getFlatMap().keySet().stream().map(class_2960::toString).toList();
    }
}

