/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import smartin.miapi.modules.ModuleInstance;

public class DataCache {
    public static Map<String, ItemCacheSupplier> ITEM_CACHE_SUPPLIER = new HashMap<String, ItemCacheSupplier>();
    public static Map<String, ModuleCacheSupplier> MODULE_CACHE_SUPPLIER = new HashMap<String, ModuleCacheSupplier>();
    Map<String, Object> cacheContents = new ConcurrentHashMap<String, Object>();

    public <T> T get(String key, Supplier<T> fallback) {
        return (T)this.cacheContents.computeIfAbsent(key, s -> fallback.get());
    }

    public static <T, B> T get(Map<String, Object> cacheContents, Map<String, Function<B, T>> supplier, B context, String key, Supplier<T> fallback) {
        if (cacheContents.containsKey(key)) {
            return (T)cacheContents.get(key);
        }
        T result = supplier.get(key).apply(context);
        if (result == null) {
            return fallback.get();
        }
        return result;
    }

    public static interface ModuleCacheSupplier
    extends Function<ModuleInstance, Object> {
        @Override
        public Object apply(ModuleInstance var1);
    }

    public static interface ItemCacheSupplier
    extends Function<class_1799, Object> {
        @Override
        public Object apply(class_1799 var1);
    }
}

