/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.cache;

import dev.architectury.event.EventResult;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.cache.DataCache;

public class ModularItemCache {
    protected static Map<String, CacheObjectSupplier> supplierMap = new ConcurrentHashMap<String, CacheObjectSupplier>();
    public static Map<String, DataCache.ModuleCacheSupplier> MODULE_CACHE_SUPPLIER = new ConcurrentHashMap<String, DataCache.ModuleCacheSupplier>();
    public static ConcurrentWeakInstanceTracker<ModuleInstance> modules = new ConcurrentWeakInstanceTracker();

    public static void setSupplier(String key, CacheObjectSupplier supplier) {
        supplierMap.put(key, supplier);
    }

    @Nullable
    public static <T> T getRaw(class_1799 stack, String key) {
        return ModularItemCache.get(stack, key, null);
    }

    public static <T> T get(class_1799 stack, String key, T fallback) {
        return (T)ModularItemCache.get(stack, key, () -> fallback);
    }

    public static <T> T get(class_1799 stack, String key, Supplier<T> fallback) {
        ModuleInstance moduleInstance = ItemModule.getModules(stack);
        if (moduleInstance != null) {
            return moduleInstance.getFromCache(key, stack, supplierMap, fallback);
        }
        return fallback.get();
    }

    public static void clear(class_1799 stack, String key) {
        ModuleInstance moduleInstance = ItemModule.getModules(stack);
        if (moduleInstance != null) {
            moduleInstance.cachedData.remove(key);
        }
    }

    public static <T> T getVisualOnlyCache(class_1799 stack, String key, T fallback) {
        if (!ReloadEvents.isInReload() && !stack.method_7960() && VisualModularItem.isVisualModularItem(stack)) {
            return (T)ModularItemCache.get(stack, key, () -> fallback);
        }
        return fallback;
    }

    public static void discardCache() {
        modules.getInstances().forEach(m -> {
            if (m != null) {
                m.clearCaches();
                if (m.parent == null && m.contextStack != null) {
                    m.writeToItem(m.contextStack);
                }
            }
        });
    }

    static {
        MiapiEvents.CLEAR_CACHE.register((Object)new MiapiEvents.EmptyEvent(){

            @Override
            public EventResult onReload() {
                ModularItemCache.discardCache();
                return EventResult.pass();
            }
        });
    }

    public static class ConcurrentWeakInstanceTracker<T> {
        private final ReferenceQueue<T> refQueue = new ReferenceQueue();
        private final ConcurrentHashMap<WeakReference<T>, Boolean> instanceMap = new ConcurrentHashMap();

        public void addInstance(T instance) {
            this.cleanup();
            WeakReference<T> ref = new WeakReference<T>(instance, this.refQueue);
            this.instanceMap.put(ref, Boolean.TRUE);
        }

        public Set<T> getInstances() {
            this.cleanup();
            HashSet result = new HashSet();
            for (WeakReference ref : this.instanceMap.keySet()) {
                Object obj = ref.get();
                if (obj == null) continue;
                result.add(obj);
            }
            return result;
        }

        private void cleanup() {
            WeakReference ref;
            while ((ref = (WeakReference)this.refQueue.poll()) != null) {
                this.instanceMap.remove(ref);
            }
        }
    }

    public static interface CacheObjectSupplier
    extends Function<class_1799, Object> {
        @Override
        public Object apply(class_1799 var1);
    }
}

