/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.edit_options.skins;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.handler.codec.DecoderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_5253;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.PropertyHolder;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.edit_options.skins.SkinOptions;
import smartin.miapi.modules.edit_options.skins.TextureOptions;
import smartin.miapi.modules.properties.tag.ModuleTagProperty;
import smartin.miapi.registries.RegistryInventory;

public class Skin {
    public String path;
    public String modID;
    public String type;
    public ItemModule module;
    public ModuleCondition condition;
    public PropertyHolder propertyHolder;
    public TextureOptions textureOptions = new TextureOptions(Miapi.id("textures/gui/skin/skin_button.png"), 100, 16, 3, class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255), 1, false);
    @Nullable
    public class_2561 hoverDescription;

    public static List<Skin> fromJson(JsonElement element) {
        JsonObject jsonObject = element.getAsJsonObject();
        ArrayList<Skin> skins = new ArrayList<Skin>();
        Skin.getModules(element).forEach(itemModule -> {
            Skin skin = new Skin();
            skin.module = itemModule;
            skin.condition = ConditionManager.get(jsonObject.get("condition"));
            skin.path = jsonObject.get("path").getAsString();
            skin.propertyHolder = (PropertyHolder)((Pair)PropertyHolder.MAP_CODEC.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(s -> new DecoderException("Failed to decode skin !" + s))).getFirst();
            skin.textureOptions = TextureOptions.fromJson(jsonObject.get("texture"), Miapi.id("textures/gui/skin/skin_button.png"), 100, 16, 3, class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
            if (jsonObject.has("hover")) {
                skin.hoverDescription = (class_2561)class_8824.field_46597.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.getAsJsonObject("hover")).result().orElse(class_2561.method_43473());
            }
            skin.type = jsonObject.has("type") ? jsonObject.get("type").getAsString() : "model";
            skins.add(skin);
        });
        return skins;
    }

    public static List<Skin> getSkins(ModuleInstance moduleInstance) {
        JsonElement element = moduleInstance.moduleData.get(Miapi.id("skin"));
        ArrayList<Skin> result = new ArrayList<Skin>();
        if (element != null) {
            Map<String, Skin> moduleSkins = SkinOptions.skins.get(moduleInstance.getModule().id());
            if (moduleSkins == null) {
                return result;
            }
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                Skin skin = moduleSkins.get(element.getAsString());
                if (skin != null) {
                    result.add(skin);
                }
            } else if (element.isJsonArray()) {
                for (JsonElement item : element.getAsJsonArray()) {
                    Skin skin;
                    if (!item.isJsonPrimitive() || !item.getAsJsonPrimitive().isString() || (skin = moduleSkins.get(item.getAsString())) == null) continue;
                    result.add(skin);
                }
            }
        }
        return result;
    }

    public static void writeSkins(ModuleInstance moduleInstance, List<Skin> skinKeys) {
        JsonArray array = new JsonArray();
        for (Skin key : skinKeys) {
            if (key == null || key.path == null) continue;
            array.add((JsonElement)new JsonPrimitive(key.path));
        }
        moduleInstance.moduleData.put(Miapi.id("skin"), (JsonElement)array);
    }

    public static void writeSkinsKeys(ModuleInstance moduleInstance, List<String> skinKeys) {
        JsonArray array = new JsonArray();
        for (String key : skinKeys) {
            array.add((JsonElement)new JsonPrimitive(key));
        }
        moduleInstance.moduleData.put(Miapi.id("skin"), (JsonElement)array);
    }

    public static List<ItemModule> getModules(JsonElement element) {
        JsonObject jsonObject = element.getAsJsonObject();
        ArrayList<ItemModule> modules = new ArrayList<ItemModule>();
        if (jsonObject.has("module_tags")) {
            jsonObject.get("module_tags").getAsJsonArray().asList().forEach(jsonElement -> modules.addAll(ModuleTagProperty.getModulesWithTag(jsonElement.getAsString())));
        }
        if (jsonObject.has("module")) {
            JsonElement moduleElement = jsonObject.get("module");
            if (moduleElement.isJsonArray()) {
                jsonObject.get("module").getAsJsonArray().asList().forEach(jsonElement -> {
                    ItemModule itemModule = RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.get(jsonElement.getAsString());
                    if (itemModule != null) {
                        modules.add(itemModule);
                    }
                });
            } else {
                ItemModule itemModule = RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.get(jsonObject.get("module").getAsString());
                if (itemModule != null) {
                    modules.add(itemModule);
                }
            }
        }
        return modules;
    }
}

