/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.edit_options.skins.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5253;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.edit_options.skins.Skin;
import smartin.miapi.modules.edit_options.skins.SkinOptions;
import smartin.miapi.modules.edit_options.skins.SkinTab;
import smartin.miapi.modules.edit_options.skins.gui.SkinButton;
import smartin.miapi.modules.edit_options.skins.gui.SkinGui;

class SkinTabGui
extends InteractAbleWidget
implements SkinGui.SortAble {
    class_2960 arrowTexture = Miapi.id("textures/gui/skin/arrow.png");
    boolean isOpen = true;
    List<SkinGui.SortAble> fullList = new ArrayList<SkinGui.SortAble>();
    List<SkinGui.SortAble> currentList;
    ScrollingTextWidget textWidget;
    String sortAble;
    int spacing = 10;
    int realHeight = 14;
    public SkinTabGui parent;
    static final int SIZE_Y = 14;
    final boolean isRoot;
    final SkinTab tabInfo;

    public SkinTabGui(SkinGui skinGui, int x, int y, int width, String currentTab, Map<String, Skin> mapsToDo) {
        super(x, y, width, 14, (class_2561)class_2561.method_43473());
        this.tabInfo = SkinOptions.getTag(currentTab);
        this.field_22759 = this.realHeight;
        this.isRoot = currentTab.isBlank();
        if (this.isRoot) {
            this.field_22759 = 0;
            this.realHeight = 0;
            this.spacing = 0;
            SkinButton child = new SkinButton(skinGui, x + this.spacing, y, width - this.spacing, "", new Skin());
            this.fullList.add(child);
        }
        String[] parts = currentTab.split("/");
        int partLength = parts.length;
        if (this.isRoot) {
            partLength = 0;
        }
        class_2561 skinName = StatResolver.translateAndResolve("miapi.skin.name." + parts[parts.length - 1], skinGui.instance);
        this.sortAble = skinName.getString();
        this.textWidget = new ScrollingTextWidget(x + 12, y + 1, width - 13, skinName, class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
        HashMap<String, Map> toDoMap = new HashMap<String, Map>();
        for (Map.Entry<String, Skin> entry : mapsToDo.entrySet()) {
            String skinPath = entry.getKey();
            String[] pathParts = skinPath.split("/");
            if (!skinPath.startsWith(currentTab + "/") && !this.isRoot) continue;
            if (partLength + 1 == pathParts.length) {
                this.fullList.add(new SkinButton(skinGui, x + this.spacing, y, width - this.spacing, skinPath, entry.getValue()));
                continue;
            }
            String nextPart = pathParts[partLength];
            Object nextTab = currentTab + "/" + nextPart;
            if (this.isRoot) {
                nextTab = nextPart;
            }
            Map subMap = toDoMap.computeIfAbsent((String)nextTab, k -> new HashMap());
            subMap.put(nextTab, entry.getValue());
        }
        toDoMap.forEach((tab, map) -> {
            SkinTabGui child = new SkinTabGui(skinGui, x + this.spacing, y, width - this.spacing, (String)tab, mapsToDo);
            child.parent = this;
            this.fullList.add(child);
        });
        this.currentList = new ArrayList<SkinGui.SortAble>(this.fullList);
        this.setChildren(true);
        if (!this.isRoot) {
            this.toggleOpen();
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseY < (double)(this.method_46427() + this.realHeight)) {
            this.toggleOpen();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void toggleOpen() {
        if (this.isOpen) {
            this.currentList.clear();
            this.field_22759 = this.realHeight;
            this.setChildren(false);
        } else {
            this.currentList = new ArrayList<SkinGui.SortAble>(this.fullList);
            this.setChildren(false);
        }
        this.isOpen = !this.isOpen;
    }

    private boolean isMouseOverReal(double mouseX, double mouseY) {
        return mouseY > (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.realHeight) && mouseX > (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758);
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.setChildren(true);
    }

    @Override
    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        if (!this.isRoot) {
            int offset = this.isOpen ? 10 : 0;
            int hover = this.isOpen ? this.tabInfo.header.ySize() * 2 : 0;
            hover = this.isMouseOverReal(mouseX, mouseY) ? this.tabInfo.header.ySize() : hover;
            SkinTabGui.drawTextureWithEdge(drawContext, this.arrowTexture, this.method_46426(), this.method_46427() + 2, offset, 0, 10, 10, 10, 10, 20, 10, 3);
            SkinTabGui.drawTextureWithEdgeAndScale(drawContext, this.tabInfo.header.texture(), this.method_46426(), this.method_46427(), 0, hover, this.tabInfo.header.xSize(), this.tabInfo.header.ySize(), this.field_22758, this.realHeight, this.tabInfo.header.xSize(), this.tabInfo.header.ySize() * 3, this.tabInfo.header.borderSize(), this.tabInfo.header.scale());
            if (this.isOpen) {
                if (this.tabInfo.background.keepScale()) {
                    drawContext.method_25290(this.tabInfo.background.texture(), this.method_46426(), this.method_46427() + this.realHeight, (float)this.field_22758, (float)(this.field_22759 - this.realHeight), 0, 0, this.tabInfo.background.xSize(), this.tabInfo.background.ySize());
                } else {
                    SkinTabGui.drawTextureWithEdgeAndScale(drawContext, this.tabInfo.background.texture(), this.method_46426(), this.method_46427() + this.realHeight, 0, 0, this.tabInfo.background.xSize(), this.tabInfo.background.ySize(), this.field_22758, this.field_22759 - this.realHeight, this.tabInfo.background.xSize(), this.tabInfo.background.ySize(), this.tabInfo.background.borderSize(), this.tabInfo.background.scale());
                }
            }
            this.textWidget.method_46419(this.method_46427() + 2);
            this.textWidget.method_25394(drawContext, mouseX, mouseY, delta);
        }
        super.method_48579(drawContext, mouseX, mouseY, delta);
    }

    private void setChildren(boolean updateChildren) {
        if (this.parent == null) {
            updateChildren = true;
        }
        this.children().clear();
        int yHeight = this.method_46427() + this.realHeight;
        for (SkinGui.SortAble sortableElement : this.currentList) {
            if (!(sortableElement instanceof InteractAbleWidget)) continue;
            InteractAbleWidget widget = (InteractAbleWidget)((Object)sortableElement);
            if (!sortableElement.method_37303()) continue;
            widget.method_46419(yHeight);
            yHeight += widget.method_25364();
            this.addChild(widget);
            if (!(widget instanceof SkinTabGui)) continue;
            SkinTabGui tab = (SkinTabGui)widget;
            if (!updateChildren) continue;
            tab.setChildren(true);
        }
        this.field_22759 = yHeight - this.method_46427();
        if (!updateChildren) {
            this.parent.setChildren(false);
        }
    }

    @Override
    public void filter(String search) {
        for (SkinGui.SortAble element : this.fullList) {
            element.filter(search);
        }
        this.setChildren(true);
    }

    @Override
    public String sortAndGetTop() {
        this.fullList.sort(Comparator.comparing(SkinGui.SortAble::sortAndGetTop));
        this.currentList = new ArrayList<SkinGui.SortAble>(this.fullList);
        this.setChildren(true);
        return "." + this.fullList.get(0).sortAndGetTop();
    }

    @Override
    public boolean method_37303() {
        boolean isEnabled = false;
        for (SkinGui.SortAble element : this.fullList) {
            if (!element.method_37303()) continue;
            isEnabled = true;
        }
        return isEnabled;
    }
}

