/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class ComponentProperty
extends CodecProperty<Map<class_2960, JsonElement>>
implements ComponentApplyProperty,
CraftingProperty {
    public static Codec<Map<class_2960, JsonElement>> CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, StatResolver.Codecs.JSONELEMENT_CODEC);
    public static final class_2960 KEY = Miapi.id("components");
    public static ComponentProperty property;

    public ComponentProperty() {
        super(CODEC);
        property = this;
    }

    @Override
    public void updateComponent(class_1799 itemStack, @Nullable class_5455 registryAccess) {
        this.getData(itemStack).ifPresent(map -> map.forEach((id, json) -> {
            try {
                class_9331 type = (class_9331)class_7923.field_49658.method_10223(id);
                if (type == null) {
                    Miapi.LOGGER.error("could not find Component Type " + String.valueOf(type));
                } else {
                    this.update((class_9331)type, (JsonElement)json, itemStack);
                }
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("Could not apply component " + String.valueOf(id));
                Miapi.LOGGER.error("raw data " + String.valueOf(json));
            }
        }));
    }

    @Override
    public Map<class_2960, JsonElement> initialize(Map<class_2960, JsonElement> property, ModuleInstance context) {
        ConcurrentHashMap<class_2960, JsonElement> map = new ConcurrentHashMap<class_2960, JsonElement>();
        property.forEach((id, element) -> map.put((class_2960)id, this.deepParse((JsonElement)element, context)));
        return map;
    }

    public <T> void update(class_9331<T> type, JsonElement element, class_1799 itemStack) {
        DataResult result = type.method_57875().decode((DynamicOps)JsonOps.INSTANCE, (Object)element);
        if (result.isError()) {
            throw new RuntimeException("Could not decode Data Component ");
        }
        itemStack.method_57379(type, ((Pair)result.getOrThrow()).getFirst());
    }

    public JsonElement deepParse(JsonElement element, ModuleInstance context) {
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            JsonObject next = new JsonObject();
            for (Map.Entry entry : obj.entrySet()) {
                next.add((String)entry.getKey(), this.deepParse((JsonElement)entry.getValue(), context));
            }
            return next;
        }
        if (element.isJsonArray()) {
            JsonArray arr = element.getAsJsonArray();
            JsonArray next = new JsonArray(arr.size());
            for (int i = 0; i < arr.size(); ++i) {
                next.add(arr.get(i));
            }
            return next;
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            String potential = element.getAsString();
            if (potential.startsWith("|||miapi.evaluate")) {
                potential = potential.replace("|||miapi.evaluate", "");
                return new JsonPrimitive((Number)StatResolver.resolveDouble(potential, context));
            }
            return element.deepCopy();
        }
        return element.deepCopy();
    }

    @Override
    public Map<class_2960, JsonElement> merge(Map<class_2960, JsonElement> left, Map<class_2960, JsonElement> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType);
    }

    @Override
    public class_1799 preview(class_1799 old, class_1799 crafting, class_1657 player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<class_1799> inventory, Map<class_2960, JsonElement> data) {
        this.getData(old).ifPresent(map -> map.forEach((id, json) -> {
            try {
                class_9331 type = (class_9331)class_7923.field_49658.method_10223(id);
                if (type == null) {
                    Miapi.LOGGER.error("could not find Component Type " + String.valueOf(type));
                } else {
                    crafting.method_57381(type);
                }
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("Could not apply component " + String.valueOf(id));
                Miapi.LOGGER.error("raw data " + String.valueOf(json));
            }
        }));
        this.updateComponent(crafting, bench.method_10997().method_30349());
        return crafting;
    }
}

