/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_8824;
import org.jetbrains.annotations.NotNull;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.MaterialSmithingRecipe;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.item.modular.ModularItemPart;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.generated.SmithingRecipeUtil;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class LoreProperty
extends CodecProperty<List<Holder>> {
    public static final class_2960 KEY = Miapi.id("item_lore");
    public static LoreProperty property;
    public static List<LoreSupplier> bottomLoreSuppliers;
    public static List<ToolTipSupplierSupplier> loreSuppliers;
    public static Map<class_1799, Material> materialLookupTable;
    public static Map<class_1792, List<class_2561>> smithingTemplate;
    public static final Codec<Holder> CODEC_BASE;
    public static final Codec<Holder> CODEC;

    public LoreProperty() {
        super(Miapi.toListOrSimple(CODEC));
        property = this;
        loreSuppliers.add((itemStack, tooltip, context, tooltipType) -> {
            if (LoreProperty.hasModularItemDescription(itemStack)) {
                tooltip.add(LoreProperty.format((class_2561)class_2561.method_43471((String)"miapi.ui.modular_item"), class_124.field_1080));
            }
            this.getHolders(itemStack).stream().filter(h -> h.position.equals("top")).forEach(holder -> tooltip.add(holder.getText()));
        });
        ReloadEvents.END.subscribe((isClient, registryAccess) -> {
            try {
                smithingTemplate.clear();
                class_1863 recipeManager = SmithingRecipeUtil.findManager(isClient);
                if (recipeManager != null) {
                    recipeManager.method_30027(class_3956.field_25388).forEach(recipeHolder -> {
                        class_1860 patt0$temp = recipeHolder.comp_1933();
                        if (patt0$temp instanceof MaterialSmithingRecipe) {
                            MaterialSmithingRecipe smithingRecipe = (MaterialSmithingRecipe)patt0$temp;
                            List list = smithingTemplate.computeIfAbsent(smithingRecipe.smithingTemplate.method_8105()[0].method_7909(), i -> new ArrayList());
                            Material ingredient = MaterialProperty.MATERIAL_REGISTRY.get(smithingRecipe.startMaterial);
                            Material target = MaterialProperty.MATERIAL_REGISTRY.get(smithingRecipe.resultMaterial);
                            if (ingredient != null && target != null) {
                                class_5250 materialDescription = class_2561.method_43469((String)"miapi.material_template.smithing", (Object[])new Object[]{ingredient.getTranslation().getString(), target.getTranslation().getString()}).method_27692(class_124.field_1080);
                                list.add(materialDescription);
                            }
                        }
                    });
                }
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("could not setup smithing lore injection", (Throwable)e);
            }
        });
    }

    public List<Holder> getHolders(class_1799 itemStack) {
        return this.getData(itemStack).orElse(new ArrayList());
    }

    public static class_2561 gray(class_2561 text) {
        return LoreProperty.format(text, class_124.field_1080);
    }

    public static class_2561 format(class_2561 text, class_124 ... formatting) {
        if (text instanceof class_5250) {
            return ((class_5250)text).method_27696(class_2583.field_24360.method_27705(formatting));
        }
        List components = text.method_36136(class_2583.field_24360.method_27705(formatting));
        if (components.size() > 0) {
            return (class_2561)components.getFirst();
        }
        return class_2561.method_43470((String)text.getString()).method_27696(class_2583.field_24360.method_27705(formatting));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectTooltipOnNonModularItems(List<class_2561> tooltip, class_1799 itemStack) {
        if (!Environment.isClient() && MiapiConfig.getServerConfig().other.serverLoreInjection) {
            return;
        }
        LoreProperty loreProperty = property;
        synchronized (loreProperty) {
            if (Environment.isClient()) {
                tooltip.addAll(this.addToolTipsClient(itemStack));
            } else {
                tooltip.addAll(this.addToolTipsServer(itemStack));
            }
        }
    }

    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    List<class_2561> addToolTipsClient(class_1799 itemStack) {
        List<class_2561> description;
        Material material;
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        if (MiapiConfig.getClientConfig().loreConfig.injectLoreModularMaterial && (material = materialLookupTable.computeIfAbsent(itemStack, itemStack1 -> MaterialProperty.getMaterialFromIngredient(itemStack))) != null) {
            int i = material.getGroups().size();
            if (i == 1) {
                if (MiapiConfig.getClientConfig().loreConfig.injectLoreWithoutGroup) {
                    lines.add(LoreProperty.gray((class_2561)class_2561.method_43471((String)"miapi.ui.material_desc")));
                }
            } else {
                class_2561 materialDesc = LoreProperty.gray((class_2561)class_2561.method_43471((String)"miapi.ui.material_desc_alt"));
                lines.add(materialDesc);
                if (Environment.isClient()) {
                    lines.addAll(this.getAltClient(material));
                }
            }
        }
        if (MiapiConfig.getClientConfig().loreConfig.injectLoreModularItem) {
            if (LoreProperty.hasModularItemDescription(itemStack)) {
                lines.add(LoreProperty.format((class_2561)class_2561.method_43471((String)"miapi.ui.modular_item"), class_124.field_1080));
                return lines;
            }
            class_1799 converted = ModularItemStackConverter.getModularVersion(itemStack);
            if (LoreProperty.hasModularItemDescription(converted)) {
                lines.add(LoreProperty.format((class_2561)class_2561.method_43471((String)"miapi.ui.modular_item"), class_124.field_1080));
                return lines;
            }
        }
        if (MiapiConfig.getClientConfig().loreConfig.injectLoreModularTemplate && (description = smithingTemplate.get(itemStack.method_7909())) != null) {
            lines.add((class_2561)class_2561.method_43471((String)"miapi.material_template.smithing.header").method_27692(class_124.field_1080));
            lines.addAll(description);
        }
        return lines;
    }

    public static boolean hasModularItemDescription(class_1799 itemstack) {
        return VisualModularItem.isVisualModularItem(itemstack) && !LoreProperty.isModularPart(itemstack);
    }

    public static boolean isModularPart(class_1799 itemstack) {
        return itemstack.method_7909() instanceof ModularItemPart;
    }

    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    List<class_2561> getAltClient(Material material) {
        return new ArrayList<class_2561>(material.getDescription(class_437.method_25443()));
    }

    List<class_2561> addToolTipsServer(class_1799 itemStack) {
        class_1799 converted;
        Material material;
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        if (MiapiConfig.getClientConfig().loreConfig.injectLoreModularMaterial && (material = materialLookupTable.computeIfAbsent(itemStack, itemStack1 -> MaterialProperty.getMaterialFromIngredient(itemStack))) != null) {
            int i = material.getGroups().size();
            if (i == 1) {
                if (MiapiConfig.getClientConfig().loreConfig.injectLoreWithoutGroup) {
                    lines.add(LoreProperty.gray((class_2561)class_2561.method_43471((String)"miapi.ui.material_desc")));
                }
            } else {
                class_2561 materialDesc = LoreProperty.gray((class_2561)class_2561.method_43471((String)"miapi.ui.material_desc_alt"));
                lines.add(materialDesc);
            }
        }
        if (MiapiConfig.getClientConfig().loreConfig.injectLoreModularItem && !class_1799.method_7973((class_1799)(converted = ModularItemStackConverter.getModularVersion(itemStack)), (class_1799)itemStack) && LoreProperty.hasModularItemDescription(converted)) {
            lines.add(LoreProperty.format((class_2561)class_2561.method_43471((String)"miapi.ui.modular_item"), class_124.field_1080));
        }
        return lines;
    }

    public static void appendLoreTop(class_1799 stack, List<class_2561> tooltip, class_1792.class_9635 context, class_1836 tooltipType) {
        loreSuppliers.forEach(supplierSupplier -> supplierSupplier.getLore(stack, tooltip, context, tooltipType));
    }

    public void appendLoreBottom(List<class_2561> oldLore, class_1799 itemStack) {
        bottomLoreSuppliers.forEach(loreSupplier -> oldLore.addAll(loreSupplier.getLore(itemStack)));
        this.getHolders(itemStack).stream().filter(h -> h.position.equals("bottom")).forEach(holder -> oldLore.add(holder.getText()));
    }

    @Override
    public List<Holder> merge(List<Holder> left, List<Holder> right, MergeType mergeType) {
        return MergeAble.mergeList(left, right, mergeType);
    }

    static {
        bottomLoreSuppliers = Collections.synchronizedList(new ArrayList());
        loreSuppliers = Collections.synchronizedList(new ArrayList());
        materialLookupTable = Collections.synchronizedMap(new WeakHashMap());
        smithingTemplate = Collections.synchronizedMap(new WeakHashMap());
        CODEC_BASE = RecordCodecBuilder.create(instance -> instance.group((App)class_8824.field_46597.fieldOf("text").forGetter(holder -> holder.text), (App)Codec.STRING.fieldOf("position").forGetter(holder -> holder.position), (App)Codec.FLOAT.optionalFieldOf("priority", (Object)Float.valueOf(0.0f)).forGetter(holder -> Float.valueOf(holder.priority))).apply((Applicative)instance, Holder::new));
        CODEC = Codec.withAlternative(CODEC_BASE, (Codec)class_8824.field_46597.xmap(Holder::new, h -> h.text));
    }

    public static interface ToolTipSupplierSupplier {
        public void getLore(class_1799 var1, List<class_2561> var2, class_1792.class_9635 var3, class_1836 var4);
    }

    public static class Holder
    implements Comparable<Holder> {
        @CodecBehavior.Optional
        public class_2561 text;
        @CodecBehavior.Optional(value=false)
        public String position;
        @CodecBehavior.Optional
        public float priority = 0.0f;

        public Holder() {
        }

        public Holder(class_2561 component, String position, float priority) {
            this.text = component;
            this.position = position;
            this.priority = priority;
        }

        public Holder(class_2561 component) {
            this.text = component;
            this.position = "top";
        }

        public class_2561 getText() {
            if (this.text != null) {
                return this.text;
            }
            return class_2561.method_43473();
        }

        @Override
        public int compareTo(@NotNull Holder o) {
            return Float.compare(this.priority, o.priority);
        }
    }

    public static interface LoreSupplier {
        public List<class_2561> getLore(class_1799 var1);
    }
}

