/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.IngredientController;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class RepairPriority
extends DoubleProperty {
    public static RepairPriority property;
    public static final class_2960 KEY;

    public RepairPriority() {
        super(KEY);
        property = this;
        this.allowVisualOnly = true;
        ModularItemCache.setSupplier(String.valueOf(KEY) + "_materials", this::getRepairMaterialsPrivate);
    }

    public List<Material> getRepairMaterials(class_1799 itemStack) {
        return ModularItemCache.getVisualOnlyCache(itemStack, String.valueOf(KEY) + "_materials", new ArrayList());
    }

    public static double getRepairValue(class_1799 tool, class_1799 material) {
        double highestValue = 0.0;
        for (Material material1 : property.getRepairMaterials(tool)) {
            highestValue = Math.max(highestValue, material1.getRepairValueOfItem(material));
        }
        return highestValue;
    }

    public static class_1856 getRepairIngredient(class_1799 itemStack) {
        return IngredientController.mergeIngredients(property.getRepairMaterials(itemStack).stream().map(IngredientController::getRepairIngredient));
    }

    private List<Material> getRepairMaterialsPrivate(class_1799 itemStack) {
        Material material;
        Optional<Double> optional;
        double lowest = Double.MAX_VALUE;
        ArrayList<Material> materials = new ArrayList<Material>();
        for (ModuleInstance moduleInstance : ItemModule.getModules(itemStack).allSubModules()) {
            optional = this.getValue(itemStack);
            if (!optional.isPresent() || (material = MaterialProperty.getMaterial(moduleInstance)) == null || !(lowest > optional.get())) continue;
            lowest = optional.get();
        }
        for (ModuleInstance moduleInstance : ItemModule.getModules(itemStack).allSubModules()) {
            optional = this.getValue(itemStack);
            if (!optional.isPresent() || (material = MaterialProperty.getMaterial(moduleInstance)) == null || !(Math.abs(lowest - optional.get()) < 0.001)) continue;
            materials.add(material);
        }
        return materials;
    }

    @Override
    public Optional<DoubleOperationResolvable> getData(class_1799 itemStack) {
        if (itemStack == null) {
            return Optional.empty();
        }
        if (!VisualModularItem.isVisualModularItem(itemStack)) {
            return Optional.empty();
        }
        if (ReloadEvents.isInReload()) {
            return Optional.empty();
        }
        ModuleInstance baseModule = ItemModule.getModules(itemStack);
        if (baseModule == null || baseModule.getModule() == ItemModule.empty) {
            return Optional.empty();
        }
        return Optional.ofNullable(baseModule.getPropertyItemStack(this));
    }

    static {
        KEY = Miapi.id("repair_priority");
    }
}

