/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.enchanment;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7924;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class CraftingEnchantProperty
extends CodecProperty<Map<class_2960, DoubleOperationResolvable>>
implements ComponentApplyProperty {
    public static final class_2960 KEY = Miapi.id("crafting_enchants");
    public static CraftingEnchantProperty property;
    public static Codec<Map<class_2960, DoubleOperationResolvable>> CODEC;

    public CraftingEnchantProperty() {
        super(CODEC);
        property = this;
    }

    @Override
    public void updateComponent(class_1799 itemStack, class_5455 registryAccess) {
        this.getData(itemStack).ifPresent(stringDoubleOperationResolvableMap -> class_1890.method_57531((class_1799)itemStack, mutable -> stringDoubleOperationResolvableMap.forEach((enchantmentID, value) -> {
            try {
                CraftingEnchantProperty.tryAndLookUp(enchantmentID, ItemModule.getModules(itemStack)).ifPresent(enchantment -> {
                    int prevLevel = mutable.method_57546(enchantment);
                    value.setFunctionTransformer(s -> ((String)s.getFirst()).replace("[old_level]", String.valueOf(prevLevel)));
                    int nextLevel = (int)value.evaluate(0.0, prevLevel);
                    if (MiapiConfig.getServerConfig().other.verboseLogging) {
                        Miapi.LOGGER.info("updated level to " + String.valueOf(((class_1887)enchantment.comp_349()).comp_2686()) + " " + nextLevel);
                    }
                    mutable.method_57547(enchantment, nextLevel);
                });
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.info("failed to apply enchantments!", (Throwable)e);
            }
        })));
    }

    public static Map<class_6880<class_1887>, DoubleOperationResolvable> tryConvert(Map<class_2960, DoubleOperationResolvable> original, class_1799 itemStack) {
        HashMap<class_6880<class_1887>, DoubleOperationResolvable> mapped = new HashMap<class_6880<class_1887>, DoubleOperationResolvable>();
        original.forEach((id, ench) -> CraftingEnchantProperty.tryAndLookUp(id, itemStack).ifPresent(holder -> mapped.put((class_6880<class_1887>)holder, (DoubleOperationResolvable)ench)));
        return mapped;
    }

    public static Optional<class_6880<class_1887>> tryAndLookUp(class_2960 id, class_1799 reference) {
        return CraftingEnchantProperty.tryAndLookUp(id, ItemModule.getModules(reference));
    }

    public static Optional<class_6880<class_1887>> tryAndLookUp(class_2960 id, ModuleInstance reference) {
        if (reference.registryAccess == null || reference.lookup == null) {
            return Optional.empty();
        }
        class_2378 registry = (class_2378)reference.registryAccess.method_33310(class_7924.field_41265).get();
        class_5321 enchantmentResourceKey = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)id);
        Optional lookup = reference.lookup.method_46623(class_7924.field_41265);
        if (lookup.isEmpty()) {
            Miapi.LOGGER.info("Enchantment Registry could not be found!");
            return Optional.empty();
        }
        try {
            Optional optional = ((class_6903.class_7862)lookup.get()).comp_1131().method_46746(enchantmentResourceKey);
            if (optional.isEmpty()) {
                Miapi.LOGGER.info("could not find enchantment " + String.valueOf(id));
                return Optional.empty();
            }
            return Optional.of((class_6880)((class_6903.class_7862)lookup.get()).comp_1131().method_46746(enchantmentResourceKey).get());
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.warn("could not properly lookup enchantments!", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Map<class_2960, DoubleOperationResolvable> initialize(Map<class_2960, DoubleOperationResolvable> property, ModuleInstance context) {
        LinkedHashMap<class_2960, DoubleOperationResolvable> init = new LinkedHashMap<class_2960, DoubleOperationResolvable>();
        property.forEach((key, value) -> init.put((class_2960)key, value.initialize(context)));
        return init;
    }

    @Override
    public Map<class_2960, DoubleOperationResolvable> merge(Map<class_2960, DoubleOperationResolvable> left, Map<class_2960, DoubleOperationResolvable> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType);
    }

    static {
        CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, DoubleOperationResolvable.CODEC);
    }
}

