/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.enchanment;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import smartin.miapi.Miapi;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class EnchantAbilityProperty
extends DoubleProperty {
    public static final class_2960 KEY = Miapi.id("enchantability");
    public static EnchantAbilityProperty property;

    public EnchantAbilityProperty() {
        super(KEY);
        property = this;
    }

    public static double getEnchantAbility(class_1799 itemStack) {
        ModuleInstance moduleInstance = ItemModule.getModules(itemStack);
        if (moduleInstance == null || moduleInstance.getModule().isEmpty()) {
            return 15.0;
        }
        List<ModuleInstance> moduleInstances = moduleInstance.allSubModules();
        List enchantAbilities = moduleInstances.stream().map(EnchantAbilityProperty::getEnchantAbility).sorted().collect(Collectors.toList());
        if (enchantAbilities.isEmpty()) {
            return 15.0;
        }
        if (enchantAbilities.size() > 1) {
            enchantAbilities.removeFirst();
        }
        return enchantAbilities.stream().mapToDouble(Double::doubleValue).average().orElse(15.0);
    }

    public static double getEnchantAbility(ModuleInstance instance) {
        Optional resolvableOptional = property.getData(instance);
        if (resolvableOptional.isPresent()) {
            return ((DoubleOperationResolvable)resolvableOptional.get()).evaluate(0.0, 15.0);
        }
        Material material = MaterialProperty.getMaterial(instance);
        if (material != null) {
            return Math.max(1.0, material.getDouble("enchantability"));
        }
        return 15.0;
    }
}

